/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.brewing.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockCake;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import svenhjol.charm.brewing.block.FlavoredCakeStateMapper;
import svenhjol.charm.brewing.feature.FlavoredCake;
import svenhjol.charm.brewing.item.ItemFlavoredCake;
import svenhjol.meson.iface.IMesonBlock;
import svenhjol.meson.registry.ProxyRegistry;

public class BlockFlavoredCake
extends BlockCake
implements IMesonBlock,
IMesonBlock.IHasCustomItemBlockModel,
IMesonBlock.IHasCustomStateMapper {
    public ItemStack potionItem;
    public String name;
    public int duration;
    private static ModelResourceLocation MODEL_INVENTORY = new ModelResourceLocation(new ResourceLocation("minecraft", "cake"), "inventory");
    protected Material field_149764_J;

    public BlockFlavoredCake(String name) {
        this.name = "cake_" + name;
        this.register(this.name);
        this.func_149647_a(CreativeTabs.field_78038_k);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176589_a, (Comparable)Integer.valueOf(0)));
        this.field_149764_J = Material.field_151568_F;
    }

    public void setPotionItem(ItemStack potionItem, int duration) {
        this.potionItem = potionItem;
        this.duration = (int)((double)duration * FlavoredCake.multiplier);
    }

    @Override
    public void registerItemBlock(Block block, String name) {
        ProxyRegistry.register(new ItemFlavoredCake((Block)this).func_77625_d(this.getMaxStackSize()).setRegistryName(new ResourceLocation(this.getModId() + ":" + name)));
    }

    @Override
    public String getModId() {
        return "charm";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean eaten = false;
        if (!worldIn.field_72995_K && (eaten = super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ))) {
            for (PotionEffect effect : PotionUtils.func_185189_a((ItemStack)this.potionItem)) {
                playerIn.func_70690_d(new PotionEffect(effect.func_188419_a(), this.duration, effect.func_76458_c()));
            }
        }
        return eaten;
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setStateMapper() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)FlavoredCakeStateMapper.INSTANCE);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setInventoryItemModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)MODEL_INVENTORY);
    }
}

