/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base.integration.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import svenhjol.charm.Charm;
import svenhjol.charm.base.integration.jei.ComposterCategory;
import svenhjol.charm.base.integration.jei.ComposterRecipe;
import svenhjol.charm.brewing.feature.FlavoredCake;
import svenhjol.charm.crafting.feature.Composter;
import svenhjol.charm.crafting.feature.Crate;
import svenhjol.charm.tweaks.feature.CompassBinding;
import svenhjol.charm.world.feature.Moonstone;
import svenhjol.meson.helper.ItemHelper;

@JEIPlugin
public class CharmJeiPlugin
implements IModPlugin {
    private ComposterCategory composter;

    public void registerCategories(IRecipeCategoryRegistration registry) {
        this.composter = new ComposterCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.composter});
    }

    public void register(IModRegistry registry) {
        int i;
        List<String> composterOutputs = Composter.outputs;
        ArrayList outputs = new ArrayList();
        composterOutputs.forEach(name -> outputs.addAll(ItemHelper.getItemStacksFromItemString(name)));
        Map<Float, List<String>> composterInputs = Composter.getInputsByChance();
        TreeMap<Integer, 1> inputs = new TreeMap<Integer, 1>();
        Object[] chances = composterInputs.keySet().toArray(new Float[0]);
        Arrays.sort(chances);
        int page = 0;
        for (Object chance : chances) {
            int i2 = 0;
            for (String itemName : composterInputs.get(chance)) {
                List<ItemStack> stacks = ItemHelper.getItemStacksFromItemString(itemName);
                for (ItemStack stack : stacks) {
                    if (!inputs.containsKey(page)) {
                        inputs.put(page, new HashMap<Float, List<ItemStack>>((Float)chance){
                            final /* synthetic */ Float val$chance;
                            {
                                this.val$chance = f;
                                this.put(this.val$chance, new ArrayList());
                            }
                        });
                    }
                    ((List)((Map)inputs.get(page)).get(chance)).add(stack);
                    page += ++i2 % 36 == 0 ? 1 : 0;
                }
            }
            ++page;
        }
        registry.addRecipeCatalyst((Object)new ItemStack((Block)Composter.composter), new String[]{this.composter.getUid()});
        registry.addRecipes((Collection)inputs.keySet().stream().map(p -> {
            Map.Entry entry = ((Map)inputs.get(p)).entrySet().iterator().next();
            return new ComposterRecipe((List)entry.getValue(), outputs, ((Float)entry.getKey()).floatValue());
        }).collect(Collectors.toList()), this.composter.getUid());
        if (Charm.hasFeature(FlavoredCake.class)) {
            ArrayList cakeItems = new ArrayList();
            FlavoredCake.cakes.values().forEach(cake -> cakeItems.add(new ItemStack((Block)cake)));
            registry.addIngredientInfo(cakeItems, VanillaTypes.ITEM, new String[]{"charm.jei.flavoredcake.desc"});
        }
        if (Charm.hasFeature(CompassBinding.class)) {
            registry.addIngredientInfo((Object)new ItemStack((Item)CompassBinding.boundCompass), VanillaTypes.ITEM, new String[]{"charm.jei.boundcompass.desc"});
        }
        if (Charm.hasFeature(Crate.class)) {
            ArrayList<ItemStack> crates = new ArrayList<ItemStack>();
            for (i = 0; i < 6; ++i) {
                crates.addAll(Arrays.asList(new ItemStack((Block)Crate.crate, 1, i), new ItemStack((Block)Crate.crateSealed, 1, i)));
            }
            registry.addIngredientInfo(crates, VanillaTypes.ITEM, new String[]{"charm.jei.crates.desc"});
        }
        if (Charm.hasFeature(Moonstone.class)) {
            ArrayList<ItemStack> moonstones = new ArrayList<ItemStack>();
            for (i = 0; i < 16; ++i) {
                moonstones.add(new ItemStack((Item)Moonstone.moonstone, 1, i));
            }
            registry.addIngredientInfo(moonstones, VanillaTypes.ITEM, new String[]{"charm.jei.moonstone.desc"});
        }
    }
}

