/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.redstonepaste;

import java.awt.Polygon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class RedstonePasteUtils {
    public static float RADIAN = (float)Math.PI / 180;
    static final double minX = 0.0;
    static final double minY = 0.0;
    static final double minZ = 0.0;
    static final double maxX = 1.0;
    static final double maxY = 1.0;
    static final double maxZ = 1.0;

    private static boolean isVecInsideYZBounds(Vec3d vec) {
        return vec == null ? false : vec.field_72448_b >= 0.0 && vec.field_72448_b <= 1.0 && vec.field_72449_c >= 0.0 && vec.field_72449_c <= 1.0;
    }

    private static boolean isVecInsideXZBounds(Vec3d vec) {
        return vec == null ? false : vec.field_72450_a >= 0.0 && vec.field_72450_a <= 1.0 && vec.field_72449_c >= 0.0 && vec.field_72449_c <= 1.0;
    }

    private static boolean isVecInsideXYBounds(Vec3d vec) {
        return vec == null ? false : vec.field_72450_a >= 0.0 && vec.field_72450_a <= 1.0 && vec.field_72448_b >= 0.0 && vec.field_72448_b <= 1.0;
    }

    public static RayTraceResult collisionRayTrace_Enter(int x, int y, int z, Vec3d start, Vec3d end) {
        start = start.func_72441_c((double)(-x), (double)(-y), (double)(-z));
        end = end.func_72441_c((double)(-x), (double)(-y), (double)(-z));
        Vec3d ivMinX = start.func_72429_b(end, 0.0);
        Vec3d ivMaxX = start.func_72429_b(end, 1.0);
        Vec3d ivMinY = start.func_72435_c(end, 0.0);
        Vec3d ivMaxY = start.func_72435_c(end, 1.0);
        Vec3d ivMinZ = start.func_72434_d(end, 0.0);
        Vec3d ivMaxZ = start.func_72434_d(end, 1.0);
        if (!RedstonePasteUtils.isVecInsideYZBounds(ivMinX)) {
            ivMinX = null;
        }
        if (!RedstonePasteUtils.isVecInsideYZBounds(ivMaxX)) {
            ivMaxX = null;
        }
        if (!RedstonePasteUtils.isVecInsideXZBounds(ivMinY)) {
            ivMinY = null;
        }
        if (!RedstonePasteUtils.isVecInsideXZBounds(ivMaxY)) {
            ivMaxY = null;
        }
        if (!RedstonePasteUtils.isVecInsideXYBounds(ivMinZ)) {
            ivMinZ = null;
        }
        if (!RedstonePasteUtils.isVecInsideXYBounds(ivMaxZ)) {
            ivMaxZ = null;
        }
        Vec3d tempVec = null;
        if (ivMinX != null && (tempVec == null || start.func_72436_e(ivMinX) < start.func_72436_e(tempVec))) {
            tempVec = ivMinX;
        }
        if (ivMaxX != null && (tempVec == null || start.func_72436_e(ivMaxX) < start.func_72436_e(tempVec))) {
            tempVec = ivMaxX;
        }
        if (ivMinY != null && (tempVec == null || start.func_72436_e(ivMinY) < start.func_72436_e(tempVec))) {
            tempVec = ivMinY;
        }
        if (ivMaxY != null && (tempVec == null || start.func_72436_e(ivMaxY) < start.func_72436_e(tempVec))) {
            tempVec = ivMaxY;
        }
        if (ivMinZ != null && (tempVec == null || start.func_72436_e(ivMinZ) < start.func_72436_e(tempVec))) {
            tempVec = ivMinZ;
        }
        if (ivMaxZ != null && (tempVec == null || start.func_72436_e(ivMaxZ) < start.func_72436_e(tempVec))) {
            tempVec = ivMaxZ;
        }
        if (tempVec == null) {
            return null;
        }
        int side = -1;
        if (tempVec == ivMinX) {
            side = 4;
        }
        if (tempVec == ivMaxX) {
            side = 5;
        }
        if (tempVec == ivMinY) {
            side = 0;
        }
        if (tempVec == ivMaxY) {
            side = 1;
        }
        if (tempVec == ivMinZ) {
            side = 2;
        }
        if (tempVec == ivMaxZ) {
            side = 3;
        }
        return new RayTraceResult(tempVec.func_72441_c((double)x, (double)y, (double)z), EnumFacing.values()[side], new BlockPos(x, y, z));
    }

    public static RayTraceResult collisionRayTrace_Exit(int x, int y, int z, Vec3d start, Vec3d end) {
        start = start.func_72441_c((double)(-x), (double)(-y), (double)(-z));
        end = end.func_72441_c((double)(-x), (double)(-y), (double)(-z));
        Vec3d ivMinX = start.func_72429_b(end, 0.0);
        Vec3d ivMaxX = start.func_72429_b(end, 1.0);
        Vec3d ivMinY = start.func_72435_c(end, 0.0);
        Vec3d ivMaxY = start.func_72435_c(end, 1.0);
        Vec3d ivMinZ = start.func_72434_d(end, 0.0);
        Vec3d ivMaxZ = start.func_72434_d(end, 1.0);
        if (!RedstonePasteUtils.isVecInsideYZBounds(ivMinX)) {
            ivMinX = null;
        }
        if (!RedstonePasteUtils.isVecInsideYZBounds(ivMaxX)) {
            ivMaxX = null;
        }
        if (!RedstonePasteUtils.isVecInsideXZBounds(ivMinY)) {
            ivMinY = null;
        }
        if (!RedstonePasteUtils.isVecInsideXZBounds(ivMaxY)) {
            ivMaxY = null;
        }
        if (!RedstonePasteUtils.isVecInsideXYBounds(ivMinZ)) {
            ivMinZ = null;
        }
        if (!RedstonePasteUtils.isVecInsideXYBounds(ivMaxZ)) {
            ivMaxZ = null;
        }
        Vec3d tempVec = null;
        if (ivMinX != null && (tempVec == null || start.func_72436_e(ivMinX) > start.func_72436_e(tempVec))) {
            tempVec = ivMinX;
        }
        if (ivMaxX != null && (tempVec == null || start.func_72436_e(ivMaxX) > start.func_72436_e(tempVec))) {
            tempVec = ivMaxX;
        }
        if (ivMinY != null && (tempVec == null || start.func_72436_e(ivMinY) > start.func_72436_e(tempVec))) {
            tempVec = ivMinY;
        }
        if (ivMaxY != null && (tempVec == null || start.func_72436_e(ivMaxY) > start.func_72436_e(tempVec))) {
            tempVec = ivMaxY;
        }
        if (ivMinZ != null && (tempVec == null || start.func_72436_e(ivMinZ) > start.func_72436_e(tempVec))) {
            tempVec = ivMinZ;
        }
        if (ivMaxZ != null && (tempVec == null || start.func_72436_e(ivMaxZ) > start.func_72436_e(tempVec))) {
            tempVec = ivMaxZ;
        }
        if (tempVec == null) {
            return null;
        }
        int side = -1;
        if (tempVec == ivMinX) {
            side = 4;
        }
        if (tempVec == ivMaxX) {
            side = 5;
        }
        if (tempVec == ivMinY) {
            side = 0;
        }
        if (tempVec == ivMaxY) {
            side = 1;
        }
        if (tempVec == ivMinZ) {
            side = 2;
        }
        if (tempVec == ivMaxZ) {
            side = 3;
        }
        return new RayTraceResult(tempVec.func_72441_c((double)x, (double)y, (double)z), EnumFacing.values()[side], new BlockPos(x, y, z));
    }

    public static RayTraceResult rayTraceBlocks_getFollowing(Vec3d start, Vec3d end, Vec3d targetBlock) {
        if (!(Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c))) {
            if (!(Double.isNaN(end.field_72450_a) || Double.isNaN(end.field_72448_b) || Double.isNaN(end.field_72449_c))) {
                int endX = MathHelper.func_76128_c((double)end.field_72450_a);
                int endY = MathHelper.func_76128_c((double)end.field_72448_b);
                int endZ = MathHelper.func_76128_c((double)end.field_72449_c);
                int startX = MathHelper.func_76128_c((double)start.field_72450_a);
                int startY = MathHelper.func_76128_c((double)start.field_72448_b);
                int startZ = MathHelper.func_76128_c((double)start.field_72449_c);
                int safetyCounter = 200;
                Vec3d lastBlock = new Vec3d((double)startX, (double)startY, (double)startZ);
                while (safetyCounter-- >= 0) {
                    boolean lastIsTarget;
                    int side;
                    if (Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c)) {
                        return null;
                    }
                    if (startX == endX && startY == endY && startZ == endZ) {
                        return null;
                    }
                    boolean useX = true;
                    boolean useY = true;
                    boolean useZ = true;
                    double tX = 999.0;
                    double tY = 999.0;
                    double tZ = 999.0;
                    if (endX > startX) {
                        tX = (double)startX + 1.0;
                    } else if (endX < startX) {
                        tX = (double)startX + 0.0;
                    } else {
                        useX = false;
                    }
                    if (endY > startY) {
                        tY = (double)startY + 1.0;
                    } else if (endY < startY) {
                        tY = (double)startY + 0.0;
                    } else {
                        useY = false;
                    }
                    if (endZ > startZ) {
                        tZ = (double)startZ + 1.0;
                    } else if (endZ < startZ) {
                        tZ = (double)startZ + 0.0;
                    } else {
                        useZ = false;
                    }
                    double tX2 = 999.0;
                    double tY2 = 999.0;
                    double tZ2 = 999.0;
                    double dx = end.field_72450_a - start.field_72450_a;
                    double dy = end.field_72448_b - start.field_72448_b;
                    double dz = end.field_72449_c - start.field_72449_c;
                    if (useX) {
                        tX2 = (tX - start.field_72450_a) / dx;
                    }
                    if (useY) {
                        tY2 = (tY - start.field_72448_b) / dy;
                    }
                    if (useZ) {
                        tZ2 = (tZ - start.field_72449_c) / dz;
                    }
                    boolean flag5 = false;
                    if (tX2 < tY2 && tX2 < tZ2) {
                        side = endX > startX ? 4 : 5;
                        start = new Vec3d(tX, start.field_72448_b + dy * tX2, start.field_72449_c + dz * tX2);
                    } else if (tY2 < tZ2) {
                        side = endY > startY ? 0 : 1;
                        start = new Vec3d(start.field_72450_a + dx * tY2, tY, start.field_72449_c + dz * tY2);
                    } else {
                        side = endZ > startZ ? 2 : 3;
                        start = new Vec3d(start.field_72450_a + dx * tZ2, start.field_72448_b + dy * tZ2, tZ);
                    }
                    Vec3d vec32 = new Vec3d((double)MathHelper.func_76128_c((double)start.field_72450_a), start.field_72448_b, start.field_72449_c);
                    startX = (int)vec32.field_72450_a;
                    if (side == 5) {
                        --startX;
                        vec32 = vec32.func_72441_c(1.0, 0.0, 0.0);
                    }
                    vec32 = new Vec3d(vec32.field_72450_a, (double)MathHelper.func_76128_c((double)vec32.field_72448_b), vec32.field_72449_c);
                    startY = (int)vec32.field_72448_b;
                    if (side == 1) {
                        --startY;
                        vec32 = vec32.func_72441_c(0.0, 1.0, 0.0);
                    }
                    vec32 = new Vec3d(vec32.field_72450_a, vec32.field_72448_b, (double)MathHelper.func_76128_c((double)vec32.field_72449_c));
                    startZ = (int)vec32.field_72449_c;
                    if (side == 3) {
                        --startZ;
                        vec32 = vec32.func_72441_c(0.0, 0.0, 1.0);
                    }
                    boolean isLastBlock = (double)startX == lastBlock.field_72450_a && (double)startY == lastBlock.field_72448_b && (double)startZ == lastBlock.field_72449_c;
                    boolean bl = lastIsTarget = lastBlock.field_72450_a == targetBlock.field_72450_a && lastBlock.field_72448_b == targetBlock.field_72448_b && lastBlock.field_72449_c == targetBlock.field_72449_c;
                    if (!isLastBlock && lastIsTarget) {
                        return RedstonePasteUtils.collisionRayTrace_Enter(startX, startY, startZ, start, end);
                    }
                    lastBlock = new Vec3d((double)startX, (double)startY, (double)startZ);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static RayTraceResult traceBlockExit(EntityPlayer player, int x, int y, int z) {
        float modifier = 1.0f;
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * modifier;
        float yaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * modifier;
        double lookX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)modifier;
        double lookY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)modifier + (double)player.func_70047_e();
        double lookZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)modifier;
        double reach = 5.0;
        if (player instanceof EntityPlayerMP) {
            reach = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
            if (player.func_70093_af()) {
                lookY -= 0.08;
            }
        }
        reach += 1.0;
        Vec3d vec3 = new Vec3d(lookX, lookY, lookZ);
        float f3 = MathHelper.func_76134_b((float)(-yaw * RADIAN - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-yaw * RADIAN - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-pitch * RADIAN));
        float f6 = MathHelper.func_76126_a((float)(-pitch * RADIAN));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        Vec3d vec31 = vec3.func_72441_c((double)f7 * reach, (double)f6 * reach, (double)f8 * reach);
        return RedstonePasteUtils.collisionRayTrace_Exit(x, y, z, vec3, vec31);
    }

    public static int testSegmentHit(double x, double y) {
        return RedstonePasteUtils.testSegmentHit(x, y, true);
    }

    public static int testSegmentHit(double x, double y, boolean selectall) {
        int segmenthit = 0;
        Polygon p = new Polygon();
        p.addPoint(0, 0);
        p.addPoint(2, 0);
        p.addPoint(1, 1);
        if (p.contains(x * 2.0, y * 2.0)) {
            segmenthit = 1;
        }
        p.reset();
        p.addPoint(0, 2);
        p.addPoint(2, 2);
        p.addPoint(1, 1);
        if (p.contains(x * 2.0, y * 2.0)) {
            segmenthit = 2;
        }
        p.reset();
        p.addPoint(0, 0);
        p.addPoint(0, 2);
        p.addPoint(1, 1);
        if (p.contains(x * 2.0, y * 2.0)) {
            segmenthit = 4;
        }
        p.reset();
        p.addPoint(2, 0);
        p.addPoint(2, 2);
        p.addPoint(1, 1);
        if (p.contains(x * 2.0, y * 2.0)) {
            segmenthit = 8;
        }
        p.reset();
        p.addPoint(3, 3);
        p.addPoint(5, 3);
        p.addPoint(5, 5);
        p.addPoint(3, 5);
        if (p.contains(x * 8.0, y * 8.0)) {
            segmenthit = selectall ? 15 : 0;
        }
        return segmenthit;
    }
}

