/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.redstonepaste;

import net.fybertech.nwr.ISpecialBlockRenderer;
import net.fybertech.redstonepaste.BlockRedstonePaste;
import net.fybertech.redstonepaste.CompatibilityRenderer;
import net.fybertech.redstonepaste.CompatibilityTessellator;
import net.fybertech.redstonepaste.RPClientProxy;
import net.fybertech.redstonepaste.RedstonePasteMod;
import net.fybertech.redstonepaste.TileEntityRedstonePaste;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.util.Color;

public class RPRenderer
implements ISpecialBlockRenderer {
    private Color[] colorlist;
    private Vec3UV[][][] vecs_redstoneRepeaterIdle = null;
    private Vec3UV[][][] vecs_redstoneRepeaterActive = null;
    private Vec3UV[][] vecs_redstoneTorchActive = null;
    private Vec3UV[][] vecs_redstoneTorchIdle = null;
    private Vec3UV[][][] rotatedLockBarVecs = new Vec3UV[3][][];
    Vec3UV[][][] vecs_redstoneComparatorIdle = null;
    Vec3UV[][][] vecs_redstoneComparatorActive = null;

    public RPRenderer() {
        this.calculateColorList();
    }

    private int lerp(int v0, int v1, float t) {
        return (int)Math.floor((float)v0 + (float)(v1 - v0) * t);
    }

    private float lerp(float v0, float v1, float t) {
        return v0 + (v1 - v0) * t;
    }

    public void calculateColorList() {
        float cf;
        int n;
        float colorskew = 0.5f;
        Color oncolor = new Color(255, 82, 0);
        Color offcolor = new Color(128, 180, 0);
        Color midcolor = new Color(230, 100, 0);
        String pasteColorOn = RedstonePasteMod.instance.pasteColorOn.replace('#', ' ').trim();
        String pasteColorMid = RedstonePasteMod.instance.pasteColorMid.replace('#', ' ').trim();
        String pasteColorOff = RedstonePasteMod.instance.pasteColorOff.replace('#', ' ').trim();
        Long l_on = 0L;
        Long l_mid = 0L;
        Long l_off = 0L;
        try {
            l_on = Long.parseLong(pasteColorOn, 16);
            l_mid = Long.parseLong(pasteColorMid, 16);
            l_off = Long.parseLong(pasteColorOff, 16);
            oncolor = new Color((int)((l_on & 0xFF0000L) >> 16), (int)((l_on & 0xFF00L) >> 8), (int)(l_on & 0xFFL));
            midcolor = new Color((int)((l_mid & 0xFF0000L) >> 16), (int)((l_mid & 0xFF00L) >> 8), (int)(l_mid & 0xFFL));
            offcolor = new Color((int)((l_off & 0xFF0000L) >> 16), (int)((l_off & 0xFF00L) >> 8), (int)(l_off & 0xFFL));
        }
        catch (Exception e) {
            System.out.println("RedstonePasteMod - Error processing colors, using default");
            oncolor = new Color(255, 82, 0);
            offcolor = new Color(128, 180, 0);
            midcolor = new Color(230, 100, 0);
        }
        int totalcolors = 16;
        int halfint = this.lerp(0, totalcolors, colorskew);
        halfint = 8;
        this.colorlist = new Color[totalcolors];
        for (n = 0; n < halfint; ++n) {
            cf = (float)n / (float)halfint;
            this.colorlist[n] = new Color(this.lerp(offcolor.getRed(), midcolor.getRed(), cf), this.lerp(offcolor.getGreen(), midcolor.getGreen(), cf), this.lerp(offcolor.getBlue(), midcolor.getBlue(), cf));
        }
        for (n = halfint; n < totalcolors; ++n) {
            cf = (float)(n - halfint) / (float)(totalcolors - 1 - halfint);
            this.colorlist[n] = new Color(this.lerp(midcolor.getRed(), oncolor.getRed(), cf), this.lerp(midcolor.getGreen(), oncolor.getGreen(), cf), this.lerp(midcolor.getBlue(), oncolor.getBlue(), cf));
        }
    }

    private Vec3UV[] computeFaceYNeg(CompatibilityRenderer renderer, double par2, double par4, double par6, TextureAtlasSprite par8Icon) {
        if (renderer.hasOverrideBlockTexture()) {
            par8Icon = renderer.overrideBlockTexture;
        }
        double d3 = par8Icon.func_94214_a(renderer.renderMinX * 16.0);
        double d4 = par8Icon.func_94214_a(renderer.renderMaxX * 16.0);
        double d5 = par8Icon.func_94207_b(renderer.renderMinZ * 16.0);
        double d6 = par8Icon.func_94207_b(renderer.renderMaxZ * 16.0);
        if (renderer.renderMinX < 0.0 || renderer.renderMaxX > 1.0) {
            d3 = par8Icon.func_94209_e();
            d4 = par8Icon.func_94212_f();
        }
        if (renderer.renderMinZ < 0.0 || renderer.renderMaxZ > 1.0) {
            d5 = par8Icon.func_94206_g();
            d6 = par8Icon.func_94210_h();
        }
        double d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (renderer.uvRotateBottom == 2) {
            d3 = par8Icon.func_94214_a(renderer.renderMinZ * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - renderer.renderMaxX * 16.0);
            d4 = par8Icon.func_94214_a(renderer.renderMaxZ * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.renderMinX * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (renderer.uvRotateBottom == 1) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.renderMaxZ * 16.0);
            d5 = par8Icon.func_94207_b(renderer.renderMinX * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.renderMinZ * 16.0);
            d6 = par8Icon.func_94207_b(renderer.renderMaxX * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (renderer.uvRotateBottom == 3) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.renderMinX * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.renderMaxX * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - renderer.renderMinZ * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.renderMaxZ * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + renderer.renderMinX;
        double d12 = par2 + renderer.renderMaxX;
        double d13 = par4 + renderer.renderMinY;
        double d14 = par6 + renderer.renderMinZ;
        double d15 = par6 + renderer.renderMaxZ;
        Vec3UV[] vecs = new Vec3UV[]{new Vec3UV(d11, d13, d15, d8, d10), new Vec3UV(d11, d13, d14, d3, d5), new Vec3UV(d12, d13, d14, d7, d9), new Vec3UV(d12, d13, d15, d4, d6)};
        return vecs;
    }

    private Vec3UV[] computeFaceYPos(CompatibilityRenderer renderer, double par2, double par4, double par6, TextureAtlasSprite par8Icon) {
        if (renderer.hasOverrideBlockTexture()) {
            par8Icon = renderer.overrideBlockTexture;
        }
        double d3 = par8Icon.func_94214_a(renderer.renderMinX * 16.0);
        double d4 = par8Icon.func_94214_a(renderer.renderMaxX * 16.0);
        double d5 = par8Icon.func_94207_b(renderer.renderMinZ * 16.0);
        double d6 = par8Icon.func_94207_b(renderer.renderMaxZ * 16.0);
        if (renderer.renderMinX < 0.0 || renderer.renderMaxX > 1.0) {
            d3 = par8Icon.func_94209_e();
            d4 = par8Icon.func_94212_f();
        }
        if (renderer.renderMinZ < 0.0 || renderer.renderMaxZ > 1.0) {
            d5 = par8Icon.func_94206_g();
            d6 = par8Icon.func_94210_h();
        }
        double d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (renderer.uvRotateTop == 1) {
            d3 = par8Icon.func_94214_a(renderer.renderMinZ * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - renderer.renderMaxX * 16.0);
            d4 = par8Icon.func_94214_a(renderer.renderMaxZ * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.renderMinX * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (renderer.uvRotateTop == 2) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.renderMaxZ * 16.0);
            d5 = par8Icon.func_94207_b(renderer.renderMinX * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.renderMinZ * 16.0);
            d6 = par8Icon.func_94207_b(renderer.renderMaxX * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (renderer.uvRotateTop == 3) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.renderMinX * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.renderMaxX * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - renderer.renderMinZ * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.renderMaxZ * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + renderer.renderMinX;
        double d12 = par2 + renderer.renderMaxX;
        double d13 = par4 + renderer.renderMaxY;
        double d14 = par6 + renderer.renderMinZ;
        double d15 = par6 + renderer.renderMaxZ;
        Vec3UV[] vecs = new Vec3UV[]{new Vec3UV(d12, d13, d15, d4, d6), new Vec3UV(d12, d13, d14, d7, d9), new Vec3UV(d11, d13, d14, d3, d5), new Vec3UV(d11, d13, d15, d8, d10)};
        return vecs;
    }

    private Vec3UV[] computeFaceZNeg(CompatibilityRenderer renderer, double par2, double par4, double par6, TextureAtlasSprite par8Icon) {
        double d7;
        if (renderer.hasOverrideBlockTexture()) {
            par8Icon = renderer.overrideBlockTexture;
        }
        double d3 = par8Icon.func_94214_a(renderer.renderMinX * 16.0);
        double d4 = par8Icon.func_94214_a(renderer.renderMaxX * 16.0);
        double d5 = par8Icon.func_94207_b(16.0 - renderer.renderMaxY * 16.0);
        double d6 = par8Icon.func_94207_b(16.0 - renderer.renderMinY * 16.0);
        if (renderer.flipTexture) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (renderer.renderMinX < 0.0 || renderer.renderMaxX > 1.0) {
            d3 = par8Icon.func_94209_e();
            d4 = par8Icon.func_94212_f();
        }
        if (renderer.renderMinY < 0.0 || renderer.renderMaxY > 1.0) {
            d5 = par8Icon.func_94206_g();
            d6 = par8Icon.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (renderer.uvRotateEast == 2) {
            d3 = par8Icon.func_94214_a(renderer.renderMinY * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - renderer.renderMinX * 16.0);
            d4 = par8Icon.func_94214_a(renderer.renderMaxY * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.renderMaxX * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (renderer.uvRotateEast == 1) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.renderMaxY * 16.0);
            d5 = par8Icon.func_94207_b(renderer.renderMaxX * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.renderMinY * 16.0);
            d6 = par8Icon.func_94207_b(renderer.renderMinX * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (renderer.uvRotateEast == 3) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.renderMinX * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.renderMaxX * 16.0);
            d5 = par8Icon.func_94207_b(renderer.renderMaxY * 16.0);
            d6 = par8Icon.func_94207_b(renderer.renderMinY * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + renderer.renderMinX;
        double d12 = par2 + renderer.renderMaxX;
        double d13 = par4 + renderer.renderMinY;
        double d14 = par4 + renderer.renderMaxY;
        double d15 = par6 + renderer.renderMinZ;
        Vec3UV[] vecs = new Vec3UV[]{new Vec3UV(d11, d14, d15, d7, d9), new Vec3UV(d12, d14, d15, d3, d5), new Vec3UV(d12, d13, d15, d8, d10), new Vec3UV(d11, d13, d15, d4, d6)};
        return vecs;
    }

    private Vec3UV[] computeFaceZPos(CompatibilityRenderer renderer, double par2, double par4, double par6, TextureAtlasSprite par8Icon) {
        double d7;
        if (renderer.hasOverrideBlockTexture()) {
            par8Icon = renderer.overrideBlockTexture;
        }
        double d3 = par8Icon.func_94214_a(renderer.renderMinX * 16.0);
        double d4 = par8Icon.func_94214_a(renderer.renderMaxX * 16.0);
        double d5 = par8Icon.func_94207_b(16.0 - renderer.renderMaxY * 16.0);
        double d6 = par8Icon.func_94207_b(16.0 - renderer.renderMinY * 16.0);
        if (renderer.flipTexture) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (renderer.renderMinX < 0.0 || renderer.renderMaxX > 1.0) {
            d3 = par8Icon.func_94209_e();
            d4 = par8Icon.func_94212_f();
        }
        if (renderer.renderMinY < 0.0 || renderer.renderMaxY > 1.0) {
            d5 = par8Icon.func_94206_g();
            d6 = par8Icon.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (renderer.uvRotateWest == 1) {
            d3 = par8Icon.func_94214_a(renderer.renderMinY * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.renderMinX * 16.0);
            d4 = par8Icon.func_94214_a(renderer.renderMaxY * 16.0);
            d9 = d5 = (double)par8Icon.func_94207_b(16.0 - renderer.renderMaxX * 16.0);
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (renderer.uvRotateWest == 2) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.renderMaxY * 16.0);
            d5 = par8Icon.func_94207_b(renderer.renderMinX * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.renderMinY * 16.0);
            d6 = par8Icon.func_94207_b(renderer.renderMaxX * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (renderer.uvRotateWest == 3) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.renderMinX * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.renderMaxX * 16.0);
            d5 = par8Icon.func_94207_b(renderer.renderMaxY * 16.0);
            d6 = par8Icon.func_94207_b(renderer.renderMinY * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + renderer.renderMinX;
        double d12 = par2 + renderer.renderMaxX;
        double d13 = par4 + renderer.renderMinY;
        double d14 = par4 + renderer.renderMaxY;
        double d15 = par6 + renderer.renderMaxZ;
        Vec3UV[] vecs = new Vec3UV[]{new Vec3UV(d11, d14, d15, d3, d5), new Vec3UV(d11, d13, d15, d8, d10), new Vec3UV(d12, d13, d15, d4, d6), new Vec3UV(d12, d14, d15, d7, d9)};
        return vecs;
    }

    private Vec3UV[] computeFaceXNeg(CompatibilityRenderer renderer, double par2, double par4, double par6, TextureAtlasSprite par8Icon) {
        double d7;
        if (renderer.hasOverrideBlockTexture()) {
            par8Icon = renderer.overrideBlockTexture;
        }
        double d3 = par8Icon.func_94214_a(renderer.renderMinZ * 16.0);
        double d4 = par8Icon.func_94214_a(renderer.renderMaxZ * 16.0);
        double d5 = par8Icon.func_94207_b(16.0 - renderer.renderMaxY * 16.0);
        double d6 = par8Icon.func_94207_b(16.0 - renderer.renderMinY * 16.0);
        if (renderer.flipTexture) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (renderer.renderMinZ < 0.0 || renderer.renderMaxZ > 1.0) {
            d3 = par8Icon.func_94209_e();
            d4 = par8Icon.func_94212_f();
        }
        if (renderer.renderMinY < 0.0 || renderer.renderMaxY > 1.0) {
            d5 = par8Icon.func_94206_g();
            d6 = par8Icon.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (renderer.uvRotateNorth == 1) {
            d3 = par8Icon.func_94214_a(renderer.renderMinY * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - renderer.renderMaxZ * 16.0);
            d4 = par8Icon.func_94214_a(renderer.renderMaxY * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.renderMinZ * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (renderer.uvRotateNorth == 2) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.renderMaxY * 16.0);
            d5 = par8Icon.func_94207_b(renderer.renderMinZ * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.renderMinY * 16.0);
            d6 = par8Icon.func_94207_b(renderer.renderMaxZ * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (renderer.uvRotateNorth == 3) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.renderMinZ * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.renderMaxZ * 16.0);
            d5 = par8Icon.func_94207_b(renderer.renderMaxY * 16.0);
            d6 = par8Icon.func_94207_b(renderer.renderMinY * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + renderer.renderMinX;
        double d12 = par4 + renderer.renderMinY;
        double d13 = par4 + renderer.renderMaxY;
        double d14 = par6 + renderer.renderMinZ;
        double d15 = par6 + renderer.renderMaxZ;
        Vec3UV[] vecs = new Vec3UV[]{new Vec3UV(d11, d13, d15, d7, d9), new Vec3UV(d11, d13, d14, d3, d5), new Vec3UV(d11, d12, d14, d8, d10), new Vec3UV(d11, d12, d15, d4, d6)};
        return vecs;
    }

    private Vec3UV[] computeFaceXPos(CompatibilityRenderer renderer, double par2, double par4, double par6, TextureAtlasSprite par8Icon) {
        double d7;
        if (renderer.hasOverrideBlockTexture()) {
            par8Icon = renderer.overrideBlockTexture;
        }
        double d3 = par8Icon.func_94214_a(renderer.renderMinZ * 16.0);
        double d4 = par8Icon.func_94214_a(renderer.renderMaxZ * 16.0);
        double d5 = par8Icon.func_94207_b(16.0 - renderer.renderMaxY * 16.0);
        double d6 = par8Icon.func_94207_b(16.0 - renderer.renderMinY * 16.0);
        if (renderer.flipTexture) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (renderer.renderMinZ < 0.0 || renderer.renderMaxZ > 1.0) {
            d3 = par8Icon.func_94209_e();
            d4 = par8Icon.func_94212_f();
        }
        if (renderer.renderMinY < 0.0 || renderer.renderMaxY > 1.0) {
            d5 = par8Icon.func_94206_g();
            d6 = par8Icon.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (renderer.uvRotateSouth == 2) {
            d3 = par8Icon.func_94214_a(renderer.renderMinY * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - renderer.renderMinZ * 16.0);
            d4 = par8Icon.func_94214_a(renderer.renderMaxY * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.renderMaxZ * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (renderer.uvRotateSouth == 1) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.renderMaxY * 16.0);
            d5 = par8Icon.func_94207_b(renderer.renderMaxZ * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.renderMinY * 16.0);
            d6 = par8Icon.func_94207_b(renderer.renderMinZ * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (renderer.uvRotateSouth == 3) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.renderMinZ * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.renderMaxZ * 16.0);
            d5 = par8Icon.func_94207_b(renderer.renderMaxY * 16.0);
            d6 = par8Icon.func_94207_b(renderer.renderMinY * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + renderer.renderMaxX;
        double d12 = par4 + renderer.renderMinY;
        double d13 = par4 + renderer.renderMaxY;
        double d14 = par6 + renderer.renderMinZ;
        double d15 = par6 + renderer.renderMaxZ;
        Vec3UV[] vecs = new Vec3UV[]{new Vec3UV(d11, d12, d15, d8, d10), new Vec3UV(d11, d12, d14, d4, d6), new Vec3UV(d11, d13, d14, d7, d9), new Vec3UV(d11, d13, d15, d3, d5)};
        return vecs;
    }

    private Vec3UV[][] computeStandardBlock(CompatibilityRenderer renderer, Block par1Block, int par2, int par3, int par4, int face) {
        float f3 = 0.5f;
        float f4 = 1.0f;
        float f5 = 0.8f;
        float f6 = 0.6f;
        float f10 = f3;
        float f11 = f5;
        float f12 = f6;
        float f13 = f3;
        float f14 = f5;
        float f15 = f6;
        float f16 = f3;
        float f17 = f5;
        float f18 = f6;
        par2 = 0;
        par3 = 0;
        par4 = 0;
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(par1Block.func_176223_P());
        Vec3UV[][] vecs = new Vec3UV[][]{this.computeFaceYNeg(renderer, par2, par3, par4, icon), this.computeFaceYPos(renderer, par2, par3, par4, icon), this.computeFaceZNeg(renderer, par2, par3, par4, icon), this.computeFaceZPos(renderer, par2, par3, par4, icon), this.computeFaceXNeg(renderer, par2, par3, par4, icon), this.computeFaceXPos(renderer, par2, par3, par4, icon)};
        return vecs;
    }

    private Vec3UV[] computeTorchAtAngle(CompatibilityRenderer renderer, Block par1Block, double par2, double par4, double par6, double par8, double par10, int par12) {
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(par1Block.func_176223_P());
        if (renderer.hasOverrideBlockTexture()) {
            icon = renderer.overrideBlockTexture;
        }
        double d5 = icon.func_94209_e();
        double d6 = icon.func_94206_g();
        double d7 = icon.func_94212_f();
        double d8 = icon.func_94210_h();
        double d9 = icon.func_94214_a(7.0);
        double d10 = icon.func_94207_b(6.0);
        double d11 = icon.func_94214_a(9.0);
        double d12 = icon.func_94207_b(8.0);
        double d13 = icon.func_94214_a(7.0);
        double d14 = icon.func_94207_b(13.0);
        double d15 = icon.func_94214_a(9.0);
        double d16 = icon.func_94207_b(15.0);
        double d17 = (par2 += 0.5) - 0.5;
        double d18 = par2 + 0.5;
        double d19 = (par6 += 0.5) - 0.5;
        double d20 = par6 + 0.5;
        double d21 = 0.0625;
        double d22 = 0.625;
        Vec3UV[] vecs = new Vec3UV[]{new Vec3UV(par2 + par8 * (1.0 - d22) - d21, par4 + d22, par6 + par10 * (1.0 - d22) - d21, d9, d10), new Vec3UV(par2 + par8 * (1.0 - d22) - d21, par4 + d22, par6 + par10 * (1.0 - d22) + d21, d9, d12), new Vec3UV(par2 + par8 * (1.0 - d22) + d21, par4 + d22, par6 + par10 * (1.0 - d22) + d21, d11, d12), new Vec3UV(par2 + par8 * (1.0 - d22) + d21, par4 + d22, par6 + par10 * (1.0 - d22) - d21, d11, d10), new Vec3UV(par2 + d21 + par8, par4, par6 - d21 + par10, d15, d14), new Vec3UV(par2 + d21 + par8, par4, par6 + d21 + par10, d15, d16), new Vec3UV(par2 - d21 + par8, par4, par6 + d21 + par10, d13, d16), new Vec3UV(par2 - d21 + par8, par4, par6 - d21 + par10, d13, d14), new Vec3UV(par2 - d21, par4 + 1.0, d19, d5, d6), new Vec3UV(par2 - d21 + par8, par4 + 0.0, d19 + par10, d5, d8), new Vec3UV(par2 - d21 + par8, par4 + 0.0, d20 + par10, d7, d8), new Vec3UV(par2 - d21, par4 + 1.0, d20, d7, d6), new Vec3UV(par2 + d21, par4 + 1.0, d20, d5, d6), new Vec3UV(par2 + par8 + d21, par4 + 0.0, d20 + par10, d5, d8), new Vec3UV(par2 + par8 + d21, par4 + 0.0, d19 + par10, d7, d8), new Vec3UV(par2 + d21, par4 + 1.0, d19, d7, d6), new Vec3UV(d17, par4 + 1.0, par6 + d21, d5, d6), new Vec3UV(d17 + par8, par4 + 0.0, par6 + d21 + par10, d5, d8), new Vec3UV(d18 + par8, par4 + 0.0, par6 + d21 + par10, d7, d8), new Vec3UV(d18, par4 + 1.0, par6 + d21, d7, d6), new Vec3UV(d18, par4 + 1.0, par6 - d21, d5, d6), new Vec3UV(d18 + par8, par4 + 0.0, par6 - d21 + par10, d5, d8), new Vec3UV(d17 + par8, par4 + 0.0, par6 - d21 + par10, d7, d8), new Vec3UV(d17, par4 + 1.0, par6 - d21, d7, d6)};
        return vecs;
    }

    private static Vec3d rotateAroundX(Vec3d vec, int deg) {
        float f1 = 0.0f;
        float f2 = 1.0f;
        switch (deg) {
            case 0: {
                f1 = 1.0f;
                f2 = 0.0f;
                break;
            }
            case 90: {
                f1 = 0.0f;
                f2 = 1.0f;
                break;
            }
            case 180: {
                f1 = -1.0f;
                f2 = 0.0f;
                break;
            }
            case 270: {
                f1 = 0.0f;
                f2 = -1.0f;
            }
        }
        double d0 = vec.field_72450_a;
        double d1 = vec.field_72448_b * (double)f1 + vec.field_72449_c * (double)f2;
        double d2 = vec.field_72449_c * (double)f1 - vec.field_72448_b * (double)f2;
        return new Vec3d(d0, d1, d2);
    }

    private static Vec3d rotateAroundY(Vec3d vec, int deg) {
        float f1 = 0.0f;
        float f2 = 1.0f;
        switch (deg) {
            case 0: {
                f1 = 1.0f;
                f2 = 0.0f;
                break;
            }
            case 90: {
                f1 = 0.0f;
                f2 = 1.0f;
                break;
            }
            case 180: {
                f1 = -1.0f;
                f2 = 0.0f;
                break;
            }
            case 270: {
                f1 = 0.0f;
                f2 = -1.0f;
            }
        }
        double d0 = vec.field_72450_a * (double)f1 + vec.field_72449_c * (double)f2;
        double d1 = vec.field_72448_b;
        double d2 = vec.field_72449_c * (double)f1 - vec.field_72450_a * (double)f2;
        return new Vec3d(d0, d1, d2);
    }

    private static Vec3d rotateAroundZ(Vec3d vec, int deg) {
        float f1 = 0.0f;
        float f2 = 1.0f;
        switch (deg) {
            case 0: {
                f1 = 1.0f;
                f2 = 0.0f;
                break;
            }
            case 90: {
                f1 = 0.0f;
                f2 = 1.0f;
                break;
            }
            case 180: {
                f1 = -1.0f;
                f2 = 0.0f;
                break;
            }
            case 270: {
                f1 = 0.0f;
                f2 = -1.0f;
            }
        }
        double d0 = vec.field_72450_a * (double)f1 + vec.field_72448_b * (double)f2;
        double d1 = vec.field_72448_b * (double)f1 - vec.field_72450_a * (double)f2;
        double d2 = vec.field_72449_c;
        return new Vec3d(d0, d1, d2);
    }

    private static Vec3d rotateVecX(Vec3d vec, int deg) {
        return RPRenderer.rotateAroundX(vec.func_178786_a(0.5, 0.5, 0.5), deg).func_72441_c(0.5, 0.5, 0.5);
    }

    private static Vec3d rotateVecY(Vec3d vec, int deg) {
        return RPRenderer.rotateAroundY(vec.func_178786_a(0.5, 0.5, 0.5), deg).func_72441_c(0.5, 0.5, 0.5);
    }

    private static Vec3d rotateVecZ(Vec3d vec, int deg) {
        return RPRenderer.rotateAroundZ(vec.func_178786_a(0.5, 0.5, 0.5), deg).func_72441_c(0.5, 0.5, 0.5);
    }

    private Vec3UV[][][] computeStandardBlockRotations(CompatibilityRenderer renderer, Block block) {
        Vec3UV[][][] rotatedvecs = new Vec3UV[6][][];
        for (int rotation = 0; rotation < 6; ++rotation) {
            Vec3UV[][] vecs = this.computeStandardBlock(renderer, block, 0, 0, 0, 0);
            for (int f = 0; f < 6; ++f) {
                for (int v = 0; v < 4; ++v) {
                    Vec3d newvec = new Vec3d(vecs[f][v].x, vecs[f][v].y, vecs[f][v].z);
                    switch (rotation) {
                        case 0: {
                            newvec = RPRenderer.rotateVecY(newvec, 180);
                            break;
                        }
                        case 1: {
                            newvec = RPRenderer.rotateVecX(newvec, 180);
                            newvec = RPRenderer.rotateVecY(newvec, 180);
                            break;
                        }
                        case 2: {
                            newvec = RPRenderer.rotateVecX(newvec, 270);
                            break;
                        }
                        case 3: {
                            newvec = RPRenderer.rotateVecX(newvec, 90);
                            newvec = RPRenderer.rotateVecZ(newvec, 180);
                            break;
                        }
                        case 4: {
                            newvec = RPRenderer.rotateVecZ(newvec, 90);
                            newvec = RPRenderer.rotateVecX(newvec, 270);
                            break;
                        }
                        case 5: {
                            newvec = RPRenderer.rotateVecZ(newvec, 270);
                            newvec = RPRenderer.rotateVecX(newvec, 270);
                        }
                    }
                    vecs[f][v].x = newvec.field_72450_a;
                    vecs[f][v].y = newvec.field_72448_b;
                    vecs[f][v].z = newvec.field_72449_c;
                }
            }
            rotatedvecs[rotation] = vecs;
        }
        return rotatedvecs;
    }

    private Vec3UV[][] computeRotations(Vec3UV[] originalvecs, int veccount) {
        Vec3UV[][] rotatedvecs = new Vec3UV[6][];
        for (int rotation = 0; rotation < 6; ++rotation) {
            Vec3UV[] vecs = new Vec3UV[veccount];
            for (int v = 0; v < veccount; ++v) {
                Vec3d newvec = new Vec3d(originalvecs[v].x, originalvecs[v].y, originalvecs[v].z);
                switch (rotation) {
                    case 0: {
                        newvec = RPRenderer.rotateVecY(newvec, 180);
                        break;
                    }
                    case 1: {
                        newvec = RPRenderer.rotateVecX(newvec, 180);
                        newvec = RPRenderer.rotateVecY(newvec, 180);
                        break;
                    }
                    case 2: {
                        newvec = RPRenderer.rotateVecX(newvec, 270);
                        break;
                    }
                    case 3: {
                        newvec = RPRenderer.rotateVecX(newvec, 90);
                        newvec = RPRenderer.rotateVecZ(newvec, 180);
                        break;
                    }
                    case 4: {
                        newvec = RPRenderer.rotateVecZ(newvec, 90);
                        newvec = RPRenderer.rotateVecX(newvec, 270);
                        break;
                    }
                    case 5: {
                        newvec = RPRenderer.rotateVecZ(newvec, 270);
                        newvec = RPRenderer.rotateVecX(newvec, 270);
                    }
                }
                vecs[v] = new Vec3UV(newvec.field_72450_a, newvec.field_72448_b, newvec.field_72449_c, originalvecs[v].u, originalvecs[v].v);
            }
            rotatedvecs[rotation] = vecs;
        }
        return rotatedvecs;
    }

    private void renderRepeaterFace(CompatibilityRenderer renderer, int face, int facedata, BlockPos pos, IBlockAccess world) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        CompatibilityTessellator tessellator = renderer.tessellator;
        int facerotation = facedata & 3;
        if (face == 1 && facerotation == 0) {
            facerotation = 2;
        } else if (face == 1 && facerotation == 2) {
            facerotation = 0;
        } else if (face == 2 && facerotation == 1) {
            facerotation = 3;
        } else if (face == 2 && facerotation == 3) {
            facerotation = 1;
        } else if (face == 5 && facerotation == 1) {
            facerotation = 3;
        } else if (face == 5 && facerotation == 3) {
            facerotation = 1;
        }
        tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        boolean devmode = false;
        if (this.vecs_redstoneRepeaterIdle == null || devmode) {
            renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
            renderer.setOverrideBlockTexture(RPClientProxy.repeaterIcon_Idle);
            this.vecs_redstoneRepeaterIdle = this.computeStandardBlockRotations(renderer, (Block)Blocks.field_150413_aR);
            renderer.clearOverrideBlockTexture();
        }
        if (this.vecs_redstoneRepeaterActive == null || devmode) {
            renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
            renderer.setOverrideBlockTexture(RPClientProxy.repeaterIcon_Active);
            this.vecs_redstoneRepeaterActive = this.computeStandardBlockRotations(renderer, (Block)Blocks.field_150416_aS);
            renderer.clearOverrideBlockTexture();
        }
        Vec3UV[][][] vecs = (facedata & 4) > 0 ? this.vecs_redstoneRepeaterActive : this.vecs_redstoneRepeaterIdle;
        boolean par5 = true;
        boolean par6 = true;
        boolean par7 = true;
        float f3 = 0.5f;
        float f4 = 1.0f;
        float f5 = 0.8f;
        float f6 = 0.6f;
        float f7 = f4 * (float)par5;
        float f8 = f4 * (float)par6;
        float f9 = f4 * (float)par7;
        float f10 = f3;
        float f11 = f5;
        float f12 = f6;
        float f13 = f3;
        float f14 = f5;
        float f15 = f6;
        float f16 = f3;
        float f17 = f5;
        float f18 = f6;
        for (int f = 0; f < 6; ++f) {
            switch (f) {
                case 0: {
                    tessellator.setColorOpaque_F(f10, f13, f16);
                    break;
                }
                case 1: {
                    tessellator.setColorOpaque_F(f7, f8, f9);
                    break;
                }
                case 2: {
                    tessellator.setColorOpaque_F(f11, f14, f17);
                    break;
                }
                case 3: {
                    tessellator.setColorOpaque_F(f11, f14, f17);
                    break;
                }
                case 4: {
                    tessellator.setColorOpaque_F(f12, f15, f18);
                    break;
                }
                case 5: {
                    tessellator.setColorOpaque_F(f12, f15, f18);
                    break;
                }
                default: {
                    tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
                }
            }
            for (int v = 0; v < 4; ++v) {
                Vec3UV[] thisface = vecs[face][f];
                int uvnum = v;
                if (f == 1) {
                    uvnum += facerotation;
                    uvnum &= 3;
                }
                tessellator.addVertexWithUV(thisface[v].x + (double)x, thisface[v].y + (double)y, thisface[v].z + (double)z, thisface[uvnum].u, thisface[uvnum].v);
            }
        }
        facerotation = facedata & 3;
        tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        boolean repeateractive = (facedata & 4) > 1;
        this.renderTorchOriented(renderer, face, facerotation, repeateractive, x, y, z, 0.0f, -0.18f, 0.31f);
        float baseposition = 0.065f;
        int delayswitch = (facedata & 0x18) >> 3;
        if (RedstonePasteMod.instance.blockRedstonePaste.isRepeaterLocked(world, x, y, z)) {
            this.renderLockBarOriented(renderer, face, facedata, x, y, z);
        } else {
            this.renderTorchOriented(renderer, face, facerotation, repeateractive, x, y, z, 0.0f, -0.18f, baseposition - 0.126f * (float)delayswitch);
        }
    }

    private void renderLockBarOriented(CompatibilityRenderer renderer, int face, int facedata, int x, int y, int z) {
        float xoffset = 0.0f;
        float yoffset = 0.0f;
        float zoffset = 0.0f;
        float size = 0.125f;
        int repeaterSetting = (facedata & 0x18) >> 3;
        float sixteenth = 0.0625f;
        float position = sixteenth * (float)(6 + repeaterSetting * 2);
        position = 0.0f;
        int worlddir = BlockRedstonePaste.repeaterDirectionToWorldDirection(face, facedata);
        if (worlddir == -1) {
            return;
        }
        if (this.rotatedLockBarVecs[0] == null) {
            renderer.setRenderBounds(0.125, 0.0, 0.0, 0.875, size, size);
            this.rotatedLockBarVecs[0] = this.computeStandardBlock(renderer, Blocks.field_150357_h, 0, 0, 0, 0);
        }
        if (this.rotatedLockBarVecs[1] == null) {
            renderer.setRenderBounds(0.0, 0.0, 0.125, size, size, 0.875);
            this.rotatedLockBarVecs[1] = this.computeStandardBlock(renderer, Blocks.field_150357_h, 0, 0, 0, 0);
        }
        if (this.rotatedLockBarVecs[2] == null) {
            renderer.setRenderBounds(0.0, 0.125, 0.0, size, 0.875, size);
            this.rotatedLockBarVecs[2] = this.computeStandardBlock(renderer, Blocks.field_150357_h, 0, 0, 0, 0);
        }
        CompatibilityTessellator tessellator = renderer.tessellator;
        tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        int repeaterDir = facedata & 3;
        Vec3UV[][] vecs = this.rotatedLockBarVecs[0];
        block0 : switch (face) {
            case 0: 
            case 1: {
                yoffset = face == 0 ? sixteenth * 2.0f : 1.0f - sixteenth * 4.0f;
                switch (repeaterDir) {
                    case 0: {
                        vecs = this.rotatedLockBarVecs[0];
                        zoffset = sixteenth * (float)(8 - repeaterSetting * 2);
                        break;
                    }
                    case 1: {
                        vecs = this.rotatedLockBarVecs[1];
                        xoffset = sixteenth * (float)(6 + repeaterSetting * 2);
                        break;
                    }
                    case 2: {
                        vecs = this.rotatedLockBarVecs[0];
                        zoffset = sixteenth * (float)(6 + repeaterSetting * 2);
                        break;
                    }
                    case 3: {
                        vecs = this.rotatedLockBarVecs[1];
                        xoffset = sixteenth * (float)(8 - repeaterSetting * 2);
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                zoffset = face == 2 ? sixteenth * 2.0f : 1.0f - sixteenth * 4.0f;
                switch (repeaterDir) {
                    case 0: {
                        vecs = this.rotatedLockBarVecs[0];
                        yoffset = sixteenth * (float)(8 - repeaterSetting * 2);
                        break;
                    }
                    case 1: {
                        vecs = this.rotatedLockBarVecs[2];
                        xoffset = sixteenth * (float)(6 + repeaterSetting * 2);
                        break;
                    }
                    case 2: {
                        vecs = this.rotatedLockBarVecs[0];
                        yoffset = sixteenth * (float)(6 + repeaterSetting * 2);
                        break;
                    }
                    case 3: {
                        vecs = this.rotatedLockBarVecs[2];
                        xoffset = sixteenth * (float)(8 - repeaterSetting * 2);
                    }
                }
                break;
            }
            case 4: 
            case 5: {
                xoffset = face == 4 ? sixteenth * 2.0f : 1.0f - sixteenth * 4.0f;
                switch (repeaterDir) {
                    case 0: {
                        vecs = this.rotatedLockBarVecs[1];
                        yoffset = sixteenth * (float)(8 - repeaterSetting * 2);
                        break block0;
                    }
                    case 1: {
                        vecs = this.rotatedLockBarVecs[2];
                        zoffset = sixteenth * (float)(6 + repeaterSetting * 2);
                        break block0;
                    }
                    case 2: {
                        vecs = this.rotatedLockBarVecs[1];
                        yoffset = sixteenth * (float)(6 + repeaterSetting * 2);
                        break block0;
                    }
                    case 3: {
                        vecs = this.rotatedLockBarVecs[2];
                        zoffset = sixteenth * (float)(8 - repeaterSetting * 2);
                    }
                }
            }
        }
        float f3 = 0.5f;
        float f4 = 1.0f;
        float f5 = 0.8f;
        float f6 = 0.6f;
        float f7 = f4;
        float f8 = f4;
        float f9 = f4;
        float f10 = f3;
        float f11 = f5;
        float f12 = f6;
        float f13 = f3;
        float f14 = f5;
        float f15 = f6;
        float f16 = f3;
        float f17 = f5;
        float f18 = f6;
        for (int f = 0; f < 6; ++f) {
            switch (f) {
                case 0: {
                    tessellator.setColorOpaque_F(f10, f13, f16);
                    break;
                }
                case 1: {
                    tessellator.setColorOpaque_F(f7, f8, f9);
                    break;
                }
                case 2: {
                    tessellator.setColorOpaque_F(f11, f14, f17);
                    break;
                }
                case 3: {
                    tessellator.setColorOpaque_F(f11, f14, f17);
                    break;
                }
                case 4: {
                    tessellator.setColorOpaque_F(f12, f15, f18);
                    break;
                }
                case 5: {
                    tessellator.setColorOpaque_F(f12, f15, f18);
                }
            }
            for (int v = 0; v < 4; ++v) {
                tessellator.addVertexWithUV((double)x + vecs[f][v].x + (double)xoffset, (double)y + vecs[f][v].y + (double)yoffset, (double)z + vecs[f][v].z + (double)zoffset, vecs[f][v].u, vecs[f][v].v);
            }
        }
    }

    private void renderTorchOriented(CompatibilityRenderer renderer, int face, int facerotation, boolean torchactive, int x, int y, int z, float xoffset, float yoffset, float zoffset) {
        Vec3UV[] vecs;
        boolean devmode = false;
        if (this.vecs_redstoneTorchActive == null || devmode) {
            vecs = this.computeTorchAtAngle(renderer, Blocks.field_150429_aA, 0.0, 0.0, 0.0, 0.0, 0.0, 0);
            this.vecs_redstoneTorchActive = this.computeRotations(vecs, 24);
        }
        if (this.vecs_redstoneTorchIdle == null || devmode) {
            vecs = this.computeTorchAtAngle(renderer, Blocks.field_150437_az, 0.0, 0.0, 0.0, 0.0, 0.0, 0);
            this.vecs_redstoneTorchIdle = this.computeRotations(vecs, 24);
        }
        Vec3UV[] torch = torchactive ? this.vecs_redstoneTorchActive[face] : this.vecs_redstoneTorchIdle[face];
        Vec3d vec = new Vec3d((double)xoffset + 0.5, (double)yoffset + 0.5, (double)zoffset + 0.5);
        switch (face) {
            case 0: {
                vec = new Vec3d((double)xoffset + 0.5, (double)yoffset + 0.5, (double)zoffset + 0.5);
                break;
            }
            case 1: {
                vec = new Vec3d((double)xoffset + 0.5, (double)(-yoffset) + 0.5, (double)zoffset + 0.5);
                break;
            }
            case 2: {
                vec = new Vec3d((double)xoffset + 0.5, (double)zoffset + 0.5, (double)yoffset + 0.5);
                break;
            }
            case 3: {
                vec = new Vec3d((double)xoffset + 0.5, (double)zoffset + 0.5, (double)(-yoffset) + 0.5);
                break;
            }
            case 4: {
                vec = new Vec3d((double)yoffset + 0.5, (double)zoffset + 0.5, (double)xoffset + 0.5);
                break;
            }
            case 5: {
                vec = new Vec3d((double)(-yoffset) + 0.5, (double)zoffset + 0.5, (double)xoffset + 0.5);
            }
        }
        int[] degtrans = new int[]{0, 90, 180, 270};
        int[] degtrans2 = new int[]{0, 270, 180, 90};
        switch (face) {
            case 0: 
            case 1: {
                vec = RPRenderer.rotateVecY(vec, degtrans2[facerotation]);
                break;
            }
            case 2: 
            case 3: {
                vec = RPRenderer.rotateVecZ(vec, degtrans2[facerotation]);
                break;
            }
            case 4: 
            case 5: {
                vec = RPRenderer.rotateVecX(vec, degtrans[facerotation]);
            }
        }
        xoffset = (float)vec.field_72450_a - 0.5f;
        yoffset = (float)vec.field_72448_b - 0.5f;
        zoffset = (float)vec.field_72449_c - 0.5f;
        for (int n = 0; n < 24; ++n) {
            renderer.tessellator.addVertexWithUV((double)x + torch[n].x + (double)xoffset, (double)y + torch[n].y + (double)yoffset, (double)z + torch[n].z + (double)zoffset, torch[n].u, torch[n].v);
        }
    }

    private void renderComparatorFace(CompatibilityRenderer renderer, int face, int facedata, BlockPos pos, IBlockAccess world) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        CompatibilityTessellator tessellator = renderer.tessellator;
        int facerotation = facedata & 3;
        if (face == 1 && facerotation == 0) {
            facerotation = 2;
        } else if (face == 1 && facerotation == 2) {
            facerotation = 0;
        } else if (face == 2 && facerotation == 1) {
            facerotation = 3;
        } else if (face == 2 && facerotation == 3) {
            facerotation = 1;
        } else if (face == 5 && facerotation == 1) {
            facerotation = 3;
        } else if (face == 5 && facerotation == 3) {
            facerotation = 1;
        }
        tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        boolean devmode = false;
        if (this.vecs_redstoneComparatorIdle == null || devmode) {
            renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
            renderer.setOverrideBlockTexture(RPClientProxy.comparatorIcon_Idle);
            this.vecs_redstoneComparatorIdle = this.computeStandardBlockRotations(renderer, (Block)Blocks.field_150441_bU);
            renderer.clearOverrideBlockTexture();
        }
        if (this.vecs_redstoneComparatorActive == null || devmode) {
            renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
            renderer.setOverrideBlockTexture(RPClientProxy.comparatorIcon_Active);
            this.vecs_redstoneComparatorActive = this.computeStandardBlockRotations(renderer, (Block)Blocks.field_150455_bV);
            renderer.clearOverrideBlockTexture();
        }
        boolean comparatormode = (facedata & 4) > 0;
        boolean comparatoractive = (facedata & 0x78) > 0;
        Vec3UV[][][] vecs = comparatoractive ? this.vecs_redstoneComparatorActive : this.vecs_redstoneComparatorIdle;
        boolean par5 = true;
        boolean par6 = true;
        boolean par7 = true;
        float f3 = 0.5f;
        float f4 = 1.0f;
        float f5 = 0.8f;
        float f6 = 0.6f;
        float f7 = f4 * (float)par5;
        float f8 = f4 * (float)par6;
        float f9 = f4 * (float)par7;
        float f10 = f3;
        float f11 = f5;
        float f12 = f6;
        float f13 = f3;
        float f14 = f5;
        float f15 = f6;
        float f16 = f3;
        float f17 = f5;
        float f18 = f6;
        for (int f = 0; f < 6; ++f) {
            switch (f) {
                case 0: {
                    tessellator.setColorOpaque_F(f10, f13, f16);
                    break;
                }
                case 1: {
                    tessellator.setColorOpaque_F(f7, f8, f9);
                    break;
                }
                case 2: {
                    tessellator.setColorOpaque_F(f11, f14, f17);
                    break;
                }
                case 3: {
                    tessellator.setColorOpaque_F(f11, f14, f17);
                    break;
                }
                case 4: {
                    tessellator.setColorOpaque_F(f12, f15, f18);
                    break;
                }
                case 5: {
                    tessellator.setColorOpaque_F(f12, f15, f18);
                    break;
                }
                default: {
                    tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
                }
            }
            for (int v = 0; v < 4; ++v) {
                Vec3UV[] thisface = vecs[face][f];
                int uvnum = v;
                if (f == 1) {
                    uvnum += facerotation;
                    uvnum &= 3;
                }
                tessellator.addVertexWithUV(thisface[v].x + (double)x, thisface[v].y + (double)y, thisface[v].z + (double)z, thisface[uvnum].u, thisface[uvnum].v);
            }
        }
        tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        facerotation = facedata & 3;
        this.renderTorchOriented(renderer, face, facerotation, comparatormode, x, y, z, 0.0f, comparatormode ? -0.1875f : -0.375f, 0.31f);
        this.renderTorchOriented(renderer, face, facerotation, comparatoractive, x, y, z, 0.1875f, -0.1875f, -0.25f);
        this.renderTorchOriented(renderer, face, facerotation, comparatoractive, x, y, z, -0.1875f, -0.1875f, -0.25f);
    }

    public static TextureAtlasSprite findSlabTexture(Block block, int meta) {
        TextureAtlasSprite missing = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(block.func_176203_a(meta));
        if (sprite == null) {
            return missing;
        }
        return sprite;
    }

    private void renderSlabFace(CompatibilityRenderer renderer, int face, int facedata, BlockPos pos) {
        boolean noOverride = renderer.overrideBlockTexture == null;
        Block maskBlockID = Block.func_149729_e((int)(facedata & 0xFFFF));
        int maskBlockDamage = facedata >> 16;
        if (maskBlockID == Blocks.field_150333_U && maskBlockDamage == 0) {
            maskBlockID = Blocks.field_150348_b;
        }
        if (maskBlockID == null) {
            maskBlockID = Blocks.field_150348_b;
            maskBlockDamage = 0;
        }
        if (noOverride) {
            renderer.setOverrideBlockTexture(RPRenderer.findSlabTexture(maskBlockID, maskBlockDamage));
        }
        switch (face) {
            case 0: {
                renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
                break;
            }
            case 1: {
                renderer.setRenderBounds(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
                break;
            }
            case 2: {
                renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 0.5);
                break;
            }
            case 3: {
                renderer.setRenderBounds(0.0, 0.0, 0.5, 1.0, 1.0, 1.0);
                break;
            }
            case 4: {
                renderer.setRenderBounds(0.0, 0.0, 0.0, 0.5, 1.0, 1.0);
                break;
            }
            case 5: {
                renderer.setRenderBounds(0.5, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
        }
        renderer.renderStandardBlock(maskBlockID, pos);
        if (noOverride) {
            renderer.clearOverrideBlockTexture();
        }
    }

    private void renderPasteFace(CompatibilityRenderer renderer, int strength, int face, int facedata, BlockPos pos, TextureAtlasSprite icon1) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        double facedist = 0.015625;
        facedist = 0.015625;
        BlockRedstonePaste block = RedstonePasteMod.instance.blockRedstonePaste;
        if (strength < 0) {
            strength = 0;
        }
        if (strength > 15) {
            strength = 15;
        }
        renderer.tessellator.setColorOpaque(this.colorlist[strength].getRed(), this.colorlist[strength].getGreen(), this.colorlist[strength].getBlue());
        switch (face) {
            case 0: {
                renderer.uvRotateTop = 1;
                if ((facedata & 1) == 1) {
                    renderer.setRenderBounds(0.25, 0.0, 0.0, 0.75, facedist, 0.5);
                    renderer.renderFaceYPos(renderer, pos, icon1);
                    renderer.uvRotateEast = 1;
                    renderer.renderFaceZNeg(renderer, pos, icon1);
                    renderer.uvRotateEast = 0;
                }
                if ((facedata & 2) == 2) {
                    renderer.setRenderBounds(0.25, 0.0, 0.5, 0.75, facedist, 1.0);
                    renderer.renderFaceYPos(renderer, pos, icon1);
                    renderer.uvRotateWest = 1;
                    renderer.renderFaceZPos(renderer, pos, icon1);
                    renderer.uvRotateWest = 0;
                }
                renderer.uvRotateTop = 0;
                if ((facedata & 4) == 4) {
                    renderer.setRenderBounds(0.0, 0.0, 0.25, 0.5, facedist + 0.001, 0.75);
                    renderer.renderFaceYPos(renderer, pos, icon1);
                    renderer.uvRotateNorth = 1;
                    renderer.renderFaceXNeg(renderer, pos, icon1);
                    renderer.uvRotateNorth = 0;
                }
                if ((facedata & 8) != 8) break;
                renderer.setRenderBounds(0.5, 0.0, 0.25, 1.0, facedist + 0.001, 0.75);
                renderer.renderFaceYPos(renderer, pos, icon1);
                renderer.uvRotateSouth = 1;
                renderer.renderFaceXPos(renderer, pos, icon1);
                renderer.uvRotateSouth = 0;
                break;
            }
            case 1: {
                renderer.uvRotateBottom = 1;
                if ((facedata & 1) == 1) {
                    renderer.setRenderBounds(0.25, 1.0 - facedist, 0.0, 0.75, 1.0, 0.5);
                    renderer.renderFaceYNeg(renderer, pos, icon1);
                    renderer.uvRotateEast = 1;
                    renderer.renderFaceZNeg(renderer, pos, icon1);
                    renderer.uvRotateEast = 0;
                }
                if ((facedata & 2) == 2) {
                    renderer.setRenderBounds(0.25, 1.0 - facedist, 0.5, 0.75, 1.0, 1.0);
                    renderer.renderFaceYNeg(renderer, pos, icon1);
                    renderer.uvRotateWest = 1;
                    renderer.renderFaceZPos(renderer, pos, icon1);
                    renderer.uvRotateWest = 0;
                }
                renderer.uvRotateBottom = 0;
                if ((facedata & 4) == 4) {
                    renderer.setRenderBounds(0.0, 1.0 - facedist - 0.001, 0.25, 0.5, 1.0, 0.75);
                    renderer.renderFaceYNeg(renderer, pos, icon1);
                    renderer.uvRotateNorth = 1;
                    renderer.renderFaceXNeg(renderer, pos, icon1);
                    renderer.uvRotateNorth = 0;
                }
                if ((facedata & 8) != 8) break;
                renderer.setRenderBounds(0.5, 1.0 - facedist - 0.001, 0.25, 1.0, 1.0, 0.75);
                renderer.renderFaceYNeg(renderer, pos, icon1);
                renderer.uvRotateSouth = 1;
                renderer.renderFaceXPos(renderer, pos, icon1);
                renderer.uvRotateSouth = 0;
                break;
            }
            case 2: {
                renderer.uvRotateWest = 1;
                if ((facedata & 1) == 1) {
                    renderer.setRenderBounds(0.25, 0.0, 0.0, 0.75, 0.5, facedist);
                    renderer.renderFaceZPos(renderer, pos, icon1);
                    renderer.uvRotateBottom = 1;
                    renderer.renderFaceYNeg(renderer, pos, icon1);
                    renderer.uvRotateBottom = 0;
                }
                if ((facedata & 2) == 2) {
                    renderer.setRenderBounds(0.25, 0.5, 0.0, 0.75, 1.0, facedist);
                    renderer.renderFaceZPos(renderer, pos, icon1);
                    renderer.uvRotateTop = 1;
                    renderer.renderFaceYPos(renderer, pos, icon1);
                    renderer.uvRotateTop = 0;
                }
                renderer.uvRotateWest = 0;
                if ((facedata & 4) == 4) {
                    renderer.setRenderBounds(0.0, 0.25, 0.0, 0.5, 0.75, facedist + 0.001);
                    renderer.renderFaceZPos(renderer, pos, icon1);
                    renderer.renderFaceXNeg(renderer, pos, icon1);
                }
                if ((facedata & 8) != 8) break;
                renderer.setRenderBounds(0.5, 0.25, 0.0, 1.0, 0.75, facedist + 0.001);
                renderer.renderFaceZPos(renderer, pos, icon1);
                renderer.renderFaceXPos(renderer, pos, icon1);
                break;
            }
            case 3: {
                renderer.uvRotateEast = 1;
                if ((facedata & 1) == 1) {
                    renderer.setRenderBounds(0.25, 0.0, 1.0 - facedist, 0.75, 0.5, 1.0);
                    renderer.renderFaceZNeg(renderer, pos, icon1);
                    renderer.uvRotateBottom = 1;
                    renderer.renderFaceYNeg(renderer, pos, icon1);
                    renderer.uvRotateBottom = 0;
                }
                if ((facedata & 2) == 2) {
                    renderer.setRenderBounds(0.25, 0.5, 1.0 - facedist, 0.75, 1.0, 1.0);
                    renderer.renderFaceZNeg(renderer, pos, icon1);
                    renderer.uvRotateTop = 1;
                    renderer.renderFaceYPos(renderer, pos, icon1);
                    renderer.uvRotateTop = 0;
                }
                renderer.uvRotateEast = 0;
                if ((facedata & 4) == 4) {
                    renderer.setRenderBounds(0.0, 0.25, 1.0 - facedist - 0.001, 0.5, 0.75, 1.0);
                    renderer.renderFaceZNeg(renderer, pos, icon1);
                    renderer.renderFaceXNeg(renderer, pos, icon1);
                }
                if ((facedata & 8) != 8) break;
                renderer.setRenderBounds(0.5, 0.25, 1.0 - facedist - 0.001, 1.0, 0.75, 1.0);
                renderer.renderFaceZNeg(renderer, pos, icon1);
                renderer.renderFaceXPos(renderer, pos, icon1);
                break;
            }
            case 4: {
                renderer.uvRotateSouth = 1;
                if ((facedata & 1) == 1) {
                    renderer.setRenderBounds(0.0, 0.0, 0.25, facedist, 0.5, 0.75);
                    renderer.renderFaceXPos(renderer, pos, icon1);
                    renderer.renderFaceYNeg(renderer, pos, icon1);
                }
                if ((facedata & 2) == 2) {
                    renderer.setRenderBounds(0.0, 0.5, 0.25, facedist, 1.0, 0.75);
                    renderer.renderFaceXPos(renderer, pos, icon1);
                    renderer.renderFaceYPos(renderer, pos, icon1);
                }
                renderer.uvRotateSouth = 0;
                if ((facedata & 4) == 4) {
                    renderer.setRenderBounds(0.0, 0.25, 0.0, facedist + 0.001, 0.75, 0.5);
                    renderer.renderFaceXPos(renderer, pos, icon1);
                    renderer.renderFaceZNeg(renderer, pos, icon1);
                }
                if ((facedata & 8) != 8) break;
                renderer.setRenderBounds(0.0, 0.25, 0.5, facedist + 0.001, 0.75, 1.0);
                renderer.renderFaceXPos(renderer, pos, icon1);
                renderer.renderFaceZPos(renderer, pos, icon1);
                break;
            }
            case 5: {
                renderer.uvRotateNorth = 1;
                if ((facedata & 1) == 1) {
                    renderer.setRenderBounds(1.0 - facedist, 0.0, 0.25, 1.0, 0.5, 0.75);
                    renderer.renderFaceXNeg(renderer, pos, icon1);
                    renderer.renderFaceYNeg(renderer, pos, icon1);
                }
                if ((facedata & 2) == 2) {
                    renderer.setRenderBounds(1.0 - facedist, 0.5, 0.25, 1.0, 1.0, 0.75);
                    renderer.renderFaceXNeg(renderer, pos, icon1);
                    renderer.renderFaceYPos(renderer, pos, icon1);
                }
                renderer.uvRotateNorth = 0;
                if ((facedata & 4) == 4) {
                    renderer.setRenderBounds(1.0 - facedist - 0.001, 0.25, 0.0, 1.0, 0.75, 0.5);
                    renderer.renderFaceXNeg(renderer, pos, icon1);
                    renderer.renderFaceZNeg(renderer, pos, icon1);
                }
                if ((facedata & 8) != 8) break;
                renderer.setRenderBounds(1.0 - facedist - 0.001, 0.25, 0.5, 1.0, 0.75, 1.0);
                renderer.renderFaceXNeg(renderer, pos, icon1);
                renderer.renderFaceZPos(renderer, pos, icon1);
            }
        }
    }

    @Override
    public boolean renderBlock(IBlockState state, BlockPos pos, IBlockAccess blockAccess, BufferBuilder worldRenderer) {
        CompatibilityTessellator tessellator = new CompatibilityTessellator(worldRenderer);
        TileEntity te = blockAccess.func_175625_s(pos);
        if (te == null || !(te instanceof TileEntityRedstonePaste)) {
            return true;
        }
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)te;
        int brightness = RedstonePasteMod.instance.blockRedstonePaste.func_185484_c(state, blockAccess, pos);
        tessellator.setBrightness(brightness);
        float f = 1.0f;
        int l = 0x88BB00;
        float f1 = (float)(l >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(l & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f5 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            float f6 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f2 = f5;
            f3 = f6;
        }
        tessellator.setColorOpaque_F(f * f1, f * f2, f * f3);
        CompatibilityRenderer renderBlocks = new CompatibilityRenderer(tessellator, blockAccess);
        renderBlocks.setRenderBounds(0.0, 0.015625, 0.0, 1.0, 0.015625, 1.0);
        TextureAtlasSprite pasteSprite = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174952_b().func_110572_b("redstonepaste:blocks/redstonepaste_block");
        boolean noOverride = true;
        if (renderBlocks.overrideBlockTexture == null) {
            noOverride = true;
        }
        for (int n = 0; n < 6; ++n) {
            if (terp.faces[n] > 0 && noOverride) {
                this.renderPasteFace(renderBlocks, terp.facedata[n], n, terp.faces[n], pos, pasteSprite);
            }
            if (terp.facetype[n] == 1) {
                this.renderSlabFace(renderBlocks, n, terp.facedata[n], pos);
            }
            if (terp.facetype[n] == 2 && noOverride) {
                this.renderRepeaterFace(renderBlocks, n, terp.facedata[n], pos, blockAccess);
            }
            if (terp.facetype[n] != 3 || !noOverride) continue;
            this.renderComparatorFace(renderBlocks, n, terp.facedata[n], pos, blockAccess);
        }
        return true;
    }

    @Override
    public boolean renderBlockDamage(IBlockState state, BlockPos pos, TextureAtlasSprite sprite, IBlockAccess blockAccess) {
        return true;
    }

    private class Vec3UV {
        double x;
        double y;
        double z;
        double u;
        double v;

        public Vec3UV(double x, double y, double z, double u, double v) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.u = u;
            this.v = v;
        }
    }
}

