/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.redstonepaste;

import net.fybertech.redstonepaste.CompatibilityTessellator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class CompatibilityRenderer {
    public int uvRotateBottom = 0;
    public int uvRotateTop = 0;
    public int uvRotateNorth = 0;
    public int uvRotateSouth = 0;
    public int uvRotateWest = 0;
    public int uvRotateEast = 0;
    public CompatibilityTessellator tessellator = null;
    public IBlockAccess blockAccess = null;
    public double renderMinX = 0.0;
    public double renderMinY = 0.0;
    public double renderMinZ = 0.0;
    public double renderMaxX = 0.0;
    public double renderMaxY = 0.0;
    public double renderMaxZ = 0.0;
    public boolean flipTexture = false;
    public TextureAtlasSprite overrideBlockTexture = null;
    private static float bottomShading = 0.5f;
    private static float topShading = 1.0f;
    private static float northSouthShading = 0.8f;
    private static float westEastShading = 0.6f;

    public CompatibilityRenderer(CompatibilityTessellator t, IBlockAccess ba) {
        this.tessellator = t;
        this.blockAccess = ba;
    }

    public void setRenderBounds(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax) {
        this.renderMinX = xmin;
        this.renderMinY = ymin;
        this.renderMinZ = zmin;
        this.renderMaxX = xmax;
        this.renderMaxY = ymax;
        this.renderMaxZ = zmax;
    }

    public boolean hasOverrideBlockTexture() {
        return this.overrideBlockTexture != null;
    }

    public void clearOverrideBlockTexture() {
        this.overrideBlockTexture = null;
    }

    public void setOverrideBlockTexture(TextureAtlasSprite tex) {
        this.overrideBlockTexture = tex;
    }

    public void renderFaceYPos(CompatibilityRenderer renderer, BlockPos pos, TextureAtlasSprite icon) {
        if (renderer.hasOverrideBlockTexture()) {
            icon = renderer.overrideBlockTexture;
        }
        double uMinX = icon.func_94214_a(renderer.renderMinX * 16.0);
        double uMaxX = icon.func_94214_a(renderer.renderMaxX * 16.0);
        double uMinZ = icon.func_94207_b(renderer.renderMinZ * 16.0);
        double uMaxZ = icon.func_94207_b(renderer.renderMaxZ * 16.0);
        if (renderer.renderMinX < 0.0 || renderer.renderMaxX > 1.0) {
            uMinX = icon.func_94209_e();
            uMaxX = icon.func_94212_f();
        }
        if (renderer.renderMinZ < 0.0 || renderer.renderMaxZ > 1.0) {
            uMinZ = icon.func_94206_g();
            uMaxZ = icon.func_94210_h();
        }
        double fuMaxX = uMaxX;
        double fuMinX = uMinX;
        double fuMinZ = uMinZ;
        double fuMaxZ = uMaxZ;
        if (renderer.uvRotateTop == 1) {
            uMinX = icon.func_94214_a(renderer.renderMinZ * 16.0);
            uMinZ = icon.func_94207_b(16.0 - renderer.renderMaxX * 16.0);
            uMaxX = icon.func_94214_a(renderer.renderMaxZ * 16.0);
            uMaxZ = icon.func_94207_b(16.0 - renderer.renderMinX * 16.0);
            fuMinZ = uMinZ;
            fuMaxZ = uMaxZ;
            fuMaxX = uMinX;
            fuMinX = uMaxX;
            uMinZ = uMaxZ;
            uMaxZ = fuMinZ;
        } else if (renderer.uvRotateTop == 2) {
            uMinX = icon.func_94214_a(16.0 - renderer.renderMaxZ * 16.0);
            uMinZ = icon.func_94207_b(renderer.renderMinX * 16.0);
            uMaxX = icon.func_94214_a(16.0 - renderer.renderMinZ * 16.0);
            uMaxZ = icon.func_94207_b(renderer.renderMaxX * 16.0);
            fuMaxX = uMaxX;
            fuMinX = uMinX;
            uMinX = uMaxX;
            uMaxX = fuMinX;
            fuMinZ = uMaxZ;
            fuMaxZ = uMinZ;
        } else if (renderer.uvRotateTop == 3) {
            uMinX = icon.func_94214_a(16.0 - renderer.renderMinX * 16.0);
            uMaxX = icon.func_94214_a(16.0 - renderer.renderMaxX * 16.0);
            uMinZ = icon.func_94207_b(16.0 - renderer.renderMinZ * 16.0);
            uMaxZ = icon.func_94207_b(16.0 - renderer.renderMaxZ * 16.0);
            fuMaxX = uMaxX;
            fuMinX = uMinX;
            fuMinZ = uMinZ;
            fuMaxZ = uMaxZ;
        }
        double fx1 = (double)pos.func_177958_n() + renderer.renderMinX;
        double fx2 = (double)pos.func_177958_n() + renderer.renderMaxX;
        double fy = (double)pos.func_177956_o() + renderer.renderMaxY;
        double fz1 = (double)pos.func_177952_p() + renderer.renderMinZ;
        double fz2 = (double)pos.func_177952_p() + renderer.renderMaxZ;
        this.tessellator.addVertexWithUV(fx2, fy, fz2, uMaxX, uMaxZ);
        this.tessellator.addVertexWithUV(fx2, fy, fz1, fuMaxX, fuMinZ);
        this.tessellator.addVertexWithUV(fx1, fy, fz1, uMinX, uMinZ);
        this.tessellator.addVertexWithUV(fx1, fy, fz2, fuMinX, fuMaxZ);
    }

    public void renderFaceZPos(CompatibilityRenderer renderer, BlockPos pos, TextureAtlasSprite icon) {
        if (renderer.hasOverrideBlockTexture()) {
            icon = renderer.overrideBlockTexture;
        }
        double uMinX = icon.func_94214_a(renderer.renderMinX * 16.0);
        double uMaxX = icon.func_94214_a(renderer.renderMaxX * 16.0);
        double uMaxY = icon.func_94207_b(16.0 - renderer.renderMaxY * 16.0);
        double uMinY = icon.func_94207_b(16.0 - renderer.renderMinY * 16.0);
        if (renderer.flipTexture) {
            double tempU = uMinX;
            uMinX = uMaxX;
            uMaxX = tempU;
        }
        if (renderer.renderMinX < 0.0 || renderer.renderMaxX > 1.0) {
            uMinX = icon.func_94209_e();
            uMaxX = icon.func_94212_f();
        }
        if (renderer.renderMinY < 0.0 || renderer.renderMaxY > 1.0) {
            uMaxY = icon.func_94206_g();
            uMinY = icon.func_94210_h();
        }
        double fuMinX = uMinX;
        double fuMaxX = uMaxX;
        double fuMinY = uMinY;
        double fuMaxY = uMaxY;
        if (renderer.uvRotateWest == 1) {
            uMinX = icon.func_94214_a(renderer.renderMinY * 16.0);
            uMinY = icon.func_94207_b(16.0 - renderer.renderMinX * 16.0);
            uMaxX = icon.func_94214_a(renderer.renderMaxY * 16.0);
            fuMaxY = uMaxY = (double)icon.func_94207_b(16.0 - renderer.renderMaxX * 16.0);
            fuMinY = uMinY;
            fuMaxX = uMinX;
            fuMinX = uMaxX;
            uMaxY = uMinY;
            uMinY = fuMaxY;
        } else if (renderer.uvRotateWest == 2) {
            uMinX = icon.func_94214_a(16.0 - renderer.renderMaxY * 16.0);
            uMaxY = icon.func_94207_b(renderer.renderMinX * 16.0);
            uMaxX = icon.func_94214_a(16.0 - renderer.renderMinY * 16.0);
            uMinY = icon.func_94207_b(renderer.renderMaxX * 16.0);
            fuMaxX = uMaxX;
            fuMinX = uMinX;
            uMinX = uMaxX;
            uMaxX = fuMinX;
            fuMaxY = uMinY;
            fuMinY = uMaxY;
        } else if (renderer.uvRotateWest == 3) {
            uMinX = icon.func_94214_a(16.0 - renderer.renderMinX * 16.0);
            uMaxX = icon.func_94214_a(16.0 - renderer.renderMaxX * 16.0);
            uMaxY = icon.func_94207_b(renderer.renderMaxY * 16.0);
            uMinY = icon.func_94207_b(renderer.renderMinY * 16.0);
            fuMaxX = uMaxX;
            fuMinX = uMinX;
            fuMaxY = uMaxY;
            fuMinY = uMinY;
        }
        double fx1 = (double)pos.func_177958_n() + renderer.renderMinX;
        double fx2 = (double)pos.func_177958_n() + renderer.renderMaxX;
        double fy1 = (double)pos.func_177956_o() + renderer.renderMinY;
        double fy2 = (double)pos.func_177956_o() + renderer.renderMaxY;
        double fz = (double)pos.func_177952_p() + renderer.renderMaxZ;
        this.tessellator.addVertexWithUV(fx1, fy2, fz, uMinX, uMaxY);
        this.tessellator.addVertexWithUV(fx1, fy1, fz, fuMinX, fuMinY);
        this.tessellator.addVertexWithUV(fx2, fy1, fz, uMaxX, uMinY);
        this.tessellator.addVertexWithUV(fx2, fy2, fz, fuMaxX, fuMaxY);
    }

    public void renderFaceXNeg(CompatibilityRenderer renderer, BlockPos pos, TextureAtlasSprite icon) {
        if (renderer.hasOverrideBlockTexture()) {
            icon = renderer.overrideBlockTexture;
        }
        double uMinZ = icon.func_94214_a(renderer.renderMinZ * 16.0);
        double uMaxZ = icon.func_94214_a(renderer.renderMaxZ * 16.0);
        double uMaxY = icon.func_94207_b(16.0 - renderer.renderMaxY * 16.0);
        double uMinY = icon.func_94207_b(16.0 - renderer.renderMinY * 16.0);
        if (renderer.flipTexture) {
            double tempU = uMinZ;
            uMinZ = uMaxZ;
            uMaxZ = tempU;
        }
        if (renderer.renderMinZ < 0.0 || renderer.renderMaxZ > 1.0) {
            uMinZ = icon.func_94209_e();
            uMaxZ = icon.func_94212_f();
        }
        if (renderer.renderMinY < 0.0 || renderer.renderMaxY > 1.0) {
            uMaxY = icon.func_94206_g();
            uMinY = icon.func_94210_h();
        }
        double fuMinZ = uMinZ;
        double fuMaxZ = uMaxZ;
        double fuMinY = uMinY;
        double fuMaxY = uMaxY;
        if (renderer.uvRotateNorth == 1) {
            uMinZ = icon.func_94214_a(renderer.renderMinY * 16.0);
            uMaxY = icon.func_94207_b(16.0 - renderer.renderMaxZ * 16.0);
            uMaxZ = icon.func_94214_a(renderer.renderMaxY * 16.0);
            uMinY = icon.func_94207_b(16.0 - renderer.renderMinZ * 16.0);
            fuMaxY = uMaxY;
            fuMinY = uMinY;
            fuMaxZ = uMinZ;
            fuMinZ = uMaxZ;
            uMaxY = uMinY;
            uMinY = fuMaxY;
        } else if (renderer.uvRotateNorth == 2) {
            uMinZ = icon.func_94214_a(16.0 - renderer.renderMaxY * 16.0);
            uMaxY = icon.func_94207_b(renderer.renderMinZ * 16.0);
            uMaxZ = icon.func_94214_a(16.0 - renderer.renderMinY * 16.0);
            uMinY = icon.func_94207_b(renderer.renderMaxZ * 16.0);
            fuMaxZ = uMaxZ;
            fuMinZ = uMinZ;
            uMinZ = uMaxZ;
            uMaxZ = fuMinZ;
            fuMaxY = uMinY;
            fuMinY = uMaxY;
        } else if (renderer.uvRotateNorth == 3) {
            uMinZ = icon.func_94214_a(16.0 - renderer.renderMinZ * 16.0);
            uMaxZ = icon.func_94214_a(16.0 - renderer.renderMaxZ * 16.0);
            uMaxY = icon.func_94207_b(renderer.renderMaxY * 16.0);
            uMinY = icon.func_94207_b(renderer.renderMinY * 16.0);
            fuMaxZ = uMaxZ;
            fuMinZ = uMinZ;
            fuMaxY = uMaxY;
            fuMinY = uMinY;
        }
        double fx = (double)pos.func_177958_n() + renderer.renderMinX;
        double fy1 = (double)pos.func_177956_o() + renderer.renderMinY;
        double fy2 = (double)pos.func_177956_o() + renderer.renderMaxY;
        double fz1 = (double)pos.func_177952_p() + renderer.renderMinZ;
        double fz2 = (double)pos.func_177952_p() + renderer.renderMaxZ;
        this.tessellator.addVertexWithUV(fx, fy2, fz2, fuMaxZ, fuMaxY);
        this.tessellator.addVertexWithUV(fx, fy2, fz1, uMinZ, uMaxY);
        this.tessellator.addVertexWithUV(fx, fy1, fz1, fuMinZ, fuMinY);
        this.tessellator.addVertexWithUV(fx, fy1, fz2, uMaxZ, uMinY);
    }

    public void renderFaceYNeg(CompatibilityRenderer renderer, BlockPos pos, TextureAtlasSprite icon) {
        if (renderer.hasOverrideBlockTexture()) {
            icon = renderer.overrideBlockTexture;
        }
        double uMinX = icon.func_94214_a(renderer.renderMinX * 16.0);
        double uMaxX = icon.func_94214_a(renderer.renderMaxX * 16.0);
        double uMinZ = icon.func_94207_b(renderer.renderMinZ * 16.0);
        double uMaxZ = icon.func_94207_b(renderer.renderMaxZ * 16.0);
        if (renderer.renderMinX < 0.0 || renderer.renderMaxX > 1.0) {
            uMinX = icon.func_94209_e();
            uMaxX = icon.func_94212_f();
        }
        if (renderer.renderMinZ < 0.0 || renderer.renderMaxZ > 1.0) {
            uMinZ = icon.func_94206_g();
            uMaxZ = icon.func_94210_h();
        }
        double fuMinX = uMinX;
        double fuMaxX = uMaxX;
        double fuMinZ = uMinZ;
        double fuMaxZ = uMaxZ;
        if (renderer.uvRotateBottom == 2) {
            uMinX = icon.func_94214_a(renderer.renderMinZ * 16.0);
            uMinZ = icon.func_94207_b(16.0 - renderer.renderMaxX * 16.0);
            uMaxX = icon.func_94214_a(renderer.renderMaxZ * 16.0);
            uMaxZ = icon.func_94207_b(16.0 - renderer.renderMinX * 16.0);
            fuMinZ = uMinZ;
            fuMaxZ = uMaxZ;
            fuMaxX = uMinX;
            fuMinX = uMaxX;
            uMinZ = uMaxZ;
            uMaxZ = fuMinZ;
        } else if (renderer.uvRotateBottom == 1) {
            uMinX = icon.func_94214_a(16.0 - renderer.renderMaxZ * 16.0);
            uMinZ = icon.func_94207_b(renderer.renderMinX * 16.0);
            uMaxX = icon.func_94214_a(16.0 - renderer.renderMinZ * 16.0);
            uMaxZ = icon.func_94207_b(renderer.renderMaxX * 16.0);
            fuMaxX = uMaxX;
            fuMinX = uMinX;
            uMinX = uMaxX;
            uMaxX = fuMinX;
            fuMinZ = uMaxZ;
            fuMaxZ = uMinZ;
        } else if (renderer.uvRotateBottom == 3) {
            uMinX = icon.func_94214_a(16.0 - renderer.renderMinX * 16.0);
            uMaxX = icon.func_94214_a(16.0 - renderer.renderMaxX * 16.0);
            uMinZ = icon.func_94207_b(16.0 - renderer.renderMinZ * 16.0);
            uMaxZ = icon.func_94207_b(16.0 - renderer.renderMaxZ * 16.0);
            fuMaxX = uMaxX;
            fuMinX = uMinX;
            fuMinZ = uMinZ;
            fuMaxZ = uMaxZ;
        }
        double fx1 = (double)pos.func_177958_n() + renderer.renderMinX;
        double fx2 = (double)pos.func_177958_n() + renderer.renderMaxX;
        double fy = (double)pos.func_177956_o() + renderer.renderMinY;
        double fz1 = (double)pos.func_177952_p() + renderer.renderMinZ;
        double fz2 = (double)pos.func_177952_p() + renderer.renderMaxZ;
        this.tessellator.addVertexWithUV(fx1, fy, fz2, fuMinX, fuMaxZ);
        this.tessellator.addVertexWithUV(fx1, fy, fz1, uMinX, uMinZ);
        this.tessellator.addVertexWithUV(fx2, fy, fz1, fuMaxX, fuMinZ);
        this.tessellator.addVertexWithUV(fx2, fy, fz2, uMaxX, uMaxZ);
    }

    public void renderFaceXPos(CompatibilityRenderer renderer, BlockPos pos, TextureAtlasSprite icon) {
        if (renderer.hasOverrideBlockTexture()) {
            icon = renderer.overrideBlockTexture;
        }
        double uMinZ = icon.func_94214_a(renderer.renderMinZ * 16.0);
        double uMaxZ = icon.func_94214_a(renderer.renderMaxZ * 16.0);
        double uMaxY = icon.func_94207_b(16.0 - renderer.renderMaxY * 16.0);
        double uMinY = icon.func_94207_b(16.0 - renderer.renderMinY * 16.0);
        if (renderer.flipTexture) {
            double tempU = uMinZ;
            uMinZ = uMaxZ;
            uMaxZ = tempU;
        }
        if (renderer.renderMinZ < 0.0 || renderer.renderMaxZ > 1.0) {
            uMinZ = icon.func_94209_e();
            uMaxZ = icon.func_94212_f();
        }
        if (renderer.renderMinY < 0.0 || renderer.renderMaxY > 1.0) {
            uMaxY = icon.func_94206_g();
            uMinY = icon.func_94210_h();
        }
        double fuMinZ = uMinZ;
        double fuMaxZ = uMaxZ;
        double fuMinY = uMinY;
        double fuMaxY = uMaxY;
        if (renderer.uvRotateSouth == 2) {
            uMinZ = icon.func_94214_a(renderer.renderMinY * 16.0);
            uMaxY = icon.func_94207_b(16.0 - renderer.renderMinZ * 16.0);
            uMaxZ = icon.func_94214_a(renderer.renderMaxY * 16.0);
            uMinY = icon.func_94207_b(16.0 - renderer.renderMaxZ * 16.0);
            fuMaxY = uMaxY;
            fuMinY = uMinY;
            fuMaxZ = uMinZ;
            fuMinZ = uMaxZ;
            uMaxY = uMinY;
            uMinY = fuMaxY;
        } else if (renderer.uvRotateSouth == 1) {
            uMinZ = icon.func_94214_a(16.0 - renderer.renderMaxY * 16.0);
            uMaxY = icon.func_94207_b(renderer.renderMaxZ * 16.0);
            uMaxZ = icon.func_94214_a(16.0 - renderer.renderMinY * 16.0);
            uMinY = icon.func_94207_b(renderer.renderMinZ * 16.0);
            fuMaxZ = uMaxZ;
            fuMinZ = uMinZ;
            uMinZ = uMaxZ;
            uMaxZ = fuMinZ;
            fuMaxY = uMinY;
            fuMinY = uMaxY;
        } else if (renderer.uvRotateSouth == 3) {
            uMinZ = icon.func_94214_a(16.0 - renderer.renderMinZ * 16.0);
            uMaxZ = icon.func_94214_a(16.0 - renderer.renderMaxZ * 16.0);
            uMaxY = icon.func_94207_b(renderer.renderMaxY * 16.0);
            uMinY = icon.func_94207_b(renderer.renderMinY * 16.0);
            fuMaxZ = uMaxZ;
            fuMinZ = uMinZ;
            fuMaxY = uMaxY;
            fuMinY = uMinY;
        }
        double fx = (double)pos.func_177958_n() + renderer.renderMaxX;
        double fy1 = (double)pos.func_177956_o() + renderer.renderMinY;
        double fy2 = (double)pos.func_177956_o() + renderer.renderMaxY;
        double fz1 = (double)pos.func_177952_p() + renderer.renderMinZ;
        double fz2 = (double)pos.func_177952_p() + renderer.renderMaxZ;
        this.tessellator.addVertexWithUV(fx, fy1, fz2, fuMinZ, fuMinY);
        this.tessellator.addVertexWithUV(fx, fy1, fz1, uMaxZ, uMinY);
        this.tessellator.addVertexWithUV(fx, fy2, fz1, fuMaxZ, fuMaxY);
        this.tessellator.addVertexWithUV(fx, fy2, fz2, uMinZ, uMaxY);
    }

    public void renderFaceZNeg(CompatibilityRenderer renderer, BlockPos pos, TextureAtlasSprite icon) {
        if (renderer.hasOverrideBlockTexture()) {
            icon = renderer.overrideBlockTexture;
        }
        double uMinX = icon.func_94214_a(renderer.renderMinX * 16.0);
        double uMaxX = icon.func_94214_a(renderer.renderMaxX * 16.0);
        double uMaxY = icon.func_94207_b(16.0 - renderer.renderMaxY * 16.0);
        double uMinY = icon.func_94207_b(16.0 - renderer.renderMinY * 16.0);
        if (renderer.flipTexture) {
            double tempU = uMinX;
            uMinX = uMaxX;
            uMaxX = tempU;
        }
        if (renderer.renderMinX < 0.0 || renderer.renderMaxX > 1.0) {
            uMinX = icon.func_94209_e();
            uMaxX = icon.func_94212_f();
        }
        if (renderer.renderMinY < 0.0 || renderer.renderMaxY > 1.0) {
            uMaxY = icon.func_94206_g();
            uMinY = icon.func_94210_h();
        }
        double fuMaxX = uMaxX;
        double fuMinX = uMinX;
        double fuMaxY = uMaxY;
        double fuMinY = uMinY;
        if (renderer.uvRotateEast == 2) {
            uMinX = icon.func_94214_a(renderer.renderMinY * 16.0);
            uMaxY = icon.func_94207_b(16.0 - renderer.renderMinX * 16.0);
            uMaxX = icon.func_94214_a(renderer.renderMaxY * 16.0);
            uMinY = icon.func_94207_b(16.0 - renderer.renderMaxX * 16.0);
            fuMaxY = uMaxY;
            fuMinY = uMinY;
            fuMaxX = uMinX;
            fuMinX = uMaxX;
            uMaxY = uMinY;
            uMinY = fuMaxY;
        } else if (renderer.uvRotateEast == 1) {
            uMinX = icon.func_94214_a(16.0 - renderer.renderMaxY * 16.0);
            uMaxY = icon.func_94207_b(renderer.renderMaxX * 16.0);
            uMaxX = icon.func_94214_a(16.0 - renderer.renderMinY * 16.0);
            uMinY = icon.func_94207_b(renderer.renderMinX * 16.0);
            fuMaxX = uMaxX;
            fuMinX = uMinX;
            uMinX = uMaxX;
            uMaxX = fuMinX;
            fuMaxY = uMinY;
            fuMinY = uMaxY;
        } else if (renderer.uvRotateEast == 3) {
            uMinX = icon.func_94214_a(16.0 - renderer.renderMinX * 16.0);
            uMaxX = icon.func_94214_a(16.0 - renderer.renderMaxX * 16.0);
            uMaxY = icon.func_94207_b(renderer.renderMaxY * 16.0);
            uMinY = icon.func_94207_b(renderer.renderMinY * 16.0);
            fuMaxX = uMaxX;
            fuMinX = uMinX;
            fuMaxY = uMaxY;
            fuMinY = uMinY;
        }
        double fx1 = (double)pos.func_177958_n() + renderer.renderMinX;
        double fx2 = (double)pos.func_177958_n() + renderer.renderMaxX;
        double fy1 = (double)pos.func_177956_o() + renderer.renderMinY;
        double fy2 = (double)pos.func_177956_o() + renderer.renderMaxY;
        double fz = (double)pos.func_177952_p() + renderer.renderMinZ;
        this.tessellator.addVertexWithUV(fx1, fy2, fz, fuMaxX, fuMaxY);
        this.tessellator.addVertexWithUV(fx2, fy2, fz, uMinX, uMaxY);
        this.tessellator.addVertexWithUV(fx2, fy1, fz, fuMinX, fuMinY);
        this.tessellator.addVertexWithUV(fx1, fy1, fz, uMaxX, uMinY);
    }

    public boolean renderStandardBlock(Block block, BlockPos pos) {
        int l = 0xFFFFFF;
        float f = (float)(l >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(l & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float f3 = (f * 30.0f + f1 * 59.0f + f2 * 11.0f) / 100.0f;
            float f4 = (f * 30.0f + f1 * 70.0f) / 100.0f;
            float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
            f = f3;
            f1 = f4;
            f2 = f5;
        }
        return this.renderStandardBlockWithColorMultiplier(block, pos, f, f1, f2);
    }

    public boolean renderStandardBlockWithColorMultiplier(Block block, BlockPos pos, float red, float green, float blue) {
        float bottomR = bottomShading * red;
        float bottomG = bottomShading * green;
        float bottomB = bottomShading * blue;
        float topR = topShading * red;
        float topG = topShading * green;
        float topB = topShading * blue;
        float northSouthR = northSouthShading * red;
        float northSouthG = northSouthShading * green;
        float northSouthB = northSouthShading * blue;
        float westEastR = westEastShading * red;
        float westEastG = westEastShading * green;
        float westEastB = westEastShading * blue;
        IBlockState state = this.blockAccess.func_180495_p(pos);
        int light = block.func_185484_c(state, this.blockAccess, pos);
        this.tessellator.setBrightness(this.renderMinY > 0.0 ? light : block.func_185484_c(state, this.blockAccess, pos.func_177977_b()));
        this.tessellator.setColorOpaque_F(bottomR, bottomG, bottomB);
        this.renderFaceYNeg(this, pos, this.getBlockIcon(block, this.blockAccess, pos, 0));
        this.tessellator.setBrightness(this.renderMaxY < 1.0 ? light : block.func_185484_c(state, this.blockAccess, pos.func_177984_a()));
        this.tessellator.setColorOpaque_F(topR, topG, topB);
        this.renderFaceYPos(this, pos, this.getBlockIcon(block, this.blockAccess, pos, 1));
        this.tessellator.setBrightness(this.renderMinZ > 0.0 ? light : block.func_185484_c(state, this.blockAccess, pos.func_177978_c()));
        this.tessellator.setColorOpaque_F(northSouthR, northSouthG, northSouthB);
        this.renderFaceZNeg(this, pos, this.getBlockIcon(block, this.blockAccess, pos, 2));
        this.tessellator.setBrightness(this.renderMaxZ < 1.0 ? light : block.func_185484_c(state, this.blockAccess, pos.func_177968_d()));
        this.tessellator.setColorOpaque_F(northSouthR, northSouthG, northSouthB);
        this.renderFaceZPos(this, pos, this.getBlockIcon(block, this.blockAccess, pos, 3));
        this.tessellator.setBrightness(this.renderMinX > 0.0 ? light : block.func_185484_c(state, this.blockAccess, pos.func_177976_e()));
        this.tessellator.setColorOpaque_F(westEastR, westEastG, westEastB);
        this.renderFaceXNeg(this, pos, this.getBlockIcon(block, this.blockAccess, pos, 4));
        this.tessellator.setBrightness(this.renderMaxX < 1.0 ? light : block.func_185484_c(state, this.blockAccess, pos.func_177974_f()));
        this.tessellator.setColorOpaque_F(westEastR, westEastG, westEastB);
        this.renderFaceXPos(this, pos, this.getBlockIcon(block, this.blockAccess, pos, 5));
        return true;
    }

    public TextureAtlasSprite getBlockIcon(Block block, IBlockAccess paramBlockAccess, BlockPos pos, int side) {
        IBlockState state = paramBlockAccess.func_180495_p(pos);
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
        if (sprite != null) {
            return sprite;
        }
        return Minecraft.func_71410_x().func_147117_R().func_174944_f();
    }
}

