/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.util;

import com.oblivioussp.spartanweaponry.util.AlignmentHelper;
import com.oblivioussp.spartanweaponry.util.LogHelper;
import com.oblivioussp.spartanweaponry.util.Reference;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public static Configuration config;
    public static float damageMaterialCopper;
    public static float damageMaterialTin;
    public static float damageMaterialBronze;
    public static float damageMaterialSteel;
    public static float damageMaterialSilver;
    public static float damageMaterialInvar;
    public static float damageMaterialPlatinum;
    public static float damageMaterialElectrum;
    public static float damageMaterialNickel;
    public static float damageMaterialLead;
    public static int durabilityMaterialCopper;
    public static int durabilityMaterialTin;
    public static int durabilityMaterialBronze;
    public static int durabilityMaterialSteel;
    public static int durabilityMaterialSilver;
    public static int durabilityMaterialInvar;
    public static int durabilityMaterialPlatinum;
    public static int durabilityMaterialElectrum;
    public static int durabilityMaterialNickel;
    public static int durabilityMaterialLead;
    public static boolean disableMaterialCopper;
    public static boolean disableMaterialTin;
    public static boolean disableMaterialBronze;
    public static boolean disableMaterialSteel;
    public static boolean disableMaterialSilver;
    public static boolean disableMaterialInvar;
    public static boolean disableMaterialPlatinum;
    public static boolean disableMaterialElectrum;
    public static boolean disableMaterialNickel;
    public static boolean disableMaterialLead;
    public static float speedDagger;
    public static boolean disableDagger;
    public static float damageBaseDagger;
    public static float damageMultiplierDagger;
    public static float speedParryingDagger;
    public static boolean disableParryingDagger;
    public static float damageBaseParryingDagger;
    public static float damageMultiplierParryingDagger;
    public static float speedLongsword;
    public static boolean disableLongsword;
    public static float damageBaseLongsword;
    public static float damageMultiplierLongsword;
    public static float speedKatana;
    public static boolean disableKatana;
    public static float damageBaseKatana;
    public static float damageMultiplierKatana;
    public static float speedSaber;
    public static boolean disableSaber;
    public static float damageBaseSaber;
    public static float damageMultiplierSaber;
    public static float speedRapier;
    public static boolean disableRapier;
    public static float damageBaseRapier;
    public static float damageMultiplierRapier;
    public static float speedGreatsword;
    public static boolean disableGreatsword;
    public static float damageBaseGreatsword;
    public static float damageMultiplierGreatsword;
    public static float speedCaestus;
    public static boolean disableCaestus;
    public static float damageBaseCaestus;
    public static float damageMultiplierCaestus;
    public static float speedClub;
    public static boolean disableClub;
    public static float damageBaseClub;
    public static float damageMultiplierClub;
    public static float speedHammer;
    public static boolean disableHammer;
    public static float damageBaseHammer;
    public static float damageMultiplierHammer;
    public static float speedWarhammer;
    public static boolean disableWarhammer;
    public static float damageBaseWarhammer;
    public static float damageMultiplierWarhammer;
    public static float speedSpear;
    public static boolean disableSpear;
    public static float damageBaseSpear;
    public static float damageMultiplierSpear;
    public static float speedHalberd;
    public static boolean disableHalberd;
    public static float damageBaseHalberd;
    public static float damageMultiplierHalberd;
    public static float speedPike;
    public static boolean disablePike;
    public static float damageBasePike;
    public static float damageMultiplierPike;
    public static float speedLance;
    public static boolean disableLance;
    public static float damageBaseLance;
    public static float damageMultiplierLance;
    public static boolean disableLongbow;
    public static float multiplierLongbow;
    public static boolean woodenLongbowOnly;
    public static boolean disableCrossbow;
    public static float crossbowInaccuracyMax;
    public static int crossbowTicksToLoad;
    public static int crossbowTicksCooldown;
    public static float boltBaseDamage;
    public static float boltDiamondBaseDamage;
    public static boolean woodenCrossbowOnly;
    public static boolean disableThrowingKnife;
    public static float meleeSpeedThrowingKnife;
    public static float damageBaseThrowingKnife;
    public static float damageMultiplierThrowingKnife;
    public static boolean disableThrowingAxe;
    public static float meleeSpeedThrowingAxe;
    public static float damageBaseThrowingAxe;
    public static float damageMultiplierThrowingAxe;
    public static boolean disableJavelin;
    public static float meleeSpeedJavelin;
    public static float damageBaseJavelin;
    public static float damageMultiplierJavelin;
    public static boolean disableBoomerang;
    public static boolean woodenBoomerangOnly;
    public static float damageBaseBoomerang;
    public static float damageMultiplierBoomerang;
    public static boolean disableBattleaxe;
    public static float damageBaseBattleaxe;
    public static float damageMultiplierBattleaxe;
    public static boolean disableMace;
    public static float damageBaseMace;
    public static float damageMultiplierMace;
    public static boolean disableGlaive;
    public static float damageBaseGlaive;
    public static float damageMultiplierGlaive;
    public static boolean disableQuarterstaff;
    public static float damageBaseQuarterstaff;
    public static float damageMultiplierQuarterstaff;
    public static boolean disableNewArrows;
    public static boolean disableDiamondArrowsAndBolts;
    public static boolean disableQuivers;
    public static String[] quiverBowBlacklist;
    public static float baseDamageArrowWood;
    public static float baseDamageArrowIron;
    public static float baseDamageArrowDiamond;
    public static boolean disableExplosives;
    public static boolean enableTerrainDamage;
    public static int quickStrikeHurtResistTicks;
    public static boolean enableExperimentalWeapons;
    public static boolean enableModdedMaterialWeapons;
    public static boolean forceDisableUncraftableTooltips;
    public static String quiverHudAlignment;
    public static int quiverHudOffsetX;
    public static int quiverHudOffsetY;
    public static boolean disableNewCrosshairCrossbow;
    public static boolean disableNewCrosshairThrowingWeapon;
    public static boolean forceCompatibilityCrosshairs;
    public static final String categoryMaterials = "materials";
    public static final String categoryDagger = "dagger";
    public static final String categoryParryingDagger = "parrying_dagger";
    public static final String categoryLongsword = "longsword";
    public static final String categoryKatana = "katana";
    public static final String categorySaber = "saber";
    public static final String categoryRapier = "rapier";
    public static final String categoryGreatsword = "greatsword";
    public static final String categoryCaestus = "caestus";
    public static final String categoryClub = "club";
    public static final String categoryHammer = "hammer";
    public static final String categoryWarhammer = "warhammer";
    public static final String categorySpear = "spear";
    public static final String categoryHalberd = "halberd";
    public static final String categoryPike = "pike";
    public static final String categoryLance = "lance";
    public static final String categoryLongbow = "longbow";
    public static final String categoryCrossbow = "crossbow";
    public static final String categoryThrowingKnife = "throwing_knife";
    public static final String categoryThrowingAxe = "throwing_axe";
    public static final String categoryJavelin = "javelin";
    public static final String categoryBoomerang = "boomerang";
    public static final String categoryBattleaxe = "battleaxe";
    public static final String categoryMace = "mace";
    public static final String categoryGlaive = "glaive";
    public static final String categoryQuarterstaff = "quarterstaff";
    public static final String categoryArrows = "arrows";
    public static final String categoryExplosives = "explosives";
    public static final String categoryWeaponProperties = "weapon_properties";
    public static final String[] categories;

    public static void init(File configDirectory) {
        File configFile = new File(configDirectory, "spartanweaponry".toLowerCase() + ".cfg");
        if (config == null) {
            config = new Configuration(configFile, "2.0");
            LogHelper.info("Defined config version: " + config.getDefinedConfigVersion() + " - Loaded config version: " + config.getLoadedConfigVersion());
            if (!config.getDefinedConfigVersion().equalsIgnoreCase(config.getLoadedConfigVersion())) {
                String oldVersion = config.getLoadedConfigVersion() == null ? "1.0" : config.getLoadedConfigVersion();
                LogHelper.warn("The loaded config file is from an old version of this mod (beta-1.2.x or older), and is no longer valid! This config will be moved to \"config/backup/spartanweaponry_" + oldVersion + ".cfg\" and a new one will be generated!");
                File backupConfigDir = new File(configDirectory, "backup");
                File backupConfig = new File(backupConfigDir, "spartanweaponry".toLowerCase() + "_" + oldVersion + ".cfg");
                backupConfigDir.mkdirs();
                config.getConfigFile().renameTo(backupConfig);
                config = new Configuration(configFile, "2.0");
            }
            ConfigHandler.loadConfig();
            for (String category : categories) {
                ConfigHandler.setCategoryLanguageKey(category);
                if (category == "general") continue;
                if (category == "client") continue;
                config.setCategoryRequiresMcRestart(category, true);
            }
        }
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent ev) {
        if (ev.getModID().equalsIgnoreCase("spartanweaponry")) {
            ConfigHandler.loadConfig();
        }
    }

    private static void loadConfig() {
        damageMaterialCopper = ConfigHandler.getFloat("damageBaseCopper", categoryMaterials, 1.5f, 0.0f, 100.0f, "Base material damage for Copper weapons");
        damageMaterialTin = ConfigHandler.getFloat("damageBaseTin", categoryMaterials, 1.75f, 0.0f, 100.0f, "Base material damage for Tin weapons");
        damageMaterialBronze = ConfigHandler.getFloat("damageBaseBronze", categoryMaterials, 2.0f, 0.0f, 100.0f, "Base material damage for Bronze weapons");
        damageMaterialSteel = ConfigHandler.getFloat("damageBaseSteel", categoryMaterials, 2.5f, 0.0f, 100.0f, "Base material damage for Steel weapons");
        damageMaterialSilver = ConfigHandler.getFloat("damageBaseSilver", categoryMaterials, 1.5f, 0.0f, 100.0f, "Base material damage for Silver weapons");
        damageMaterialInvar = ConfigHandler.getFloat("damageBaseInvar", categoryMaterials, 2.2f, 0.0f, 100.0f, "Base material damage for Invar weapons");
        damageMaterialPlatinum = ConfigHandler.getFloat("damageBasePlatinum", categoryMaterials, 3.5f, 0.0f, 100.0f, "Base material damage for Platinum weapons");
        damageMaterialElectrum = ConfigHandler.getFloat("damageBaseElectrum", categoryMaterials, 2.0f, 0.0f, 100.0f, "Base material damage for Electrum weapons");
        damageMaterialNickel = ConfigHandler.getFloat("damageBaseNickel", categoryMaterials, 2.0f, 0.0f, 100.0f, "Base material damage for Nickel weapons");
        damageMaterialLead = ConfigHandler.getFloat("damageBaseLead", categoryMaterials, 2.0f, 0.0f, 100.0f, "Base material damage for Lead weapons");
        durabilityMaterialCopper = ConfigHandler.getInt("durabilityBaseCopper", categoryMaterials, 200, 1, 1000000, "Base durability for Copper weapons");
        durabilityMaterialTin = ConfigHandler.getInt("durabilityBaseTin", categoryMaterials, 180, 1, 1000000, "Base durability for Tin weapons");
        durabilityMaterialBronze = ConfigHandler.getInt("durabilityBaseBronze", categoryMaterials, 320, 1, 1000000, "Base durability for Bronze weapons");
        durabilityMaterialSteel = ConfigHandler.getInt("durabilityBaseSteel", categoryMaterials, 480, 1, 1000000, "Base durability for Steel weapons");
        durabilityMaterialSilver = ConfigHandler.getInt("durabilityBaseSilver", categoryMaterials, 48, 1, 1000000, "Base durability for Silver weapons");
        durabilityMaterialInvar = ConfigHandler.getInt("durabilityBaseInvar", categoryMaterials, 440, 1, 1000000, "Base durability for Invar weapons");
        durabilityMaterialPlatinum = ConfigHandler.getInt("durabilityBasePlatinum", categoryMaterials, 1024, 1, 1000000, "Base durability for Platinum weapons");
        durabilityMaterialElectrum = ConfigHandler.getInt("durabilityBaseElectrum", categoryMaterials, 180, 1, 1000000, "Base durability for Electrum weapons");
        durabilityMaterialNickel = ConfigHandler.getInt("durabilityBaseNickel", categoryMaterials, 200, 1, 1000000, "Base durability for Nickel weapons");
        durabilityMaterialLead = ConfigHandler.getInt("durabilityBaseLead", categoryMaterials, 240, 1, 1000000, "Base durability for Lead weapons");
        disableMaterialCopper = ConfigHandler.getBoolean("disableCopper", categoryMaterials, false, "Disables all Copper-based weapons");
        disableMaterialTin = ConfigHandler.getBoolean("disableTin", categoryMaterials, false, "Disables all Tin-based weapons");
        disableMaterialBronze = ConfigHandler.getBoolean("disableBronze", categoryMaterials, false, "Disables all Bronze-based weapons");
        disableMaterialSteel = ConfigHandler.getBoolean("disableSteel", categoryMaterials, false, "Disables all Steel-based weapons");
        disableMaterialSilver = ConfigHandler.getBoolean("disableSilver", categoryMaterials, false, "Disables all Silver-based weapons");
        disableMaterialInvar = ConfigHandler.getBoolean("disableInvar", categoryMaterials, false, "Disables all Invar-based weapons");
        disableMaterialPlatinum = ConfigHandler.getBoolean("disablePlatinum", categoryMaterials, false, "Disables all Platinum-based weapons");
        disableMaterialElectrum = ConfigHandler.getBoolean("disableElectrum", categoryMaterials, false, "Disables all Electrum-based weapons");
        disableMaterialNickel = ConfigHandler.getBoolean("disableNickel", categoryMaterials, false, "Disables all Nickel-based weapons");
        disableMaterialLead = ConfigHandler.getBoolean("disableLead", categoryMaterials, false, "Disables all Lead-based weapons");
        disableDagger = ConfigHandler.getBoolean("disableWeapon", categoryDagger, false, "Disables all weapons of this type in this mod");
        damageMultiplierDagger = ConfigHandler.getFloat("damageMultiplier", categoryDagger, 0.5f, 0.1f, 100.0f, "Damage Multiplier. Final damage of weapons are calculated with the formula: ([WeaponMultiplier] * [BaseMaterialDamage]) + [WeaponBaseDamage]");
        damageBaseDagger = ConfigHandler.getFloat("damageBase", categoryDagger, 2.5f, 0.1f, 100.0f, "Base Damage. Will be the same damage as the Wooden version of this weapon");
        disableParryingDagger = ConfigHandler.getBoolean("disableWeapon", categoryParryingDagger, false, "Disables all weapons of this type in this mod");
        damageMultiplierParryingDagger = ConfigHandler.getFloat("damageMultiplier", categoryParryingDagger, 0.5f, 0.1f, 100.0f, "Damage Multiplier. Final damage of weapons are calculated with the formula: ([WeaponMultiplier] * [BaseMaterialDamage]) + [WeaponBaseDamage]");
        damageBaseParryingDagger = ConfigHandler.getFloat("damageBase", categoryParryingDagger, 2.0f, 0.1f, 100.0f, "Base Damage. Will be the same damage as the Wooden version of this weapon");
        disableLongsword = ConfigHandler.getBoolean("disableWeapon", categoryLongsword, false, "Disables all weapons of this type in this mod");
        damageMultiplierLongsword = ConfigHandler.getFloat("damageMultiplier", categoryLongsword, 1.5f, 0.1f, 100.0f, "Damage Multiplier. Final damage of weapons are calculated with the formula: ([WeaponMultiplier] * [BaseMaterialDamage]) + [WeaponBaseDamage]");
        damageBaseLongsword = ConfigHandler.getFloat("damageBase", categoryLongsword, 4.5f, 0.1f, 100.0f, "Base Damage. Will be the same damage as the Wooden version of this weapon");
        disableKatana = ConfigHandler.getBoolean("disableWeapon", categoryKatana, false, "Disables all weapons of this type in this mod");
        damageMultiplierKatana = ConfigHandler.getFloat("damageMultiplier", categoryKatana, 0.5f, 0.1f, 100.0f, "Damage Multiplier. Final damage of weapons are calculated with the formula: ([WeaponMultiplier] * [BaseMaterialDamage]) + [WeaponBaseDamage]");
        damageBaseKatana = ConfigHandler.getFloat("damageBase", categoryKatana, 3.5f, 0.1f, 100.0f, "Base Damage. Will be the same damage as the Wooden version of this weapon");
        disableSaber = ConfigHandler.getBoolean("disableWeapon", categorySaber, false, "Disables all weapons of this type in this mod");
        damageMultiplierSaber = ConfigHandler.getFloat("damageMultiplier", categorySaber, 0.5f, 0.1f, 100.0f, "Damage Multiplier. Final damage of weapons are calculated with the formula: ([WeaponMultiplier] * [BaseMaterialDamage]) + [WeaponBaseDamage]");
        damageBaseSaber = ConfigHandler.getFloat("damageBase", categorySaber, 4.5f, 0.1f, 100.0f, "Base Damage. Will be the same damage as the Wooden version of this weapon");
        disableRapier = ConfigHandler.getBoolean("disableWeapon", categoryRapier, false, "Disables all weapons of this type in this mod");
        damageMultiplierRapier = ConfigHandler.getFloat("damageMultiplier", categoryRapier, 0.5f, 0.1f, 100.0f, "Damage Multiplier. Final damage of weapons are calculated with the formula: ([WeaponMultiplier] * [BaseMaterialDamage]) + [WeaponBaseDamage]");
        damageBaseRapier = ConfigHandler.getFloat("damageBase", categoryRapier, 2.5f, 0.1f, 100.0f, "Base Damage. Will be the same damage as the Wooden version of this weapon");
        disableGreatsword = ConfigHandler.getBoolean("disableWeapon", categoryGreatsword, false, "Disables all weapons of this type in this mod");
        damageMultiplierGreatsword = ConfigHandler.getFloat("damageMultiplier", categoryGreatsword, 2.0f, 0.1f, 100.0f, "Damage Multiplier. Final damage of weapons are calculated with the formula: ([WeaponMultiplier] * [BaseMaterialDamage]) + [WeaponBaseDamage]");
        damageBaseGreatsword = ConfigHandler.getFloat("damageBase", categoryGreatsword, 6.0f, 0.1f, 100.0f, "Base Damage. Will be the same damage as the Wooden version of this weapon");
        disableCaestus = ConfigHandler.getBoolean("disableWeapon", categoryCaestus, false, "Disables the Caestus and Studded Caestus");
        damageMultiplierCaestus = ConfigHandler.getFloat("damageMultiplier", categoryCaestus, 0.5f, 0.1f, 100.0f, "Damage Multiplier. Final damage of weapons are calculated with the formula: ([WeaponMultiplier] * [BaseMaterialDamage]) + [WeaponBaseDamage]");
        damageBaseCaestus = ConfigHandler.getFloat("damageBase", categoryCaestus, 2.0f, 0.1f, 100.0f, "Base Damage. Will be the same damage as the Wooden version of this weapon");
        disableClub = ConfigHandler.getBoolean("disableWeapon", categoryClub, false, "Disables the Club and Studded Club");
        damageMultiplierClub = ConfigHandler.getFloat("damageMultiplier", categoryClub, 1.0f, 0.1f, 100.0f, "Damage Multiplier. Final damage of weapons are calculated with the formula: ([WeaponMultiplier] * [BaseMaterialDamage]) + [WeaponBaseDamage]");
        damageBaseClub = ConfigHandler.getFloat("damageBase", categoryClub, 4.0f, 0.1f, 100.0f, "Base Damage. Will be the same damage as the Wooden version of this weapon");
        disableHammer = ConfigHandler.getBoolean("disableWeapon", categoryHammer, false, "Disables all weapons of this type in this mod");
        damageMultiplierHammer = ConfigHandler.getFloat("damageMultiplier", categoryHammer, 1.0f, 0.1f, 100.0f, "Damage Multiplier. Final damage of weapons are calculated with the formula: ([WeaponMultiplier] * [BaseMaterialDamage]) + [WeaponBaseDamage]");
        damageBaseHammer = ConfigHandler.getFloat("damageBase", categoryHammer, 6.0f, 0.1f, 100.0f, "Base Damage. Will be the same damage as the Wooden version of this weapon");
        disableWarhammer = ConfigHandler.getBoolean("disableWeapon", categoryWarhammer, false, "Disables all weapons of this type in this mod");
        damageMultiplierWarhammer = ConfigHandler.getFloat("damageMultiplier", categoryWarhammer, 1.0f, 0.1f, 100.0f, "Damage Multiplier. Final damage of weapons are calculated with the formula: ([WeaponMultiplier] * [BaseMaterialDamage]) + [WeaponBaseDamage]");
        damageBaseWarhammer = ConfigHandler.getFloat("damageBase", categoryWarhammer, 4.0f, 0.1f, 100.0f, "Base Damage. Will be the same damage as the Wooden version of this weapon");
        disableSpear = ConfigHandler.getBoolean("disableWeapon", categorySpear, false, "Disables all weapons of this type in this mod");
        damageMultiplierSpear = ConfigHandler.getFloat("damageMultiplier", categorySpear, 0.5f, 0.1f, 100.0f, "Damage Multiplier. Final damage of weapons are calculated with the formula: ([WeaponMultiplier] * [BaseMaterialDamage]) + [WeaponBaseDamage]");
        damageBaseSpear = ConfigHandler.getFloat("damageBase", categorySpear, 4.5f, 0.1f, 100.0f, "Base Damage. Will be the same damage as the Wooden version of this weapon");
        disableHalberd = ConfigHandler.getBoolean("disableWeapon", categoryHalberd, false, "Disables all weapons of this type in this mod");
        damageMultiplierHalberd = ConfigHandler.getFloat("damageMultiplier", categoryHalberd, 2.5f, 0.1f, 100.0f, "Damage Multiplier. Final damage of weapons are calculated with the formula: ([WeaponMultiplier] * [BaseMaterialDamage]) + [WeaponBaseDamage]");
        damageBaseHalberd = ConfigHandler.getFloat("damageBase", categoryHalberd, 6.5f, 0.1f, 100.0f, "Base Damage. Will be the same damage as the Wooden version of this weapon");
        disablePike = ConfigHandler.getBoolean("disableWeapon", categoryPike, false, "Disables all weapons of this type in this mod");
        damageMultiplierPike = ConfigHandler.getFloat("damageMultiplier", categoryPike, 0.5f, 0.1f, 100.0f, "Damage Multiplier. Final damage of weapons are calculated with the formula: ([WeaponMultiplier] * [BaseMaterialDamage]) + [WeaponBaseDamage]");
        damageBasePike = ConfigHandler.getFloat("damageBase", categoryPike, 4.0f, 0.1f, 100.0f, "Base Damage. Will be the same damage as the Wooden version of this weapon");
        disableLance = ConfigHandler.getBoolean("disableWeapon", categoryLance, false, "Disables all weapons of this type in this mod");
        damageMultiplierLance = ConfigHandler.getFloat("damageMultiplier", categoryLance, 1.0f, 0.1f, 100.0f, "Damage Multiplier. Final damage of weapons are calculated with the formula: ([WeaponMultiplier] * [BaseMaterialDamage]) + [WeaponBaseDamage]");
        damageBaseLance = ConfigHandler.getFloat("damageBase", categoryLance, 4.0f, 0.1f, 100.0f, "Base Damage. Will be the same damage as the Wooden version of this weapon");
        disableLongbow = ConfigHandler.getBoolean("disableWeapon", categoryLongbow, false, "Disables all weapons of this type in this mod");
        woodenLongbowOnly = ConfigHandler.getBoolean("woodenLongbowOnly", categoryLongbow, false, "Disables all Longbows except the Wooden one in this mod.");
        disableCrossbow = ConfigHandler.getBoolean("disableWeapon", categoryCrossbow, false, "Disables all weapons of this type in this mod");
        boltBaseDamage = ConfigHandler.getFloat("boltDamage", categoryCrossbow, 4.0f, 1.0f, 100.0f, "Base damage of a standard Crossbow Bolt.");
        boltDiamondBaseDamage = ConfigHandler.getFloat("boltDiamondDamage", categoryCrossbow, 5.0f, 1.0f, 100.0f, "Base damage of a Diamond Crossbow Bolt");
        woodenCrossbowOnly = ConfigHandler.getBoolean("woodenCrossbowOnly", categoryCrossbow, false, "Disables all Crossbows except the Wooden one in this mod.");
        disableThrowingKnife = ConfigHandler.getBoolean("disableWeapon", categoryThrowingKnife, false, "Disables all weapons of this type in this mod");
        damageMultiplierThrowingKnife = ConfigHandler.getFloat("damageMultiplier", categoryThrowingKnife, 0.5f, 0.1f, 100.0f, "Damage Multiplier. Final damage of weapons are calculated with the formula: ([WeaponMultiplier] * [BaseMaterialDamage]) + [WeaponBaseDamage]");
        damageBaseThrowingKnife = ConfigHandler.getFloat("damageBase", categoryThrowingKnife, 1.5f, 0.1f, 100.0f, "Base Damage. Will be the same damage as the Wooden version of this weapon");
        disableThrowingAxe = ConfigHandler.getBoolean("disableWeapon", categoryThrowingAxe, false, "Disables all weapons of this type in this mod");
        damageMultiplierThrowingAxe = ConfigHandler.getFloat("damageMultiplier", categoryThrowingAxe, 1.0f, 0.1f, 100.0f, "Damage Multiplier. Final damage of weapons are calculated with the formula: ([WeaponMultiplier] * [BaseMaterialDamage]) + [WeaponBaseDamage]");
        damageBaseThrowingAxe = ConfigHandler.getFloat("damageBase", categoryThrowingAxe, 2.0f, 0.1f, 100.0f, "Base Damage. Will be the same damage as the Wooden version of this weapon");
        disableJavelin = ConfigHandler.getBoolean("disableWeapon", categoryJavelin, false, "Disables all weapons of this type in this mod");
        damageMultiplierJavelin = ConfigHandler.getFloat("damageMultiplier", categoryJavelin, 0.5f, 0.1f, 100.0f, "Damage Multiplier. Final damage of weapons are calculated with the formula: ([WeaponMultiplier] * [BaseMaterialDamage]) + [WeaponBaseDamage]");
        damageBaseJavelin = ConfigHandler.getFloat("damageBase", categoryJavelin, 1.5f, 0.1f, 100.0f, "Base Damage. Will be the same damage as the Wooden version of this weapon");
        disableBoomerang = ConfigHandler.getBoolean("disableWeapon", categoryBoomerang, false, "Disables all weapons of this type in this mod");
        woodenBoomerangOnly = ConfigHandler.getBoolean("woodenBoomerangOnly", categoryBoomerang, false, "Disables all Boomerangs except the Wooden one in this mod.");
        damageMultiplierBoomerang = ConfigHandler.getFloat("damageMultiplier", categoryBoomerang, 1.0f, 0.1f, 100.0f, "Damage Multiplier. Final damage of weapons are calculated with the formula: ([WeaponMultiplier] * [BaseMaterialDamage]) + [WeaponBaseDamage]");
        damageBaseBoomerang = ConfigHandler.getFloat("damageBase", categoryBoomerang, 4.0f, 0.1f, 100.0f, "Base Damage. Will be the same damage as the Wooden version of this weapon");
        disableBattleaxe = ConfigHandler.getBoolean("disableWeapon", categoryBattleaxe, false, "Disables all weapons of this type in this mod");
        damageMultiplierBattleaxe = ConfigHandler.getFloat("damageMultiplier", categoryBattleaxe, 2.0f, 0.1f, 100.0f, "Damage Multiplier. Final damage of weapons are calculated with the formula: ([WeaponMultiplier] * [BaseMaterialDamage]) + [WeaponBaseDamage]");
        damageBaseBattleaxe = ConfigHandler.getFloat("damageBase", categoryBattleaxe, 5.0f, 0.1f, 100.0f, "Base Damage. Will be the same damage as the Wooden version of this weapon");
        disableMace = ConfigHandler.getBoolean("disableWeapon", categoryMace, false, "Disables all weapons of this type in this mod");
        damageMultiplierMace = ConfigHandler.getFloat("damageMultiplier", categoryMace, 1.0f, 0.1f, 100.0f, "Damage Multiplier. Final damage of weapons are calculated with the formula: ([WeaponMultiplier] * [BaseMaterialDamage]) + [WeaponBaseDamage]");
        damageBaseMace = ConfigHandler.getFloat("damageBase", categoryMace, 4.0f, 0.1f, 100.0f, "Base Damage. Will be the same damage as the Wooden version of this weapon");
        disableGlaive = ConfigHandler.getBoolean("disableWeapon", categoryGlaive, false, "Disables all weapons of this type in this mod");
        damageMultiplierGlaive = ConfigHandler.getFloat("damageMultiplier", categoryGlaive, 1.0f, 0.1f, 100.0f, "Damage Multiplier. Final damage of weapons are calculated with the formula: ([WeaponMultiplier] * [BaseMaterialDamage]) + [WeaponBaseDamage]");
        damageBaseGlaive = ConfigHandler.getFloat("damageBase", categoryGlaive, 4.0f, 0.1f, 100.0f, "Base Damage. Will be the same damage as the Wooden version of this weapon");
        disableQuarterstaff = ConfigHandler.getBoolean("disableWeapon", categoryQuarterstaff, false, "Disables all weapons of this type in this mod");
        damageMultiplierQuarterstaff = ConfigHandler.getFloat("damageMultiplier", categoryQuarterstaff, 1.0f, 0.1f, 100.0f, "Damage Multiplier. Final damage of weapons are calculated with the formula: ([WeaponMultiplier] * [BaseMaterialDamage]) + [WeaponBaseDamage]");
        damageBaseQuarterstaff = ConfigHandler.getFloat("damageBase", categoryQuarterstaff, 1.5f, 0.1f, 100.0f, "Base Damage. Will be the same damage as the Wooden version of this weapon");
        disableNewArrows = ConfigHandler.getBoolean("disableNewArrows", categoryArrows, false, "Disables all new Arrows in this mod");
        disableDiamondArrowsAndBolts = ConfigHandler.getBoolean("disableDiamondArrowsAndBolts", categoryArrows, false, "Disables Diamond Arrows and Bolts in this mod");
        disableQuivers = ConfigHandler.getBoolean("disableQuivers", categoryArrows, false, "Disables all variants of the Arrow Quiver and the Bolt Quiver in this mod");
        quiverBowBlacklist = ConfigHandler.getStringList("quiverBowBlacklist", categoryArrows, (String[])Reference.DefaultQuiverArrowBlacklist.clone(), "Bows in this blacklist will not get Arrows pulled out of the Arrow Quiver. Use the ID of the bow to add to this. e.g. \"minecraft:bow\"");
        baseDamageArrowWood = ConfigHandler.getFloat("baseDamageArrowWood", categoryArrows, 0.2f, 0.1f, 100.0f, "Base Damage for Wooden Arrows");
        baseDamageArrowIron = ConfigHandler.getFloat("baseDamageArrowIron", categoryArrows, 3.0f, 0.1f, 100.0f, "Base Damage for Iron Arrows");
        baseDamageArrowDiamond = ConfigHandler.getFloat("baseDamageArrowDiamond", categoryArrows, 3.5f, 0.1f, 100.0f, "Base Damage for Diamond Arrows");
        disableExplosives = ConfigHandler.getBoolean("disableExplosives", categoryExplosives, false, "Disables all Explosives in this mod");
        enableTerrainDamage = ConfigHandler.getBoolean("enableTerrainDamage", categoryExplosives, true, "Enables terrain damage for explosives in this mod such as Dynamite and Explosive Arrows. Respects the 'mobGriefing' gamerule.");
        quickStrikeHurtResistTicks = ConfigHandler.getInt("quickStrikeHurtResistTicks", categoryWeaponProperties, 14, 1, 20, "Tweaks the hurt resistance ticks for weapons that use the \"Quick Strike\" Weapon Property");
        enableExperimentalWeapons = ConfigHandler.getBoolean("enableExperimentalWeapons", "general", false, "Enables experimental weapons, such as the Parrying Dagger");
        enableModdedMaterialWeapons = ConfigHandler.getBoolean("enableModdedMaterialWeapons", "general", true, "Enables weapons made from modded materials. Setting this to false will disable registration of said weapons, meaning only vanilla weapons will be available.");
        forceDisableUncraftableTooltips = ConfigHandler.getBoolean("forceDisableUncraftableTooltips", "general", false, "Setting to true will disable all uncraftable weapon tooltips. Useful for modpack makers, or for those particular mods which recipes work, but the tooltips are inaccurate.");
        quiverHudAlignment = ConfigHandler.getStringFromFixedValues("quiverHudAlignment", "client", AlignmentHelper.validAlignmentValues.get(AlignmentHelper.Alignment.BOTTOM_CENTER.ordinal()), "Sets where the Quiver HUD Element should be aligned", (String[])AlignmentHelper.validAlignmentValues.toArray());
        quiverHudOffsetX = ConfigHandler.getInt("quiverHudOffsetX", "client", -130, -400, 400, "Sets where on the X-axis the Quiver HUD element should be off-set from it's alignment point.");
        quiverHudOffsetY = ConfigHandler.getInt("quiverHudOffsetY", "client", 59, -400, 400, "Sets where on the Y-axis the Quiver HUD element should be off-set from it's alignment point.");
        disableNewCrosshairCrossbow = ConfigHandler.getBoolean("disableNewCrosshairCrossbow", "client", false, "Set to true to disable a Crosshair for the Crossbow which visually shows inaccuracy, using the default Crosshair instead; false otherwise");
        disableNewCrosshairThrowingWeapon = ConfigHandler.getBoolean("disableNewCrosshairThrowingWeapon", "client", false, "set to true to disable a Crosshair for Throwing Weapons which show the charge for them, using the default Crosshair instead; false otherwise");
        forceCompatibilityCrosshairs = ConfigHandler.getBoolean("forceCompatibilityCrosshairs", "client", false, "Set to force compatibility crosshairs for Crosshairs and Throwing Weapons. This won't work if the new crosshairs are disabled.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void setCategoryLanguageKey(String category) {
        config.getCategory(category).setLanguageKey(String.format("config.%s:%s.%s", "spartanweaponry", "category", category));
    }

    public static float getFloat(String name, String category, float defaultValue, float minValue, float maxValue, String comment) {
        return config.getFloat(name, category, defaultValue, minValue, maxValue, comment, String.format("config.%s:%s", "spartanweaponry", name));
    }

    public static int getInt(String name, String category, int defaultValue, int minValue, int maxValue, String comment) {
        return config.getInt(name, category, defaultValue, minValue, maxValue, comment, String.format("config.%s:%s", "spartanweaponry", name));
    }

    public static boolean getBoolean(String name, String category, boolean defaultValue, String comment) {
        return config.getBoolean(name, category, defaultValue, comment, String.format("config.%s:%s", "spartanweaponry", name));
    }

    public static String getStringFromFixedValues(String name, String category, String defaultValue, String comment, String[] validValues) {
        return config.getString(name, category, defaultValue, comment, validValues, String.format("config.%s:%s", "spartanweaponry", name));
    }

    public static String[] getStringList(String name, String category, String[] defaultValue, String comment) {
        return config.getStringList(name, category, defaultValue, comment, null, String.format("config.%s:%s", "spartanweaponry", name));
    }

    static {
        damageMaterialCopper = 1.5f;
        damageMaterialTin = 1.75f;
        damageMaterialBronze = 2.0f;
        damageMaterialSteel = 2.5f;
        damageMaterialSilver = 1.5f;
        damageMaterialInvar = 2.2f;
        damageMaterialPlatinum = 3.5f;
        damageMaterialElectrum = 2.0f;
        damageMaterialNickel = 2.0f;
        damageMaterialLead = 2.0f;
        durabilityMaterialCopper = 200;
        durabilityMaterialTin = 180;
        durabilityMaterialBronze = 320;
        durabilityMaterialSteel = 480;
        durabilityMaterialSilver = 48;
        durabilityMaterialInvar = 440;
        durabilityMaterialPlatinum = 1024;
        durabilityMaterialElectrum = 180;
        durabilityMaterialNickel = 200;
        durabilityMaterialLead = 240;
        disableMaterialCopper = false;
        disableMaterialTin = false;
        disableMaterialBronze = false;
        disableMaterialSteel = false;
        disableMaterialSilver = false;
        disableMaterialInvar = false;
        disableMaterialPlatinum = false;
        disableMaterialElectrum = false;
        disableMaterialNickel = false;
        disableMaterialLead = false;
        speedDagger = 2.5f;
        disableDagger = false;
        damageBaseDagger = 2.5f;
        damageMultiplierDagger = 0.5f;
        speedParryingDagger = 2.5f;
        disableParryingDagger = false;
        damageBaseParryingDagger = 2.0f;
        damageMultiplierParryingDagger = 0.5f;
        speedLongsword = 1.4f;
        disableLongsword = false;
        damageBaseLongsword = 4.5f;
        damageMultiplierLongsword = 1.5f;
        speedKatana = 2.0f;
        disableKatana = false;
        damageBaseKatana = 3.5f;
        damageMultiplierKatana = 0.5f;
        speedSaber = 1.6f;
        disableSaber = false;
        damageBaseSaber = 4.5f;
        damageMultiplierSaber = 0.5f;
        speedRapier = 2.4f;
        disableRapier = false;
        damageBaseRapier = 2.5f;
        damageMultiplierRapier = 0.5f;
        speedGreatsword = 1.4f;
        disableGreatsword = false;
        damageBaseGreatsword = 6.0f;
        damageMultiplierGreatsword = 2.0f;
        speedCaestus = 3.5f;
        disableCaestus = false;
        damageBaseCaestus = 2.0f;
        damageMultiplierCaestus = 0.5f;
        speedClub = 1.3f;
        disableClub = false;
        damageBaseClub = 4.0f;
        damageMultiplierClub = 1.0f;
        speedHammer = 0.8f;
        disableHammer = false;
        damageBaseHammer = 6.0f;
        damageMultiplierHammer = 1.0f;
        speedWarhammer = 1.1f;
        disableWarhammer = false;
        damageBaseWarhammer = 4.0f;
        damageMultiplierWarhammer = 1.0f;
        speedSpear = 1.4f;
        disableSpear = false;
        damageBaseSpear = 4.5f;
        damageMultiplierSpear = 0.5f;
        speedHalberd = 1.2f;
        disableHalberd = false;
        damageBaseHalberd = 6.5f;
        damageMultiplierHalberd = 2.5f;
        speedPike = 1.4f;
        disablePike = false;
        damageBasePike = 4.0f;
        damageMultiplierPike = 0.5f;
        speedLance = 1.0f;
        disableLance = false;
        damageBaseLance = 4.0f;
        damageMultiplierLance = 1.0f;
        disableLongbow = false;
        multiplierLongbow = 1.25f;
        woodenLongbowOnly = false;
        disableCrossbow = false;
        crossbowInaccuracyMax = 10.0f;
        crossbowTicksToLoad = 20;
        crossbowTicksCooldown = 8;
        boltBaseDamage = 4.0f;
        boltDiamondBaseDamage = 5.0f;
        woodenCrossbowOnly = false;
        disableThrowingKnife = false;
        meleeSpeedThrowingKnife = 2.5f;
        damageBaseThrowingKnife = 1.5f;
        damageMultiplierThrowingKnife = 0.5f;
        disableThrowingAxe = false;
        meleeSpeedThrowingAxe = 0.9f;
        damageBaseThrowingAxe = 2.0f;
        damageMultiplierThrowingAxe = 1.0f;
        disableJavelin = false;
        meleeSpeedJavelin = 1.2f;
        damageBaseJavelin = 1.5f;
        damageMultiplierJavelin = 0.5f;
        disableBoomerang = false;
        woodenBoomerangOnly = false;
        damageBaseBoomerang = 4.0f;
        damageMultiplierBoomerang = 1.0f;
        disableBattleaxe = false;
        damageBaseBattleaxe = 5.0f;
        damageMultiplierBattleaxe = 2.0f;
        disableMace = false;
        damageBaseMace = 4.0f;
        damageMultiplierMace = 1.0f;
        disableGlaive = false;
        damageBaseGlaive = 4.0f;
        damageMultiplierGlaive = 1.0f;
        disableQuarterstaff = false;
        damageBaseQuarterstaff = 1.5f;
        damageMultiplierQuarterstaff = 1.0f;
        disableNewArrows = false;
        disableDiamondArrowsAndBolts = false;
        disableQuivers = false;
        quiverBowBlacklist = (String[])Reference.DefaultQuiverArrowBlacklist.clone();
        baseDamageArrowWood = 0.2f;
        baseDamageArrowIron = 3.0f;
        baseDamageArrowDiamond = 3.5f;
        disableExplosives = false;
        enableTerrainDamage = true;
        quickStrikeHurtResistTicks = 14;
        enableExperimentalWeapons = false;
        enableModdedMaterialWeapons = true;
        forceDisableUncraftableTooltips = false;
        quiverHudAlignment = AlignmentHelper.validAlignmentValues.get(AlignmentHelper.Alignment.BOTTOM_RIGHT.ordinal());
        quiverHudOffsetX = 0;
        quiverHudOffsetY = 0;
        disableNewCrosshairCrossbow = true;
        disableNewCrosshairThrowingWeapon = true;
        forceCompatibilityCrosshairs = false;
        categories = new String[]{"general", "client", categoryMaterials, categoryDagger, categoryParryingDagger, categoryLongsword, categoryKatana, categorySaber, categoryRapier, categoryGreatsword, categoryCaestus, categoryClub, categoryHammer, categoryWarhammer, categorySpear, categoryHalberd, categoryPike, categoryLance, categoryLongbow, categoryCrossbow, categoryThrowingKnife, categoryThrowingAxe, categoryJavelin, categoryBoomerang, categoryBattleaxe, categoryMace, categoryGlaive, categoryQuarterstaff, categoryArrows, categoryExplosives, categoryWeaponProperties};
    }
}

