/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.proxy;

import com.oblivioussp.spartanweaponry.api.ToolMaterialEx;
import com.oblivioussp.spartanweaponry.client.render.projectile.RenderFactoryArrowSW;
import com.oblivioussp.spartanweaponry.client.render.projectile.RenderFactoryBolt;
import com.oblivioussp.spartanweaponry.client.render.projectile.RenderFactoryBoomerang;
import com.oblivioussp.spartanweaponry.client.render.projectile.RenderFactoryThrowingAxe;
import com.oblivioussp.spartanweaponry.client.render.projectile.RenderFactoryThrowingKnife;
import com.oblivioussp.spartanweaponry.client.render.projectile.RenderFactoryThrownJavelin;
import com.oblivioussp.spartanweaponry.client.render.projectile.RenderFactoryThrownWeapon;
import com.oblivioussp.spartanweaponry.entity.projectile.EntityArrowDiamond;
import com.oblivioussp.spartanweaponry.entity.projectile.EntityArrowExplosive;
import com.oblivioussp.spartanweaponry.entity.projectile.EntityArrowIron;
import com.oblivioussp.spartanweaponry.entity.projectile.EntityArrowWood;
import com.oblivioussp.spartanweaponry.entity.projectile.EntityBoltDiamond;
import com.oblivioussp.spartanweaponry.entity.projectile.EntityBoltSpectral;
import com.oblivioussp.spartanweaponry.entity.projectile.EntityBoltTipped;
import com.oblivioussp.spartanweaponry.entity.projectile.EntityBoomerang;
import com.oblivioussp.spartanweaponry.entity.projectile.EntityDynamite;
import com.oblivioussp.spartanweaponry.entity.projectile.EntityThrowingAxe;
import com.oblivioussp.spartanweaponry.entity.projectile.EntityThrowingKnife;
import com.oblivioussp.spartanweaponry.entity.projectile.EntityThrownJavelin;
import com.oblivioussp.spartanweaponry.entity.projectile.EntityThrownWeapon;
import com.oblivioussp.spartanweaponry.init.ItemRegistrySW;
import com.oblivioussp.spartanweaponry.init.ModelRenderRegistry;
import com.oblivioussp.spartanweaponry.proxy.CommonProxy;
import com.oblivioussp.spartanweaponry.util.ConfigHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent ev) {
        RenderingRegistry.registerEntityRenderingHandler(EntityBoltTipped.class, new RenderFactoryBolt());
        RenderingRegistry.registerEntityRenderingHandler(EntityBoltSpectral.class, new RenderFactoryBolt());
        RenderingRegistry.registerEntityRenderingHandler(EntityThrownWeapon.class, new RenderFactoryThrownWeapon());
        RenderingRegistry.registerEntityRenderingHandler(EntityThrowingKnife.class, (IRenderFactory)new RenderFactoryThrowingKnife());
        RenderingRegistry.registerEntityRenderingHandler(EntityThrowingAxe.class, new RenderFactoryThrowingAxe());
        RenderingRegistry.registerEntityRenderingHandler(EntityThrownJavelin.class, (IRenderFactory)new RenderFactoryThrownJavelin());
        RenderingRegistry.registerEntityRenderingHandler(EntityArrowWood.class, new RenderFactoryArrowSW());
        RenderingRegistry.registerEntityRenderingHandler(EntityArrowIron.class, new RenderFactoryArrowSW());
        RenderingRegistry.registerEntityRenderingHandler(EntityArrowDiamond.class, new RenderFactoryArrowSW());
        RenderingRegistry.registerEntityRenderingHandler(EntityArrowExplosive.class, new RenderFactoryArrowSW());
        RenderingRegistry.registerEntityRenderingHandler(EntityBoomerang.class, (IRenderFactory)new RenderFactoryBoomerang());
        RenderingRegistry.registerEntityRenderingHandler(EntityDynamite.class, (IRenderFactory)new IRenderFactory<EntityDynamite>(){

            public Render<? super EntityDynamite> createRenderFor(RenderManager manager) {
                return new RenderSnowball(manager, (Item)ItemRegistrySW.dynamite, Minecraft.func_71410_x().func_175599_af());
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityBoltDiamond.class, new RenderFactoryBolt());
    }

    @Override
    public void init(FMLInitializationEvent ev) {
        if (!ConfigHandler.disableCrossbow) {
            this.registerTippedProjectileColourHandler(ItemRegistrySW.boltTipped);
        }
        if (!ConfigHandler.disableNewArrows) {
            this.registerTippedProjectileColourHandler((Item)ItemRegistrySW.arrowTippedWood);
            this.registerTippedProjectileColourHandler((Item)ItemRegistrySW.arrowTippedIron);
            if (!ConfigHandler.disableDiamondArrowsAndBolts) {
                this.registerTippedProjectileColourHandler((Item)ItemRegistrySW.arrowTippedDiamond);
                this.registerTippedProjectileColourHandler(ItemRegistrySW.boltTippedDiamond);
            }
        }
        ModelRenderRegistry.registerColourHandlers();
    }

    @Override
    public void postInit(FMLPostInitializationEvent ev) {
    }

    protected void registerTippedProjectileColourHandler(Item item) {
        FMLClientHandler.instance().getClient().getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                PotionType potion = PotionUtils.func_185191_c((ItemStack)stack);
                if (potion == null) {
                    return 0xFFFFFF;
                }
                return tintIndex == 1 ? PotionUtils.func_185183_a((PotionType)potion) : 0xFFFFFF;
            }
        }, new Item[]{item});
    }

    protected void registerPotionColourHandler(Item item) {
        FMLClientHandler.instance().getClient().getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                PotionType potion = PotionUtils.func_185191_c((ItemStack)stack);
                if (potion == null) {
                    return 0xFFFFFF;
                }
                return tintIndex == 0 ? PotionUtils.func_185183_a((PotionType)potion) : 0xFFFFFF;
            }
        }, new Item[]{item});
    }

    @Override
    public void addColourHandler(Item item, ToolMaterialEx material) {
        ModelRenderRegistry.addItemToColourHandler(item, material);
    }
}

