/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.oblivioussp.spartanweaponry.api.ToolMaterialEx;
import com.oblivioussp.spartanweaponry.api.WeaponProperties;
import com.oblivioussp.spartanweaponry.entity.projectile.EntityBoomerang;
import com.oblivioussp.spartanweaponry.entity.projectile.EntityThrownWeapon;
import com.oblivioussp.spartanweaponry.init.EnchantmentRegistrySW;
import com.oblivioussp.spartanweaponry.init.SoundRegistry;
import com.oblivioussp.spartanweaponry.item.ItemThrowingWeapon;
import com.oblivioussp.spartanweaponry.util.ConfigHandler;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class ItemBoomerang
extends ItemThrowingWeapon {
    public ItemBoomerang(String unlocName, ToolMaterialEx toolMaterial) {
        super(unlocName, toolMaterial, ConfigHandler.damageBaseBoomerang, ConfigHandler.damageMultiplierBoomerang, 2.0f, WeaponProperties.THROWABLE);
        this.displayName = "boomerang_custom";
    }

    public ItemBoomerang(String unlocName, String externalModId, ToolMaterialEx material) {
        this(unlocName, material);
        this.modId = externalModId;
    }

    @Deprecated
    public ItemBoomerang(String unlocName, String externalModId, ToolMaterialEx material, float weaponDamage) {
        this(unlocName, externalModId, material);
    }

    @Override
    public EntityThrownWeapon createThrownWeaponEntity(World world, EntityPlayer player) {
        return new EntityBoomerang(world, (EntityLivingBase)player);
    }

    @Override
    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            this.throwVelocity = 0.95f;
            int charge = this.func_77626_a(stack) - timeLeft;
            if (charge >= 5) {
                charge = 5;
            }
            if (!worldIn.field_72995_K && charge > 2) {
                int k;
                EntityBoomerang thrown = (EntityBoomerang)this.createThrownWeaponEntity(worldIn, player);
                if (thrown == null) {
                    return;
                }
                thrown.setWeapon(stack);
                int i = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistrySW.THROWING_RANGE, (ItemStack)stack);
                thrown.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, this.throwVelocity * ((float)i * 0.2f + 1.0f) * ((float)charge / 10.0f + 0.5f), 0.5f);
                thrown.func_70107_b(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e() * 0.9 - (double)0.1f, player.field_70161_v);
                thrown.func_70239_b(this.getDirectAttackDamage());
                thrown.setMaxDistance((double)charge / 10.0 * 12.0);
                int j = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistrySW.THROWING_DAMAGE, (ItemStack)stack);
                if (j > 0) {
                    thrown.func_70239_b(thrown.func_70242_d() + (double)j * 0.5 + 0.5);
                }
                if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)stack)) > 0) {
                    thrown.func_70240_a(k);
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistrySW.THROWING_FIRE, (ItemStack)stack) > 0) {
                    thrown.func_70015_d(100);
                }
                if (player.field_71075_bZ.field_75098_d) {
                    thrown.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                } else {
                    stack.func_190918_g(1);
                    if (stack.func_190916_E() <= 0) {
                        player.field_71071_by.func_184437_d(stack);
                    }
                }
                worldIn.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundRegistry.BOOMERANG_THROW, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                worldIn.func_72838_d((Entity)thrown);
            }
            player.func_71029_a(StatList.func_188057_b((Item)this));
        }
    }

    @Override
    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        HashMultimap multimap = HashMultimap.create();
        return multimap;
    }
}

