/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry;

import com.oblivioussp.spartanweaponry.api.SpartanWeaponryAPI;
import com.oblivioussp.spartanweaponry.client.gui.CreativeTabsSW;
import com.oblivioussp.spartanweaponry.client.gui.GuiHandler;
import com.oblivioussp.spartanweaponry.init.ItemRegistrySW;
import com.oblivioussp.spartanweaponry.network.NetworkHandler;
import com.oblivioussp.spartanweaponry.proxy.CommonProxy;
import com.oblivioussp.spartanweaponry.util.APIInternalMethodHandler;
import com.oblivioussp.spartanweaponry.util.AdvancementTrigger;
import com.oblivioussp.spartanweaponry.util.ConfigHandler;
import com.oblivioussp.spartanweaponry.util.LogHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

@Mod(modid="spartanweaponry", name="Spartan Weaponry", version="beta 1.3.8", dependencies="", acceptedMinecraftVersions="[1.12.2]", guiFactory="com.oblivioussp.spartanweaponry.client.gui.GuiFactorySW")
public class ModSpartanWeaponry {
    @Mod.Instance(value="spartanweaponry")
    public static ModSpartanWeaponry instance;
    @SidedProxy(clientSide="com.oblivioussp.spartanweaponry.proxy.ClientProxy", serverSide="com.oblivioussp.spartanweaponry.proxy.ServerProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent ev) {
        LogHelper.info("Starting up Spartan Weaponry!");
        SpartanWeaponryAPI.internalHandler = new APIInternalMethodHandler();
        LogHelper.info("API: Loaded internal method handler. API functionality should work now!");
        ConfigHandler.init(ev.getModConfigurationDirectory());
        MinecraftForge.EVENT_BUS.register((Object)new ConfigHandler());
        ItemRegistrySW.registerModdedMaterials();
        if (ConfigHandler.enableModdedMaterialWeapons) {
            CreativeTabsSW.preInit();
        }
        proxy.preInit(ev);
        LogHelper.debug("Finished preInit phase!");
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent ev) {
        NetworkHandler.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        AdvancementTrigger.registerTriggers();
        proxy.init(ev);
        LogHelper.debug("Finished init phase!");
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent ev) {
        proxy.postInit(ev);
        LogHelper.debug("Finished postInit phase!");
    }
}

