/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.worldgen.IGroundFinder;
import com.ferreusveritas.dynamictrees.systems.poissondisc.PoissonDisc;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBase;
import com.ferreusveritas.dynamictrees.worldgen.TreeGenerator;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGeneratorTrees
implements IWorldGenerator {
    public void generate(Random randomUnused, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.func_175624_G() == WorldType.field_77138_c) {
            return;
        }
        TreeGenerator treeGenerator = TreeGenerator.getTreeGenerator();
        BiomeDataBase dbase = treeGenerator.getBiomeDataBase(world);
        if (dbase != TreeGenerator.DIMENSIONBLACKLISTED) {
            SafeChunkBounds safeBounds = new SafeChunkBounds(world, new ChunkPos(chunkX, chunkZ));
            treeGenerator.getCircleProvider().getPoissonDiscs(world, chunkX, 0, chunkZ).forEach(c -> treeGenerator.makeTree(world, dbase, (PoissonDisc)c, new GroundFinder(), safeBounds));
        }
    }

    public static class GroundFinder
    implements IGroundFinder {
        protected boolean inNetherRange(BlockPos pos) {
            return pos.func_177956_o() >= 0 && pos.func_177956_o() <= 128;
        }

        protected ArrayList<Integer> findSubterraneanLayerHeights(World world, BlockPos start) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(world.func_175645_m(start)).func_189536_c(EnumFacing.DOWN);
            ArrayList<Integer> layers = new ArrayList<Integer>();
            while (this.inNetherRange((BlockPos)pos)) {
                while (!world.func_175623_d((BlockPos)pos) && this.inNetherRange((BlockPos)pos)) {
                    pos.func_189534_c(EnumFacing.UP, 4);
                }
                while (world.func_175623_d((BlockPos)pos) && this.inNetherRange((BlockPos)pos)) {
                    pos.func_189536_c(EnumFacing.DOWN);
                }
                if (world.func_180495_p((BlockPos)pos).func_185904_a() != Material.field_151587_i) {
                    layers.add(pos.func_177956_o());
                }
                pos.func_189534_c(EnumFacing.UP, 16);
                while (world.func_175623_d((BlockPos)pos) && this.inNetherRange((BlockPos)pos)) {
                    pos.func_189534_c(EnumFacing.UP, 4);
                }
            }
            if (layers.size() > 0) {
                layers.remove(layers.size() - 1);
            }
            return layers;
        }

        protected BlockPos findSubterraneanGround(World world, BlockPos start) {
            ArrayList<Integer> layers = this.findSubterraneanLayerHeights(world, start);
            if (layers.size() < 1) {
                return BlockPos.field_177992_a;
            }
            int y = layers.get(world.field_73012_v.nextInt(layers.size()));
            return new BlockPos(start.func_177958_n(), y, start.func_177952_p());
        }

        protected boolean inOverworldRange(BlockPos pos) {
            return pos.func_177956_o() >= 0 && pos.func_177956_o() <= 255;
        }

        protected BlockPos findOverworldGround(World world, BlockPos start) {
            Chunk chunk = world.func_175726_f(start);
            BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(world.func_175645_m(start)).func_189534_c(EnumFacing.UP, 2);
            while (this.inOverworldRange((BlockPos)mPos)) {
                Material material;
                IBlockState state = chunk.func_177435_g((BlockPos)mPos);
                Block testBlock = state.func_177230_c();
                if (testBlock != Blocks.field_150350_a && ((material = state.func_185904_a()) == Material.field_151578_c || material == Material.field_151586_h || state.func_185904_a().func_76230_c() && !testBlock.isLeaves(state, (IBlockAccess)world, (BlockPos)mPos) && !testBlock.isFoliage((IBlockAccess)world, (BlockPos)mPos))) {
                    return mPos.func_185334_h();
                }
                mPos.func_189536_c(EnumFacing.DOWN);
            }
            return BlockPos.field_177992_a;
        }

        @Override
        public BlockPos findGround(BiomeDataBase.BiomeEntry biomeEntry, World world, BlockPos start) {
            return biomeEntry.isSubterraneanBiome() ? this.findSubterraneanGround(world, start) : this.findOverworldGround(world, start);
        }
    }
}

