/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.nodemappers;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class NodeFreezer
implements INodeInspector {
    Species species;

    public NodeFreezer(Species species) {
        this.species = species;
    }

    @Override
    public boolean run(IBlockState blockState, World world, BlockPos pos, EnumFacing fromDir) {
        int radius;
        BlockBranch branch = TreeHelper.getBranch(blockState);
        if (branch != null && (radius = branch.getRadius(blockState)) == 1) {
            this.freezeSurroundingLeaves(world, branch, pos);
        }
        return true;
    }

    @Override
    public boolean returnRun(IBlockState blockState, World world, BlockPos pos, EnumFacing fromDir) {
        return false;
    }

    public void freezeSurroundingLeaves(World world, BlockBranch branch, BlockPos twigPos) {
        if (!world.field_72995_K && !world.restoringBlockSnapshots) {
            TreeFamily tree = branch.getFamily();
            IBlockState primLeaves = this.species.getLeavesProperties().getPrimitiveLeaves();
            for (BlockPos leavesPos : BlockPos.func_177980_a((BlockPos)twigPos.func_177982_a(-3, -3, -3), (BlockPos)twigPos.func_177982_a(3, 3, 3))) {
                if (!tree.isCompatibleGenericLeaves(world.func_180495_p(leavesPos), (IBlockAccess)world, leavesPos)) continue;
                world.func_175656_a(leavesPos, primLeaves.func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)));
            }
        }
    }
}

