/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.featuregen;

import com.ferreusveritas.dynamictrees.api.IFullGenFeature;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import com.google.common.collect.Iterables;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class FeatureGenHugeMushroom
implements IFullGenFeature {
    private final Block mushroomType;
    private int height = -1;
    static final SimpleVoxmap brnCap = new SimpleVoxmap(7, 1, 7, new byte[]{0, 1, 2, 2, 2, 3, 0, 1, 5, 5, 5, 5, 5, 3, 4, 5, 5, 5, 5, 5, 6, 4, 5, 5, 5, 5, 5, 6, 4, 5, 5, 5, 5, 5, 6, 7, 5, 5, 5, 5, 5, 9, 0, 7, 8, 8, 8, 9, 0}).setCenter(new BlockPos(3, 0, 3));
    static final SimpleVoxmap brnCapMedium = new SimpleVoxmap(5, 1, 5, new byte[]{0, 1, 2, 3, 0, 1, 5, 5, 5, 3, 4, 5, 5, 5, 6, 7, 5, 5, 5, 9, 0, 7, 8, 9, 0}).setCenter(new BlockPos(2, 0, 2));
    static final SimpleVoxmap brnCapSmall = new SimpleVoxmap(3, 1, 3, new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}).setCenter(new BlockPos(1, 0, 1));
    static final SimpleVoxmap redCap = new SimpleVoxmap(5, 4, 5, new byte[]{0, 1, 2, 3, 0, 1, 0, 0, 0, 3, 4, 0, 10, 0, 6, 7, 0, 0, 0, 9, 0, 7, 8, 9, 0, 0, 1, 2, 3, 0, 1, 0, 0, 0, 3, 4, 0, 10, 0, 6, 7, 0, 0, 0, 9, 0, 7, 8, 9, 0, 0, 1, 2, 3, 0, 1, 0, 0, 0, 3, 4, 0, 10, 0, 6, 7, 0, 0, 0, 9, 0, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 0, 0, 4, 5, 6, 0, 0, 7, 8, 9, 0, 0, 0, 0, 0, 0}).setCenter(new BlockPos(2, 3, 2));
    static final SimpleVoxmap redCapShort = new SimpleVoxmap(5, 3, 5, new byte[]{0, 1, 2, 3, 0, 1, 0, 0, 0, 3, 4, 0, 10, 0, 6, 7, 0, 0, 0, 9, 0, 7, 8, 9, 0, 0, 1, 2, 3, 0, 1, 0, 0, 0, 3, 4, 0, 10, 0, 6, 7, 0, 0, 0, 9, 0, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 0, 0, 4, 5, 6, 0, 0, 7, 8, 9, 0, 0, 0, 0, 0, 0}).setCenter(new BlockPos(2, 2, 2));
    static final SimpleVoxmap redCapSmall = new SimpleVoxmap(3, 2, 3, new byte[]{1, 2, 3, 4, 10, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8, 9}).setCenter(new BlockPos(1, 1, 1));

    public FeatureGenHugeMushroom(Block block) {
        this.mushroomType = block;
    }

    public FeatureGenHugeMushroom() {
        this.mushroomType = null;
    }

    public FeatureGenHugeMushroom setHeight(int height) {
        this.height = height;
        return this;
    }

    protected SimpleVoxmap getCapForHeight(Block mushroomBlock, int height) {
        if (mushroomBlock == Blocks.field_150420_aW) {
            switch (height) {
                case 2: 
                case 3: {
                    return brnCapSmall;
                }
                case 4: 
                case 5: {
                    return brnCapMedium;
                }
            }
            return brnCap;
        }
        switch (height) {
            case 2: {
                return brnCapSmall;
            }
            case 3: {
                return redCapSmall;
            }
            case 4: {
                return redCapShort;
            }
        }
        return redCap;
    }

    protected int getMushroomHeight(World world, BlockPos rootPos, Biome biome, Random random, int radius, SafeChunkBounds safeBounds) {
        return this.height > 0 ? this.height : random.nextInt(9) + 2;
    }

    @Override
    public boolean generate(World world, BlockPos rootPos, Species species, Biome biome, Random random, int radius, SafeChunkBounds safeBounds) {
        BlockPos genPos = rootPos.func_177984_a();
        int height = this.getMushroomHeight(world, rootPos, biome, random, radius, safeBounds);
        IBlockState soilState = world.func_180495_p(rootPos);
        if (species.isAcceptableSoilForWorldgen(world, rootPos, soilState)) {
            Block mushroomBlock = this.mushroomType;
            if (mushroomBlock == null) {
                mushroomBlock = random.nextBoolean() ? Blocks.field_150420_aW : Blocks.field_150419_aX;
            }
            SimpleVoxmap capMap = this.getCapForHeight(mushroomBlock, height);
            BlockPos capPos = genPos.func_177981_b(height - 1);
            BlockBounds capBounds = capMap.getBounds().move(capPos);
            if (safeBounds.inBounds(capBounds, true)) {
                for (BlockPos.MutableBlockPos mutPos : Iterables.concat((Iterable)BlockPos.func_177975_b((BlockPos)BlockPos.field_177992_a.func_177979_c(capMap.getLenY()), (BlockPos)BlockPos.field_177992_a.func_177979_c(height - 1)), capMap.getAllNonZero())) {
                    BlockPos dPos = mutPos.func_177971_a((Vec3i)capPos);
                    IBlockState state = world.func_180495_p(dPos);
                    if (state.func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)world, dPos) && state.func_177230_c().func_176200_f((IBlockAccess)world, dPos)) continue;
                    return false;
                }
                for (SimpleVoxmap.Cell cell : capMap.getAllNonZeroCells()) {
                    BlockHugeMushroom.EnumType mushroomType = BlockHugeMushroom.EnumType.func_176895_a((int)cell.getValue());
                    world.func_175656_a(capPos.func_177971_a((Vec3i)cell.getPos()), mushroomBlock.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)mushroomType));
                }
                int stemLen = height - capMap.getLenY();
                IBlockState stemBlock = mushroomBlock.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.STEM);
                for (int y = 0; y < stemLen; ++y) {
                    world.func_175656_a(genPos.func_177981_b(y), stemBlock);
                }
                return true;
            }
        }
        return false;
    }
}

