/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models.loaders;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

@SideOnly(value=Side.CLIENT)
public abstract class ModelLoaderGeneric
implements ICustomModelLoader {
    public ResourceLocation resourceName;
    public String code;
    protected IResourceManager resourceManager;

    public ModelLoaderGeneric(String code, ResourceLocation resourceName) {
        this.code = "#" + code;
        this.resourceName = resourceName;
    }

    public boolean accepts(ResourceLocation resourceLocation) {
        return resourceLocation.func_110623_a().endsWith(this.code);
    }

    public IModel loadModel(ResourceLocation resourceLocation) {
        ModelBlock baseModelBlock = this.getBaseModelBlock(resourceLocation);
        return baseModelBlock != null ? this.loadModel(resourceLocation, baseModelBlock) : ModelLoaderRegistry.getMissingModel();
    }

    protected abstract IModel loadModel(ResourceLocation var1, ModelBlock var2);

    protected ModelBlock getBaseModelBlock(ResourceLocation virtualLocation) {
        if (!this.accepts(virtualLocation)) {
            return null;
        }
        String path = virtualLocation.func_110623_a();
        path = path.substring(0, path.length() - this.code.length());
        ResourceLocation location = new ResourceLocation(virtualLocation.func_110624_b(), path);
        ModelBlock modelBlock = null;
        InputStreamReader reader = null;
        IResource iresource = null;
        try {
            iresource = this.resourceManager.func_110536_a(this.getModelLocation(location));
            reader = new InputStreamReader(iresource.func_110527_b(), Charsets.UTF_8);
            modelBlock = ModelBlock.func_178307_a((Reader)reader);
            modelBlock.field_178317_b = location.toString();
            ModelBlock rootParent = modelBlock;
            while (rootParent.field_178315_d != null) {
                rootParent = rootParent.field_178315_d;
            }
            if (rootParent.func_178305_e() != null && rootParent.func_178305_e().equals((Object)this.resourceName)) {
                return modelBlock;
            }
            return null;
        }
        catch (IOException e) {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(iresource);
            return null;
        }
    }

    protected ResourceLocation getModelLocation(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), location.func_110623_a() + ".json");
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }
}

