/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.cells;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.cells.CellNull;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.api.cells.ICellKit;
import com.ferreusveritas.dynamictrees.api.cells.ICellSolver;
import com.ferreusveritas.dynamictrees.cells.CellAcaciaLeaf;
import com.ferreusveritas.dynamictrees.cells.CellConiferBranch;
import com.ferreusveritas.dynamictrees.cells.CellConiferLeaf;
import com.ferreusveritas.dynamictrees.cells.CellConiferTopBranch;
import com.ferreusveritas.dynamictrees.cells.CellDarkOakLeaf;
import com.ferreusveritas.dynamictrees.cells.CellNormal;
import com.ferreusveritas.dynamictrees.cells.CellPalmFrond;
import com.ferreusveritas.dynamictrees.cells.LeafClusters;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class CellKits {
    private static final ICellSolver NULLCELLSOLVER = new ICellSolver(){

        @Override
        public int solve(ICell[] cells) {
            return 0;
        }
    };
    public static final ICellKit NULLCELLKIT = new ICellKit(){

        @Override
        public ICell getCellForLeaves(int hydro) {
            return CellNull.NULLCELL;
        }

        @Override
        public ICell getCellForBranch(int radius, int meta) {
            return CellNull.NULLCELL;
        }

        @Override
        public ICellSolver getCellSolver() {
            return NULLCELLSOLVER;
        }

        @Override
        public SimpleVoxmap getLeafCluster() {
            return LeafClusters.NULLMAP;
        }

        @Override
        public int getDefaultHydration() {
            return 0;
        }
    };
    private final ICellKit deciduous = new ICellKit(){
        private final ICell[] normalCells = new ICell[]{CellNull.NULLCELL, new CellNormal(1), new CellNormal(2), new CellNormal(3), new CellNormal(4), new CellNormal(5), new CellNormal(6), new CellNormal(7)};
        private final ICell branchCell = new CellNormal(5);
        private final BasicSolver deciduousSolver = new BasicSolver(new short[]{1300, 1059, 802, 1041, 785, 529});

        @Override
        public ICell getCellForLeaves(int hydro) {
            return this.normalCells[hydro];
        }

        @Override
        public ICell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.branchCell : CellNull.NULLCELL;
        }

        @Override
        public SimpleVoxmap getLeafCluster() {
            return LeafClusters.deciduous;
        }

        @Override
        public ICellSolver getCellSolver() {
            return this.deciduousSolver;
        }

        @Override
        public int getDefaultHydration() {
            return 4;
        }
    };
    private final ICellKit conifer = new ICellKit(){
        private final ICell coniferBranch = new CellConiferBranch();
        private final ICell coniferTopBranch = new CellConiferTopBranch();
        private final ICell[] coniferLeafCells = new ICell[]{CellNull.NULLCELL, new CellConiferLeaf(1), new CellConiferLeaf(2), new CellConiferLeaf(3), new CellConiferLeaf(4)};
        private final BasicSolver coniferSolver = new BasicSolver(new short[]{1300, 1043, 786, 529});

        @Override
        public ICell getCellForLeaves(int hydro) {
            return this.coniferLeafCells[hydro];
        }

        @Override
        public ICell getCellForBranch(int radius, int meta) {
            if (meta == 1) {
                return this.coniferTopBranch;
            }
            if (radius == 1) {
                return this.coniferBranch;
            }
            return CellNull.NULLCELL;
        }

        @Override
        public SimpleVoxmap getLeafCluster() {
            return LeafClusters.conifer;
        }

        @Override
        public ICellSolver getCellSolver() {
            return this.coniferSolver;
        }

        @Override
        public int getDefaultHydration() {
            return 4;
        }
    };
    private final ICellKit acacia = new ICellKit(){
        private final ICell acaciaBranch = new ICell(){
            final int[] map = new int[]{0, 3, 5, 5, 5, 5};

            @Override
            public int getValue() {
                return 5;
            }

            @Override
            public int getValueFromSide(EnumFacing side) {
                return this.map[side.ordinal()];
            }
        };
        private final ICell[] acaciaLeafCells = new ICell[]{CellNull.NULLCELL, new CellAcaciaLeaf(1), new CellAcaciaLeaf(2), new CellAcaciaLeaf(3), new CellAcaciaLeaf(4)};
        private final BasicSolver acaciaSolver = new BasicSolver(new short[]{1300, 1059, 1042, 786, 529});

        @Override
        public ICell getCellForLeaves(int hydro) {
            return this.acaciaLeafCells[hydro];
        }

        @Override
        public ICell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.acaciaBranch : CellNull.NULLCELL;
        }

        @Override
        public SimpleVoxmap getLeafCluster() {
            return LeafClusters.acacia;
        }

        @Override
        public ICellSolver getCellSolver() {
            return this.acaciaSolver;
        }

        @Override
        public int getDefaultHydration() {
            return 4;
        }
    };
    private final ICellKit darkoak = new ICellKit(){
        private final ICell branchCell = new CellNormal(5);
        private final ICell[] darkOakLeafCells = new ICell[]{CellNull.NULLCELL, new CellDarkOakLeaf(1), new CellDarkOakLeaf(2), new CellDarkOakLeaf(3), new CellDarkOakLeaf(4)};
        private final BasicSolver darkOakSolver = new BasicSolver(new short[]{1300, 1059, 1042, 786, 529});

        @Override
        public ICell getCellForLeaves(int hydro) {
            return this.darkOakLeafCells[hydro];
        }

        @Override
        public ICell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.branchCell : CellNull.NULLCELL;
        }

        @Override
        public SimpleVoxmap getLeafCluster() {
            return LeafClusters.darkoak;
        }

        @Override
        public ICellSolver getCellSolver() {
            return this.darkOakSolver;
        }

        @Override
        public int getDefaultHydration() {
            return 4;
        }
    };
    private final ICellKit bare = new ICellKit(){
        private final ICellSolver solver = new BasicSolver(new short[0]);

        @Override
        public ICell getCellForLeaves(int hydro) {
            return CellNull.NULLCELL;
        }

        @Override
        public ICell getCellForBranch(int radius, int meta) {
            return CellNull.NULLCELL;
        }

        @Override
        public SimpleVoxmap getLeafCluster() {
            return LeafClusters.bare;
        }

        @Override
        public ICellSolver getCellSolver() {
            return this.solver;
        }

        @Override
        public int getDefaultHydration() {
            return 0;
        }
    };
    private final ICellKit palm = new ICellKit(){
        private final ICell palmBranch = new ICell(){

            @Override
            public int getValue() {
                return 5;
            }

            @Override
            public int getValueFromSide(EnumFacing side) {
                return side == EnumFacing.UP ? this.getValue() : 0;
            }
        };
        private final ICell[] palmFrondCells = new ICell[]{CellNull.NULLCELL, new CellPalmFrond(1), new CellPalmFrond(2), new CellPalmFrond(3), new CellPalmFrond(4)};
        private final BasicSolver palmSolver = new BasicSolver(new short[]{1300, 1043, 786, 545});

        @Override
        public ICell getCellForLeaves(int hydro) {
            return this.palmFrondCells[hydro];
        }

        @Override
        public ICell getCellForBranch(int radius, int meta) {
            return this.palmBranch;
        }

        @Override
        public SimpleVoxmap getLeafCluster() {
            return LeafClusters.palm;
        }

        @Override
        public ICellSolver getCellSolver() {
            return this.palmSolver;
        }

        @Override
        public int getDefaultHydration() {
            return 4;
        }
    };

    public static void preInit() {
        new CellKits();
    }

    public CellKits() {
        TreeRegistry.registerCellKit(new ResourceLocation("dynamictrees", "deciduous"), this.deciduous);
        TreeRegistry.registerCellKit(new ResourceLocation("dynamictrees", "conifer"), this.conifer);
        TreeRegistry.registerCellKit(new ResourceLocation("dynamictrees", "acacia"), this.acacia);
        TreeRegistry.registerCellKit(new ResourceLocation("dynamictrees", "darkoak"), this.darkoak);
        TreeRegistry.registerCellKit(new ResourceLocation("dynamictrees", "bare"), this.bare);
        TreeRegistry.registerCellKit(new ResourceLocation("dynamictrees", "palm"), this.palm);
    }

    public static int solveCell(int[] nv, short[] solution) {
        for (short d : solution) {
            if (nv[d >> 8 & 0xF] < (d >> 4 & 0xF)) continue;
            return d & 0xF;
        }
        return 0;
    }

    public static class BasicSolver
    implements ICellSolver {
        private final short[] codes;

        public BasicSolver(short[] codes) {
            this.codes = codes;
        }

        @Override
        public int solve(ICell[] cells) {
            int[] nv = new int[16];
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                int n = cells[dir.ordinal()].getValueFromSide(dir.func_176734_d());
                nv[n] = nv[n] + 1;
            }
            return CellKits.solveCell(nv, this.codes);
        }
    }
}

