/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.ModTabs;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.cells.CellNull;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.MimicProperty;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRootyDirtFake
extends Block
implements ITreePart,
MimicProperty.IMimic {
    public BlockRootyDirtFake(String name) {
        super(Material.field_151578_c);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149675_a(true);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(ModTabs.dynamicTreesTab);
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!TreeHelper.isBranch(world.func_180495_p(pos.func_177971_a(dir.func_176730_m())))) continue;
            return;
        }
        world.func_175656_a(pos, ModBlocks.blockStates.dirt);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{MimicProperty.MIMIC});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess access, BlockPos pos) {
        return state instanceof IExtendedBlockState ? ((IExtendedBlockState)state).withProperty((IUnlistedProperty)MimicProperty.MIMIC, (Object)this.getMimic(access, pos)) : state;
    }

    @Override
    public IBlockState getMimic(IBlockAccess access, BlockPos pos) {
        return MimicProperty.getDirtMimic(access, pos);
    }

    @Override
    public boolean shouldAnalyse() {
        return false;
    }

    @Override
    public MapSignal analyse(IBlockState blockState, World world, BlockPos pos, EnumFacing fromDir, MapSignal signal) {
        return signal;
    }

    @Override
    public ICell getHydrationCell(IBlockAccess blockAccess, BlockPos pos, IBlockState blockState, EnumFacing dir, ILeavesProperties leavesProperties) {
        return CellNull.NULLCELL;
    }

    @Override
    public GrowSignal growSignal(World world, BlockPos pos, GrowSignal signal) {
        return signal;
    }

    @Override
    public int probabilityForBlock(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, BlockBranch from) {
        return 0;
    }

    @Override
    public int getRadiusForConnection(IBlockState blockState, IBlockAccess world, BlockPos pos, BlockBranch from, EnumFacing side, int fromRadius) {
        return 8;
    }

    @Override
    public int getRadius(IBlockState blockState) {
        return 8;
    }

    @Override
    public TreeFamily getFamily(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos) {
        return TreeFamily.NULLFAMILY;
    }

    @Override
    public int branchSupport(IBlockState blockState, IBlockAccess blockAccess, BlockBranch branch, BlockPos pos, EnumFacing dir, int radius) {
        return BlockBranch.setSupport(1, 1);
    }

    @Override
    public ITreePart.TreePartType getTreePartType() {
        return ITreePart.TreePartType.OTHER;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }
}

