/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.davincisvessels.common.entity;

import com.elytradev.davincisvessels.DavincisVesselsMod;
import com.elytradev.davincisvessels.common.api.block.IBlockBalloon;
import com.elytradev.davincisvessels.common.api.block.IBlockCustomMass;
import com.elytradev.davincisvessels.common.api.tileentity.ITileEngineModifier;
import com.elytradev.davincisvessels.common.entity.EntitySeat;
import com.elytradev.davincisvessels.common.entity.EntityShip;
import com.elytradev.davincisvessels.common.object.DavincisVesselsObjects;
import com.elytradev.davincisvessels.common.tileentity.AnchorInstance;
import com.elytradev.davincisvessels.common.tileentity.BlockLocation;
import com.elytradev.davincisvessels.common.tileentity.TileAnchorPoint;
import com.elytradev.davincisvessels.common.tileentity.TileHelm;
import com.elytradev.movingworld.common.chunk.LocatedBlock;
import com.elytradev.movingworld.common.entity.EntityMovingWorld;
import com.elytradev.movingworld.common.entity.MovingWorldCapabilities;
import com.elytradev.movingworld.common.util.FloodFiller;
import com.elytradev.movingworld.common.util.LocatedBlockList;
import com.elytradev.movingworld.common.util.MaterialDensity;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ShipCapabilities
extends MovingWorldCapabilities {
    private final EntityShip ship;
    public float speedMultiplier;
    public float rotationMultiplier;
    public float liftMultiplier;
    public float brakeMult;
    private float mass;
    private List<LocatedBlock> anchorPoints;
    private List<EntitySeat> seats;
    private List<ITileEngineModifier> engines;
    private int balloonCount;
    private int floaters;
    private int blockCount;
    private int nonAirBlockCount;
    private boolean canSubmerge = false;
    private boolean submerseFound = false;

    public ShipCapabilities(EntityMovingWorld movingWorld, boolean autoCalcMass) {
        super(movingWorld, autoCalcMass);
        this.ship = (EntityShip)movingWorld;
        this.seats = new ArrayList<EntitySeat>();
    }

    public float getMass() {
        return this.mass;
    }

    public void setMass(float mass) {
        this.mass = mass;
    }

    public float getSpeedMult() {
        return this.speedMultiplier + this.getEnginePower() * 0.5f;
    }

    public float getRotationMult() {
        return this.rotationMultiplier + this.getEnginePower() * 0.25f;
    }

    public float getLiftMult() {
        return this.liftMultiplier + this.getEnginePower() * 0.5f;
    }

    public float getEnginePower() {
        return ((Float)this.ship.func_184212_Q().func_187225_a(EntityShip.ENGINE_POWER)).floatValue();
    }

    public ImmutablePair<LocatedBlock, LocatedBlock> findClosestValidAnchor(int radius) {
        LocatedBlock closest = LocatedBlock.AIR;
        LocatedBlock shipAnchor = LocatedBlock.AIR;
        int smallestOverallDistance = Integer.MAX_VALUE;
        if (this.anchorPoints != null) {
            for (LocatedBlock anchorLB : this.anchorPoints) {
                TileAnchorPoint anchorTile = (TileAnchorPoint)anchorLB.tileEntity;
                AnchorInstance anchor = anchorTile.getInstance();
                if (anchor.getRelatedAnchors().isEmpty()) continue;
                Iterator<Map.Entry<UUID, BlockLocation>> relationIterator = anchor.getRelatedAnchors().entrySet().iterator();
                while (relationIterator.hasNext()) {
                    TileEntity relatedTile;
                    Map.Entry<UUID, BlockLocation> relation = relationIterator.next();
                    if (relation.getValue().dimID == this.ship.field_70170_p.field_73011_w.getDimension() && (relatedTile = this.ship.field_70170_p.func_175625_s(relation.getValue().pos)) != null && relatedTile instanceof TileAnchorPoint) {
                        TileAnchorPoint relatedAnchor = (TileAnchorPoint)relatedTile;
                        if (relatedAnchor.getInstance().getRelatedAnchors().containsKey(anchor.getIdentifier()) && relatedAnchor.getInstance().getType().equals((Object)AnchorInstance.InstanceType.FORLAND)) {
                            int collectiveDist;
                            int xDist = (int)Math.abs(Math.round(this.ship.field_70165_t) - (long)relatedAnchor.func_174877_v().func_177958_n());
                            int yDist = (int)Math.abs(Math.round(this.ship.field_70163_u) - (long)relatedAnchor.func_174877_v().func_177956_o());
                            int zDist = (int)Math.abs(Math.round(this.ship.field_70161_v) - (long)relatedAnchor.func_174877_v().func_177952_p());
                            if (xDist > radius || yDist > radius || zDist > radius || (collectiveDist = xDist + yDist + zDist) >= smallestOverallDistance) continue;
                            smallestOverallDistance = collectiveDist;
                            closest = new LocatedBlock(this.ship.func_130014_f_().func_180495_p(relatedTile.func_174877_v()), relatedTile, relatedTile.func_174877_v());
                            shipAnchor = anchorLB;
                            continue;
                        }
                        relatedAnchor.getInstance().setChanged(true);
                    }
                    relationIterator.remove();
                }
            }
        }
        return new ImmutablePair((Object)shipAnchor, (Object)closest);
    }

    public void updateEngines() {
        float ePower = 0.0f;
        if (this.engines != null) {
            for (ITileEngineModifier te : this.engines) {
                ePower += te.getPowerIncrement(this);
            }
        }
        if (!this.ship.field_70170_p.field_72995_K) {
            this.ship.func_184212_Q().func_187227_b(EntityShip.ENGINE_POWER, (Object)Float.valueOf(ePower));
        }
    }

    public boolean canFly() {
        return DavincisVesselsMod.INSTANCE.getNetworkConfig().getShared().enableAirShips && (float)this.getBalloonCount() >= (float)this.blockCount * DavincisVesselsMod.INSTANCE.getNetworkConfig().getShared().flyBalloonRatio || this.ship.areSubmerged();
    }

    public boolean canSubmerge() {
        if (!this.submerseFound) {
            FloodFiller floodFiller = new FloodFiller();
            LocatedBlockList filledBlocks = floodFiller.floodFillMobileChunk(this.ship.getMobileChunk());
            int filledBlockCount = filledBlocks.size();
            this.canSubmerge = false;
            if (DavincisVesselsMod.INSTANCE.getNetworkConfig().getShared().enableSubmersibles) {
                this.canSubmerge = (float)filledBlockCount < (float)this.nonAirBlockCount * DavincisVesselsMod.INSTANCE.getNetworkConfig().getShared().submersibleFillRatio;
            }
            this.submerseFound = true;
        }
        return this.canSubmerge;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public int getBalloonCount() {
        return this.balloonCount;
    }

    public ImmutableList<EntitySeat> getSeats() {
        return ImmutableList.copyOf(this.seats);
    }

    public void addSeat(EntitySeat entity) {
        if (entity != null && entity instanceof EntitySeat) {
            this.seats.add(entity);
        }
    }

    public boolean canMove() {
        return (Byte)this.ship.func_184212_Q().func_187225_a(EntityShip.HAS_ENGINES) == 1;
    }

    public List<ITileEngineModifier> getEngines() {
        return this.engines;
    }

    public boolean hasSeat(EntitySeat seat) {
        if (this.seats != null && !this.seats.isEmpty()) {
            return this.seats.contains((Object)seat);
        }
        return true;
    }

    public EntitySeat getAvailableSeat() {
        if (this.seats.stream().anyMatch(seat -> seat.func_184179_bs() == null)) {
            return this.seats.stream().filter(seat -> seat.func_184179_bs() == null).findFirst().get();
        }
        return null;
    }

    public boolean mountEntity(Entity player) {
        if (player.func_70093_af()) {
            return false;
        }
        if (this.ship.func_184207_aI()) {
            if (player instanceof EntityPlayer) {
                this.tryMountSeat((EntityPlayer)player);
            }
            return true;
        }
        if (!this.ship.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this.ship);
        }
        return true;
    }

    private void tryMountSeat(EntityPlayer player) {
        EntitySeat seat = this.getAvailableSeat();
        if (seat != null) {
            player.func_184220_m((Entity)seat);
        }
    }

    public void spawnSeatEntities() {
        if (this.seats != null) {
            this.seats.forEach(seat -> this.ship.field_70170_p.func_72838_d((Entity)seat));
        }
    }

    public void onChunkBlockAdded(IBlockState state, BlockPos pos) {
        Block block;
        this.mass += MaterialDensity.getDensity((IBlockState)state);
        ++this.blockCount;
        ++this.nonAirBlockCount;
        TileEntity tile = null;
        if (this.ship != null && this.ship.getMobileChunk() != null) {
            tile = this.ship.getMobileChunk().func_175625_s(pos);
        }
        if ((block = state.func_177230_c()) == null) {
            --this.nonAirBlockCount;
            return;
        }
        if (block instanceof BlockAir) {
            --this.nonAirBlockCount;
        }
        if (block instanceof IBlockCustomMass) {
            this.mass -= MaterialDensity.getDensity((IBlockState)state);
            this.mass += ((IBlockCustomMass)block).getCustomMass();
        }
        if (block instanceof IBlockBalloon) {
            this.balloonCount += ((IBlockBalloon)block).getBalloonWorth(tile);
        } else if (block == DavincisVesselsObjects.blockBalloon) {
            ++this.balloonCount;
        } else if (DavincisVesselsMod.INSTANCE.getNetworkConfig().isBalloon(block)) {
            ++this.balloonCount;
        } else if (block == DavincisVesselsObjects.blockFloater) {
            ++this.floaters;
        } else if (block == DavincisVesselsObjects.blockAnchorPoint) {
            TileEntity te = this.ship.getMobileChunk().func_175625_s(pos);
            if (te != null && te instanceof TileAnchorPoint && ((TileAnchorPoint)te).getInstance() != null && ((TileAnchorPoint)te).getInstance().getType().equals((Object)AnchorInstance.InstanceType.FORSHIP)) {
                if (this.anchorPoints == null) {
                    this.anchorPoints = new ArrayList<LocatedBlock>();
                }
                this.anchorPoints.add(new LocatedBlock(state, te, pos));
            }
        } else if (block == DavincisVesselsObjects.blockEngine) {
            TileEntity te = this.ship.getMobileChunk().func_175625_s(pos);
            if (te instanceof ITileEngineModifier) {
                if (this.engines == null) {
                    this.engines = new ArrayList<ITileEngineModifier>(4);
                }
                this.engines.add((ITileEngineModifier)te);
            }
        } else if (block == DavincisVesselsObjects.blockSeat || DavincisVesselsMod.INSTANCE.getNetworkConfig().isSeat(block)) {
            int x1 = this.ship.riderDestination.func_177958_n();
            int y1 = this.ship.riderDestination.func_177956_o();
            int z1 = this.ship.riderDestination.func_177952_p();
            int frontDir = this.ship.frontDirection.func_176736_b();
            if (frontDir == 0) {
                --z1;
            } else if (frontDir == 1) {
                ++x1;
            } else if (frontDir == 2) {
                ++z1;
            } else if (frontDir == 3) {
                --x1;
            }
            if (pos.func_177958_n() != x1 || pos.func_177956_o() != y1 || pos.func_177952_p() != z1) {
                EntitySeat seat = new EntitySeat(this.ship.field_70170_p);
                seat.setupShip(this.ship, pos);
                this.addSeat(seat);
            }
        }
    }

    public void postBlockAdding() {
        if (this.ship.getMobileChunk() != null && this.ship.getMobileChunk().marker != null && this.ship.getMobileChunk().marker.tileEntity != null && this.ship.getMobileChunk().marker.tileEntity instanceof TileHelm && ((TileHelm)this.ship.getMobileChunk().marker.tileEntity).submerge && this.canSubmerge()) {
            this.ship.setSubmerge(true);
        }
    }

    public void clearBlockCount() {
        this.liftMultiplier = 1.0f;
        this.rotationMultiplier = 1.0f;
        this.speedMultiplier = 1.0f;
        this.brakeMult = 0.9f;
        this.floaters = 0;
        this.blockCount = 0;
        this.mass = 0.0f;
        if (this.engines != null) {
            this.engines.clear();
            this.engines = null;
        }
    }

    public void clear() {
        if (this.seats != null) {
            this.seats.forEach(seat -> seat.func_70106_y());
            this.seats.clear();
        }
        if (this.engines != null) {
            this.engines.clear();
            this.engines = null;
        }
        this.submerseFound = false;
        this.canSubmerge = false;
        this.clearBlockCount();
    }

    public float getSpeedLimit() {
        return DavincisVesselsMod.INSTANCE.getNetworkConfig().getShared().speedLimit;
    }

    public float getBankingMultiplier() {
        return DavincisVesselsMod.INSTANCE.getNetworkConfig().getShared().bankingMultiplier;
    }
}

