/*
 * Decompiled with CFR 0.152.
 */
package com.golems.gui;

import com.golems.entity.EntityBedrockGolem;
import com.golems.entity.EntityRedstoneLampGolem;
import com.golems.entity.GolemBase;
import com.golems.util.GolemLookup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class GolemBookEntry {
    private final Block[] BLOCKS;
    private final String GOLEM_NAME;
    private ResourceLocation IMAGE = null;
    private final boolean MULTI_TEXTURE;
    private final boolean FIREPROOF;
    private final int HEALTH;
    private final float ATTACK;
    private final List<String> SPECIALS;

    public GolemBookEntry(@Nonnull GolemBase golem) {
        this.GOLEM_NAME = "entity." + EntityList.func_75621_b((Entity)golem) + ".name";
        this.MULTI_TEXTURE = golem.doesInteractChangeTexture() && !(golem instanceof EntityRedstoneLampGolem);
        this.FIREPROOF = golem.func_70045_F() && !(golem instanceof EntityBedrockGolem);
        this.HEALTH = (int)golem.func_110138_aP();
        this.ATTACK = (float)golem.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
        this.SPECIALS = golem.addSpecialDesc(new ArrayList<String>());
        this.BLOCKS = GolemLookup.getBuildingBlocks(((Object)((Object)golem)).getClass());
        String img = "golems:textures/gui/screenshots/".concat(EntityList.func_75621_b((Entity)golem).replaceFirst("golems.", "")).concat(".png");
        try {
            this.IMAGE = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(img)).func_177241_a();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getGolemName() {
        return GolemBookEntry.trans(this.GOLEM_NAME, new Object[0]);
    }

    public String getGolemNameRaw() {
        return this.GOLEM_NAME;
    }

    public boolean hasBlocks() {
        return this.BLOCKS != null && this.BLOCKS.length > 0;
    }

    public Block getBlock(int index) {
        return this.hasBlocks() ? this.BLOCKS[index % this.BLOCKS.length] : Blocks.field_150350_a;
    }

    public Block[] getBlocks() {
        return this.BLOCKS;
    }

    public float getAttack() {
        return this.ATTACK;
    }

    public int getDescriptionSize() {
        return this.SPECIALS.size();
    }

    public String getDescriptionPage() {
        return this.makePage();
    }

    public boolean hasImage() {
        return this.IMAGE != null;
    }

    @Nullable
    public ResourceLocation getImageResource() {
        return this.IMAGE;
    }

    private String makePage() {
        StringBuilder page = new StringBuilder();
        page.append("\n" + TextFormatting.GRAY + GolemBookEntry.trans("entitytip.health", new Object[0]) + ": " + TextFormatting.BLACK + this.HEALTH + TextFormatting.DARK_RED + " \u2764" + TextFormatting.BLACK);
        page.append("\n" + TextFormatting.GRAY + GolemBookEntry.trans("entitytip.attack", new Object[0]) + ": " + TextFormatting.BLACK + this.ATTACK + " \u2694\n");
        if (this.FIREPROOF) {
            page.append("\n" + TextFormatting.GOLD + GolemBookEntry.trans("entitytip.is_fireproof", new Object[0]));
        }
        if (this.MULTI_TEXTURE) {
            page.append("\n" + TextFormatting.BLUE + GolemBookEntry.trans("entitytip.click_change_texture", new Object[0]));
        }
        for (String s : this.SPECIALS) {
            page.append("\n" + s.replaceAll(TextFormatting.WHITE.toString(), TextFormatting.BLACK.toString()));
        }
        return page.toString();
    }

    protected static String trans(String s, Object ... strings) {
        return I18n.func_135052_a((String)s, (Object[])strings);
    }
}

