/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemMultiTextured;
import com.golems.main.Config;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public final class EntityWoolGolem
extends GolemMultiTextured {
    public static final String WOOL_PREFIX = "wool";
    public static final String[] coloredWoolTypes = new String[]{"black", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "silver", "cyan", "purple", "blue", "brown", "green", "red", "white"};
    private boolean secret = false;
    private byte[] iSecret = new byte[]{14, 1, 4, 5, 3, 11, 10, 2};

    public EntityWoolGolem(World world) {
        super(world, WOOL_PREFIX, coloredWoolTypes);
        this.setCanSwim(true);
        this.addHealItem(new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE), 0.75);
        this.addHealItem(new ItemStack(Items.field_151007_F), 0.1);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_130014_f_().func_72820_D() % 10L == 0L) {
            this.secret = Config.matchesSecret(this.func_95999_t());
            if (this.secret) {
                int index = (int)(this.func_130014_f_().func_72820_D() % Integer.MAX_VALUE / 10L) % this.iSecret.length;
                this.setTextureNum(this.iSecret[index]);
            }
        }
    }

    @Override
    public ItemStack getPickedResult(RayTraceResult target) {
        ItemStack woolStack = new ItemStack(Blocks.field_150325_L);
        woolStack.func_77964_b(this.getTextureNum() % (coloredWoolTypes.length + 1));
        return woolStack;
    }

    @Override
    public String getModId() {
        return "golems";
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187554_ai;
    }

    @Override
    public void setTextureNum(byte toSet, boolean updateInstantly) {
        toSet = (byte)(toSet % (byte)(coloredWoolTypes.length - 1));
        super.setTextureNum(toSet, updateInstantly);
    }

    @Override
    public void onBuilt(IBlockState body, IBlockState legs, IBlockState arm1, IBlockState arm2) {
        int meta = body.func_177230_c().func_176201_c(body) % this.getTextureArray().length;
        this.setTextureNum((byte)meta);
    }

    public ITextComponent func_145748_c_() {
        if (this.secret) {
            String name = EntityWoolGolem.getRainbowString(this.func_95999_t(), this.field_70173_aa / 2);
            return new TextComponentString(name);
        }
        return super.func_145748_c_();
    }

    private static String getRainbowString(String stringIn, long timeIn) {
        String in = TextFormatting.func_110646_a((String)stringIn);
        StringBuilder stringOut = new StringBuilder(stringIn.length() * 2);
        int time = (int)(timeIn % 0x3FFFFFFFL);
        TextFormatting[] colorChar = new TextFormatting[]{TextFormatting.RED, TextFormatting.GOLD, TextFormatting.YELLOW, TextFormatting.GREEN, TextFormatting.AQUA, TextFormatting.BLUE, TextFormatting.LIGHT_PURPLE, TextFormatting.DARK_PURPLE};
        int l = in.length();
        int cl = colorChar.length;
        for (int i = 0; i < l; ++i) {
            int meta = i + time;
            stringOut.append(colorChar[meta % cl] + "" + in.charAt(i));
        }
        return stringOut.toString();
    }
}

