/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.entity.ai.EntityAIPlaceRandomBlocksStrictly;
import com.golems.util.GolemConfigSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public final class EntityMelonGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Plant Flowers";
    public static final String FREQUENCY = "Flower Frequency";
    public static final String ALLOW_HEALING = "Allow Special: Random Healing";

    public EntityMelonGolem(World world) {
        super(world);
        this.setCanSwim(true);
        this.field_70714_bg.func_75776_a(2, this.makeFlowerAI());
        this.setLootTableLoc("golem_melon");
        this.addHealItem(new ItemStack(Items.field_151127_ba), 0.25);
        this.addHealItem(new ItemStack(Items.field_151060_bw), 0.35);
        this.addHealItem(new ItemStack(Items.field_151081_bc), 0.1);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityMelonGolem.makeTexture("golems", "golem_melon");
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187902_gb;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70146_Z.nextInt(450) == 0 && EntityMelonGolem.getConfig(this).getBoolean(ALLOW_HEALING)) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 20, 2));
        }
    }

    protected EntityAIBase makeFlowerAI() {
        GolemConfigSet cfg = EntityMelonGolem.getConfig(this);
        Block[] soils = new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150391_bh, Blocks.field_150458_ak};
        ArrayList<IBlockState> lFlowers = new ArrayList<IBlockState>();
        for (BlockFlower.EnumFlowerType enumFlowerType : BlockFlower.EnumFlowerType.values()) {
            lFlowers.add(enumFlowerType.func_176964_a().func_180346_a().func_176203_a(enumFlowerType.func_176968_b()));
        }
        for (BlockFlower.EnumFlowerType enumFlowerType : BlockTallGrass.EnumType.values()) {
            lFlowers.add(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)enumFlowerType));
        }
        IBlockState[] flowers = lFlowers.toArray(new IBlockState[lFlowers.size()]);
        int freq = cfg.getInt(FREQUENCY);
        boolean allowed = cfg.getBoolean(ALLOW_SPECIAL);
        return new EntityAIPlaceRandomBlocksStrictly((GolemBase)this, freq, flowers, soils, allowed);
    }

    @Override
    public List<String> addSpecialDesc(List<String> list) {
        if (EntityMelonGolem.getConfig(this).getBoolean(ALLOW_SPECIAL)) {
            list.add(TextFormatting.GREEN + EntityMelonGolem.trans("entitytip.plants_flowers", EntityMelonGolem.trans("tile.flower1.name", new Object[0])));
        }
        if (EntityMelonGolem.getConfig(this).getBoolean(ALLOW_HEALING)) {
            String sHeals = TextFormatting.RED + EntityMelonGolem.trans("entitytip.heals", new Object[0]);
            list.add(sHeals);
        }
        return list;
    }
}

