/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.container.ContainerDispenserGolem;
import com.golems.entity.GolemBase;
import com.golems.gui.GuiLoader;
import com.golems.util.GolemConfigSet;
import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;

public final class EntityDispenserGolem
extends GolemBase
implements IRangedAttackMob,
IInventoryChangedListener {
    public static final String ALLOW_SPECIAL = "Allow Special: Shoot Arrows";
    public static final String ARROW_DAMAGE = "Arrow Damage";
    public static final String ARROW_SPEED = "Arrow Speed";
    private static final String KEY_INVENTORY = "Items";
    private static final String KEY_SLOT = "Slot";
    private static final int INVENTORY_SIZE = 9;
    private static final Predicate ARROW_PREDICATE = new Predicate<EntityItem>(){

        public boolean apply(EntityItem i) {
            return i != null && i.func_92059_d() != null && !i.func_174874_s() && i.func_92059_d().func_77973_b() instanceof ItemArrow;
        }
    };
    private boolean allowArrows;
    private double arrowDamage;
    private int arrowSpeed;
    private InventoryBasic inventory;
    private final EntityAIAttackRanged aiArrowAttack;
    private final EntityAIAttackMelee aiMeleeAttack;

    public EntityDispenserGolem(World world) {
        super(world);
        this.setLootTableLoc("golem_dispenser");
        this.addHealItem(new ItemStack(Blocks.field_150347_e), 0.25);
        GolemConfigSet cfg = EntityDispenserGolem.getConfig(this);
        this.allowArrows = cfg.getBoolean(ALLOW_SPECIAL);
        this.arrowDamage = Math.max(0.0, (double)cfg.getFloat(ARROW_DAMAGE));
        this.arrowSpeed = cfg.getInt(ARROW_SPEED);
        this.aiArrowAttack = new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, this.arrowSpeed, 32.0f);
        this.aiMeleeAttack = new EntityAIAttackMelee((EntityCreature)this, 1.0, true);
        this.initInventory();
    }

    protected void func_184651_r() {
        super.func_184651_r();
    }

    protected void func_82167_n(Entity entityIn) {
        super.func_82167_n(entityIn);
        this.updateCombatTask(entityIn != null && this.func_70638_az() != null && entityIn == this.func_70638_az());
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            if (source.func_76346_g() instanceof EntityLivingBase) {
                this.func_70604_c((EntityLivingBase)source.func_76346_g());
            }
            return true;
        }
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 50 == 0) {
            boolean forceMelee = !this.allowArrows || this.func_70638_az() != null && this.func_70638_az().func_70068_e((Entity)this) < 3.5;
            this.updateCombatTask(forceMelee);
        }
        int frequency = 24;
        double range = 0.8;
        boolean gameRule = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
        if (this.func_70613_aW() && gameRule && this.field_70146_Z.nextInt(24) == 0) {
            List itemList = this.field_70170_p.func_175647_a(EntityItem.class, this.func_174813_aQ().func_72321_a(0.8, 0.0, 0.8), ARROW_PREDICATE);
            for (EntityItem i : itemList) {
                ItemStack item = i.func_92059_d().func_77946_l();
                ItemStack remainder = this.inventory.func_174894_a(item);
                i.func_92058_a(remainder);
            }
        }
    }

    @Override
    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!player.func_70093_af()) {
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).func_180468_a((IInteractionObject)new ContainerDispenserGolem.Provider((IInventory)this.inventory));
                player.func_184609_a(hand);
            } else {
                GuiLoader.loadDispenserGolemGui(player, (IInventory)this.inventory);
                player.func_184609_a(hand);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_82160_b(boolean recentlyHit, int lootingModifier) {
        super.func_82160_b(recentlyHit, lootingModifier);
        int l = this.inventory.func_70302_i_();
        for (int i = 0; i < l; ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            this.func_70099_a(stack.func_77946_l(), 0.5f);
            this.inventory.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagList list = tag.func_150295_c(KEY_INVENTORY, 10);
        this.initInventory();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound slotNBT = list.func_150305_b(i);
            int slotNum = slotNBT.func_74771_c(KEY_SLOT) & 0xFF;
            if (slotNum < 0 || slotNum >= this.inventory.func_70302_i_()) continue;
            this.inventory.func_70299_a(slotNum, new ItemStack(slotNBT));
        }
        this.func_76316_a((IInventory)this.inventory);
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagList listNBT = new NBTTagList();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound slotNBT = new NBTTagCompound();
            slotNBT.func_74774_a(KEY_SLOT, (byte)i);
            stack.func_77955_b(slotNBT);
            listNBT.func_74742_a((NBTBase)slotNBT);
        }
        tag.func_74782_a(KEY_INVENTORY, (NBTBase)listNBT);
    }

    private void initInventory() {
        InventoryBasic inv = this.inventory;
        this.inventory = new InventoryBasic(this.func_145748_c_().func_150254_d(), true, 9);
        if (inv != null) {
            inv.func_110132_b((IInventoryChangedListener)this);
            int i = Math.min(inv.func_70302_i_(), this.inventory.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inv.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.inventory.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.inventory.func_110134_a((IInventoryChangedListener)this);
        this.func_76316_a((IInventory)this.inventory);
    }

    public void func_76316_a(IInventory inv) {
        if (this.func_70613_aW()) {
            this.updateCombatTask();
        }
    }

    private static int findArrowIndex(IInventory inv) {
        int l = inv.func_70302_i_();
        for (int i = 0; i < l; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemArrow)) continue;
            return i;
        }
        return -1;
    }

    private static ItemStack findArrows(IInventory inv) {
        int slot = EntityDispenserGolem.findArrowIndex(inv);
        if (slot < 0 || slot > inv.func_70302_i_()) {
            return ItemStack.field_190927_a;
        }
        return inv.func_70301_a(slot);
    }

    private static int countArrows(IInventory inv) {
        if (inv == null) {
            return 0;
        }
        int arrowCount = 0;
        int l = inv.func_70302_i_();
        for (int i = 0; i < l; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemArrow)) continue;
            arrowCount += stack.func_190916_E();
        }
        return arrowCount;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        ItemStack itemstack;
        int slot = EntityDispenserGolem.findArrowIndex((IInventory)this.inventory);
        ItemStack itemStack = itemstack = slot < 0 ? ItemStack.field_190927_a : this.inventory.func_70301_a(slot);
        if (!itemstack.func_190926_b() && target != null && target.func_70089_S()) {
            EntitySpectralArrow arrow;
            boolean spectral;
            boolean bl = spectral = itemstack.func_77973_b() == Items.field_185166_h;
            if (spectral) {
                arrow = new EntitySpectralArrow(this.field_70170_p, (EntityLivingBase)this);
            } else {
                arrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
                ((EntityTippedArrow)arrow).func_184555_a(itemstack);
            }
            arrow.field_70163_u = this.field_70163_u + (double)(this.field_70131_O * 0.6f);
            double d0 = target.field_70165_t - this.field_70165_t;
            double d1 = target.func_174813_aQ().field_72338_b + (double)target.field_70131_O / 3.0 - arrow.field_70163_u;
            double d2 = target.field_70161_v - this.field_70161_v;
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            arrow.func_70239_b(this.arrowDamage + this.field_70146_Z.nextDouble() * 0.5);
            arrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
            arrow.func_70186_c(d0, d1 + d3 * 0.2, d2, 1.6f, 1.2f);
            this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70170_p.func_72838_d((Entity)arrow);
            itemstack.func_190918_g(1);
            this.inventory.func_70299_a(slot, itemstack);
            this.func_76316_a((IInventory)this.inventory);
        }
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public void updateCombatTask() {
        this.updateCombatTask(!this.allowArrows);
    }

    public void updateCombatTask(boolean forceMelee) {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiMeleeAttack);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
            ItemStack ammo = EntityDispenserGolem.findArrows((IInventory)this.inventory);
            if (forceMelee || ammo.func_190926_b()) {
                this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.aiMeleeAttack);
            } else {
                this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.aiArrowAttack);
            }
        }
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityDispenserGolem.makeTexture("golems", "golem_dispenser");
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187902_gb;
    }

    @Override
    public List<String> addSpecialDesc(List<String> list) {
        if (EntityDispenserGolem.getConfig(this).getBoolean(ALLOW_SPECIAL)) {
            list.add(TextFormatting.LIGHT_PURPLE + EntityDispenserGolem.trans("entitytip.shoots_arrows", new Object[0]));
            list.add(TextFormatting.GRAY + EntityDispenserGolem.trans("entitytip.click_refill", new Object[0]));
        }
        return list;
    }
}

