/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.blocks.ContainerPortableWorkbench;
import com.golems.entity.GolemBase;
import java.util.List;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;

public final class EntityCraftingGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Crafting";

    public EntityCraftingGolem(World world) {
        super(world);
        this.setLootTableLoc("golem_crafting");
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.29);
        this.addHealItem(new ItemStack(Blocks.field_150344_f, 1, Short.MAX_VALUE), 0.25);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityCraftingGolem.makeTexture("golems", "golem_crafting");
    }

    @Override
    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!player.field_70170_p.field_72995_K && itemstack.func_190926_b() && !player.func_70093_af()) {
            player.func_180468_a((IInteractionObject)new InterfaceCraftingGrid(player.field_70170_p, player.field_71081_bT));
            player.func_71029_a(StatList.field_188062_ab);
            player.func_184609_a(hand);
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187897_gY;
    }

    @Override
    public List<String> addSpecialDesc(List<String> list) {
        if (EntityCraftingGolem.getConfig(this).getBoolean(ALLOW_SPECIAL)) {
            list.add(TextFormatting.BLUE + EntityCraftingGolem.trans("entitytip.click_open_crafting", new Object[0]));
        }
        return list;
    }

    public static class InterfaceCraftingGrid
    extends BlockWorkbench.InterfaceCraftingTable {
        private final World world2;
        private final BlockPos position2;

        public InterfaceCraftingGrid(World worldIn, BlockPos pos) {
            super(worldIn, pos);
            this.world2 = worldIn;
            this.position2 = pos;
        }

        public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
            return new ContainerPortableWorkbench(playerInventory, this.world2, this.position2);
        }
    }
}

