/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.script.command.misc;

import com.google.gson.JsonPrimitive;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import me.superckl.api.biometweaker.event.BiomeTweakEvent;
import me.superckl.api.biometweaker.property.BiomePropertyManager;
import me.superckl.api.biometweaker.property.Property;
import me.superckl.api.biometweaker.property.PropertyHelper;
import me.superckl.api.biometweaker.script.AutoRegister;
import me.superckl.api.biometweaker.script.pack.BiomePackage;
import me.superckl.api.superscript.script.ScriptHandler;
import me.superckl.api.superscript.script.command.ScriptCommand;
import me.superckl.biometweaker.BiomeTweaker;
import me.superckl.biometweaker.script.object.BiomesScriptObject;
import me.superckl.biometweaker.script.object.TweakerScriptObject;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

@AutoRegister(classes={BiomesScriptObject.class, TweakerScriptObject.class}, name="set")
public class ScriptCommandSetBiomeProperty
extends ScriptCommand {
    private final BiomePackage pack;
    private final String key;
    private final JsonPrimitive value;
    private ScriptHandler handler;

    @Override
    public void perform() throws Exception {
        Iterator<Biome> it = this.pack.getIterator();
        while (it.hasNext()) {
            Biome gen = it.next();
            if (MinecraftForge.EVENT_BUS.post((Event)new BiomeTweakEvent.SetProperty(this, gen, this.key, this.value))) continue;
            Property<?> prop = BiomePropertyManager.findProperty(this.key.toLowerCase());
            if (prop == null) {
                throw new IllegalArgumentException("No property found for " + this.key);
            }
            PropertyHelper.setProperty(gen, prop, this.value, this.handler);
            BiomeTweaker.getInstance().onTweak(Biome.func_185362_a((Biome)gen));
        }
    }

    @Override
    public void setScriptHandler(ScriptHandler handler) {
        this.handler = handler;
    }

    @ConstructorProperties(value={"pack", "key", "value"})
    public ScriptCommandSetBiomeProperty(BiomePackage pack, String key, JsonPrimitive value) {
        this.pack = pack;
        this.key = key;
        this.value = value;
    }
}

