/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.script.command.generation;

import java.beans.ConstructorProperties;
import java.util.Iterator;
import me.superckl.api.biometweaker.block.BlockStateBuilder;
import me.superckl.api.biometweaker.event.BiomeTweakEvent;
import me.superckl.api.biometweaker.script.AutoRegister;
import me.superckl.api.biometweaker.script.pack.BiomePackage;
import me.superckl.api.superscript.script.command.ScriptCommand;
import me.superckl.biometweaker.BiomeTweaker;
import me.superckl.biometweaker.common.world.TweakWorldManager;
import me.superckl.biometweaker.common.world.gen.BlockReplacementManager;
import me.superckl.biometweaker.common.world.gen.ReplacementConstraints;
import me.superckl.biometweaker.script.object.BiomesScriptObject;
import me.superckl.biometweaker.script.object.TweakerScriptObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

@AutoRegister(classes={BiomesScriptObject.class, TweakerScriptObject.class}, name="registerGenBlockRep")
public class ScriptCommandRegisterBlockReplacement
extends ScriptCommand {
    private final BiomePackage pack;
    private final int weight;
    private final BlockStateBuilder<?> toReplace;
    private final ReplacementConstraints replaceWith;

    public ScriptCommandRegisterBlockReplacement(BiomePackage pack, BlockStateBuilder<?> block1, ReplacementConstraints block2) {
        this(pack, 1, block1, block2);
    }

    @Override
    public void perform() throws Exception {
        if (this.replaceWith == null || !this.replaceWith.hasBlock()) {
            throw new IllegalStateException("Cannot register block replacement with no block specified!");
        }
        Iterator<Biome> it = this.pack.getIterator();
        while (it.hasNext()) {
            Biome gen = it.next();
            if (MinecraftForge.EVENT_BUS.post((Event)new BiomeTweakEvent.RegisterGenBlockReplacement(this, this.weight, gen, this.toReplace, this.replaceWith))) continue;
            if (TweakWorldManager.getCurrentWorld() == null) {
                BlockReplacementManager.registerGlobalBlockReplacement(Biome.func_185362_a((Biome)gen), this.weight, this.toReplace.build(), this.replaceWith);
            } else {
                BlockReplacementManager.getManagerForWorld(TweakWorldManager.getCurrentWorld()).registerBlockReplacement(Biome.func_185362_a((Biome)gen), this.weight, (IBlockState)this.toReplace.build(), this.replaceWith);
            }
            BiomeTweaker.getInstance().onTweak(Biome.func_185362_a((Biome)gen));
        }
    }

    @ConstructorProperties(value={"pack", "weight", "toReplace", "replaceWith"})
    public ScriptCommandRegisterBlockReplacement(BiomePackage pack, int weight, BlockStateBuilder<?> toReplace, ReplacementConstraints replaceWith) {
        this.pack = pack;
        this.weight = weight;
        this.toReplace = toReplace;
        this.replaceWith = replaceWith;
    }
}

