/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.script.command.generation;

import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import me.superckl.api.biometweaker.block.BlockStateBuilder;
import me.superckl.api.biometweaker.event.BiomeTweakEvent;
import me.superckl.api.biometweaker.script.AutoRegister;
import me.superckl.api.biometweaker.script.pack.BiomePackage;
import me.superckl.api.superscript.script.command.ScriptCommand;
import me.superckl.api.superscript.util.BlockEquivalencePredicate;
import me.superckl.api.superscript.util.WarningHelper;
import me.superckl.biometweaker.BiomeTweaker;
import me.superckl.biometweaker.script.object.BiomesScriptObject;
import me.superckl.biometweaker.script.object.TweakerScriptObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ScriptCommandAddRemoveBiomeFlower
extends ScriptCommand {
    private static Field field;
    private final BiomePackage pack;
    private final boolean remove;
    private final BlockStateBuilder<?> block;
    private final int weight;

    @AutoRegister(classes={BiomesScriptObject.class, TweakerScriptObject.class}, name="removeFlower")
    public ScriptCommandAddRemoveBiomeFlower(BiomePackage pack, BlockStateBuilder<?> block) {
        this(pack, true, block, 0);
    }

    @AutoRegister(classes={BiomesScriptObject.class, TweakerScriptObject.class}, name="addFlower")
    @AutoRegister.ParameterOverride(exceptionKey="nonNegInt", parameterIndex=2)
    public ScriptCommandAddRemoveBiomeFlower(BiomePackage pack, BlockStateBuilder<?> block, int weight) {
        this(pack, false, block, weight);
    }

    @Override
    public void perform() throws Exception {
        if (this.remove) {
            if (field == null) {
                field = Biome.class.getDeclaredField("flowers");
                field.setAccessible(true);
            }
            Iterator<Biome> it = this.pack.getIterator();
            while (it.hasNext()) {
                Biome gen = it.next();
                if (MinecraftForge.EVENT_BUS.post((Event)new BiomeTweakEvent.RemoveFlower(this, gen, this.block))) continue;
                List flowers = (List)WarningHelper.uncheckedCast(field.get(gen));
                Iterator itF = flowers.iterator();
                BlockEquivalencePredicate predicate = new BlockEquivalencePredicate((IBlockState)this.block.build());
                while (itF.hasNext()) {
                    Biome.FlowerEntry entry = (Biome.FlowerEntry)itF.next();
                    if (!predicate.apply(entry.state)) continue;
                    itF.remove();
                }
                BiomeTweaker.getInstance().onTweak(Biome.func_185362_a((Biome)gen));
            }
        } else {
            Iterator<Biome> it = this.pack.getIterator();
            while (it.hasNext()) {
                Biome gen = it.next();
                if (MinecraftForge.EVENT_BUS.post((Event)new BiomeTweakEvent.AddFlower(this, gen, this.block, this.weight))) continue;
                gen.addFlower(this.block.build(), this.weight);
                BiomeTweaker.getInstance().onTweak(Biome.func_185362_a((Biome)gen));
            }
        }
    }

    @ConstructorProperties(value={"pack", "remove", "block", "weight"})
    private ScriptCommandAddRemoveBiomeFlower(BiomePackage pack, boolean remove, BlockStateBuilder<?> block, int weight) {
        this.pack = pack;
        this.remove = remove;
        this.block = block;
        this.weight = weight;
    }
}

