/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.common.world.gen;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import me.superckl.biometweaker.common.world.gen.BlockReplacementEntry;
import me.superckl.biometweaker.common.world.gen.BlockReplacementEntryList;
import me.superckl.biometweaker.common.world.gen.BlockReplacementManager;
import me.superckl.biometweaker.common.world.gen.PlacementStage;
import me.superckl.biometweaker.common.world.gen.ReplacementConstraints;
import me.superckl.biometweaker.util.LogHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;

public class BlockReplacer {
    public static void runReplacement(PlacementStage stage, World world, Random rand, ChunkPos pos, ChunkPrimer primer) {
        try {
            BlockReplacementManager manager = BlockReplacementManager.getManagerForWorld(world.field_73011_w.getDimension());
            if (!manager.hasReplacements(stage)) {
                return;
            }
            Chunk chunk = primer == null ? world.func_72964_e(pos.field_77276_a, pos.field_77275_b) : null;
            BlockPos.MutableBlockPos biomeCheckPos = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos blockSetPos = new BlockPos.MutableBlockPos();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Biome biomegenbase = world.func_180494_b((BlockPos)biomeCheckPos.func_181079_c((pos.field_77276_a << 4) + x, 0, (pos.field_77275_b << 4) + z));
                    int id = Biome.func_185362_a((Biome)biomegenbase);
                    if (!manager.hasReplacements(id, stage)) continue;
                    BlockReplacementEntryList list = manager.findReplacementEntryList(id, stage);
                    Set noReps = Sets.newIdentityHashSet();
                    int k1 = 256;
                    for (int y = 0; y < 256; ++y) {
                        IBlockState state;
                        IBlockState iBlockState = state = primer == null ? chunk.func_186032_a(x, y, z) : primer.func_177856_a(x, y, z);
                        if (noReps.contains(state)) continue;
                        Block block = state.func_177230_c();
                        BlockReplacementManager.WeightedBlockEntry toUse = null;
                        int meta = block.func_176201_c(state);
                        BlockReplacementEntry entry = list.findEntry(state);
                        if (entry != null) {
                            List<BlockReplacementManager.WeightedBlockEntry> entries = entry.findEntriesForMeta(meta);
                            if (entries == null || entries.isEmpty()) continue;
                            toUse = (BlockReplacementManager.WeightedBlockEntry)WeightedRandom.func_76271_a((Random)rand, entries);
                            if (!BlockReplacer.verifyBoundaries(pos, x, y, z, toUse.getConstraints())) {
                                ArrayList<BlockReplacementManager.WeightedBlockEntry> copy = new ArrayList<BlockReplacementManager.WeightedBlockEntry>(entries);
                                copy.remove((Object)toUse);
                                boolean isWholeChunk = BlockReplacer.isWholeChunk(pos, toUse.getConstraints(), world.func_72800_K());
                                toUse = null;
                                while (!copy.isEmpty() && !BlockReplacer.verifyBoundaries(pos, x, y, z, (toUse = (BlockReplacementManager.WeightedBlockEntry)WeightedRandom.func_76271_a((Random)rand, copy)).getConstraints())) {
                                    if (!BlockReplacer.isWholeChunk(pos, toUse.getConstraints(), world.func_72800_K())) {
                                        isWholeChunk = false;
                                    }
                                    copy.remove((Object)toUse);
                                    toUse = null;
                                }
                                if (toUse == null && isWholeChunk) {
                                    noReps.add(state);
                                }
                            }
                        }
                        if (toUse == null) continue;
                        if (primer != null) {
                            primer.func_177855_a(x, y, z, toUse.getConstraints().getState());
                            continue;
                        }
                        chunk.func_177436_a((BlockPos)blockSetPos.func_181079_c(x, y, z), toUse.getConstraints().getState());
                    }
                }
            }
        }
        catch (Exception e1) {
            LogHelper.error("Failed to process replace biome blocks event.");
            e1.printStackTrace();
        }
    }

    private static boolean verifyBoundaries(ChunkPos pos, int x, int y, int z, ReplacementConstraints constraints) {
        return y >= constraints.getMinY() && y <= constraints.getMaxY() && x >= constraints.getMinChunkX() && x <= constraints.getMaxChunkX() && z >= constraints.getMinChunkZ() && z <= constraints.getMaxChunkZ() && (pos.field_77276_a << 4) + x >= constraints.getMinX() && (pos.field_77276_a << 4) + x <= constraints.getMaxX() && (pos.field_77275_b << 4) + z >= constraints.getMinZ() && (pos.field_77275_b << 4) + z <= constraints.getMaxZ();
    }

    private static boolean isWholeChunk(ChunkPos pos, ReplacementConstraints constraints, int worldHeight) {
        return constraints.getMinY() <= 0 && constraints.getMaxY() >= worldHeight && constraints.getMinChunkX() <= 0 && constraints.getMaxChunkX() >= 15 && constraints.getMinChunkZ() <= 0 && constraints.getMaxChunkZ() >= 15 && constraints.getMinX() <= pos.field_77276_a << 4 && constraints.getMaxX() >= (pos.field_77276_a << 4) + 16 && constraints.getMinZ() <= pos.field_77275_b << 4 && constraints.getMaxZ() >= (pos.field_77275_b << 4) + 16;
    }
}

