/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.common.world.gen;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import me.superckl.biometweaker.common.world.gen.BlockReplacementEntryList;
import me.superckl.biometweaker.common.world.gen.PlacementStage;
import me.superckl.biometweaker.common.world.gen.ReplacementConstraints;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.WeightedRandom;

public class BlockReplacementManager {
    private static final TIntObjectMap<BlockReplacementManager> managers = new TIntObjectHashMap();
    private static PlacementStage defaultStage = PlacementStage.BIOME_BLOCKS;
    private static final Map<PlacementStage, TIntObjectMap<BlockReplacementEntryList>> globalBlockReplacements = new EnumMap<PlacementStage, TIntObjectMap<BlockReplacementEntryList>>(PlacementStage.class);
    private final Map<PlacementStage, TIntObjectMap<BlockReplacementEntryList>> blockReplacements = new EnumMap<PlacementStage, TIntObjectMap<BlockReplacementEntryList>>(PlacementStage.class);
    private static PlacementStage currentStage = defaultStage;

    public static BlockReplacementManager getManagerForWorld(int worldId) {
        BlockReplacementManager manager = (BlockReplacementManager)managers.get(worldId);
        if (manager == null) {
            manager = new BlockReplacementManager();
            managers.put(worldId, (Object)manager);
        }
        return manager;
    }

    public static boolean hasGlobalReplacements() {
        return !globalBlockReplacements.isEmpty();
    }

    public boolean hasReplacements() {
        return BlockReplacementManager.hasGlobalReplacements() || !this.blockReplacements.isEmpty();
    }

    public boolean hasReplacements(PlacementStage stage) {
        if (!this.hasReplacements()) {
            return false;
        }
        TIntObjectMap<BlockReplacementEntryList> entries = globalBlockReplacements.get((Object)stage);
        if (entries == null || entries.isEmpty()) {
            TIntObjectMap<BlockReplacementEntryList> localEntries = this.blockReplacements.get((Object)stage);
            return localEntries != null && !localEntries.isEmpty();
        }
        return entries != null && !entries.isEmpty();
    }

    public boolean hasReplacements(int biome, PlacementStage stage) {
        if (!this.hasReplacements()) {
            return false;
        }
        TIntObjectMap<BlockReplacementEntryList> entries = globalBlockReplacements.get((Object)stage);
        if (entries == null || !entries.containsKey(biome)) {
            TIntObjectMap<BlockReplacementEntryList> localEntries = this.blockReplacements.get((Object)stage);
            return localEntries != null && localEntries.containsKey(biome);
        }
        return entries != null && entries.containsKey(biome);
    }

    public void registerBlockReplacement(int biome, int weight, IBlockState toReplace, ReplacementConstraints replacement) {
        if (!this.blockReplacements.containsKey((Object)currentStage)) {
            this.blockReplacements.put(currentStage, (TIntObjectMap<BlockReplacementEntryList>)new TIntObjectHashMap());
        }
        if (!this.blockReplacements.get((Object)currentStage).containsKey(biome)) {
            this.blockReplacements.get((Object)currentStage).put(biome, (Object)new BlockReplacementEntryList());
        }
        ((BlockReplacementEntryList)this.blockReplacements.get((Object)currentStage).get(biome)).registerReplacement(weight, toReplace, replacement);
    }

    public static void registerGlobalBlockReplacement(int biome, int weight, IBlockState toReplace, ReplacementConstraints replacement) {
        if (!globalBlockReplacements.containsKey((Object)currentStage)) {
            globalBlockReplacements.put(currentStage, (TIntObjectMap<BlockReplacementEntryList>)new TIntObjectHashMap());
        }
        if (!globalBlockReplacements.get((Object)currentStage).containsKey(biome)) {
            globalBlockReplacements.get((Object)currentStage).put(biome, (Object)new BlockReplacementEntryList());
        }
        ((BlockReplacementEntryList)globalBlockReplacements.get((Object)currentStage).get(biome)).registerReplacement(weight, toReplace, replacement);
    }

    @Nullable
    public BlockReplacementEntryList findReplacementEntryList(int biome, PlacementStage stage) {
        TIntObjectMap<BlockReplacementEntryList> entryMap = this.blockReplacements.get((Object)stage);
        if (entryMap != null) {
            return (BlockReplacementEntryList)entryMap.get(biome);
        }
        entryMap = globalBlockReplacements.get((Object)stage);
        if (entryMap != null) {
            return (BlockReplacementEntryList)entryMap.get(biome);
        }
        return null;
    }

    public static PlacementStage getDefaultStage() {
        return defaultStage;
    }

    public static PlacementStage getCurrentStage() {
        return currentStage;
    }

    public static void setCurrentStage(PlacementStage currentStage) {
        BlockReplacementManager.currentStage = currentStage;
    }

    public static class WeightedBlockEntry
    extends WeightedRandom.Item {
        private final ReplacementConstraints constraints;

        public WeightedBlockEntry(int weight, ReplacementConstraints replacement) {
            super(weight);
            this.constraints = replacement;
        }

        public ReplacementConstraints getConstraints() {
            return this.constraints;
        }
    }
}

