/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import me.superckl.api.superscript.ApplicationStage;
import me.superckl.api.superscript.script.ScriptParser;
import me.superckl.api.superscript.script.command.BasicScriptCommandManager;
import me.superckl.api.superscript.script.command.ScriptCommand;
import me.superckl.api.superscript.script.command.ScriptCommandRegistry;
import me.superckl.biometweaker.config.Config;
import me.superckl.biometweaker.integration.IntegrationManager;
import me.superckl.biometweaker.proxy.SidedProxy;
import me.superckl.biometweaker.script.command.misc.ScriptCommandSetPlacementStage;
import me.superckl.biometweaker.script.command.misc.ScriptCommandSetWorld;
import me.superckl.biometweaker.server.command.CommandInfo;
import me.superckl.biometweaker.server.command.CommandListBiomes;
import me.superckl.biometweaker.server.command.CommandOutput;
import me.superckl.biometweaker.server.command.CommandReload;
import me.superckl.biometweaker.server.command.CommandReloadScript;
import me.superckl.biometweaker.server.command.CommandSetBiome;
import me.superckl.biometweaker.util.BiomeHelper;
import me.superckl.biometweaker.util.DimensionHelper;
import me.superckl.biometweaker.util.EntityHelper;
import me.superckl.biometweaker.util.LogHelper;
import net.minecraft.command.ICommand;
import net.minecraft.entity.EntityLiving;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Mod(modid="biometweaker", name="BiomeTweaker", version="3.2.354", guiFactory="me.superckl.biometweaker.client.gui.GuiFactory", acceptableRemoteVersions="*", certificateFingerprint="bdea6e9d19f35da4858ffcc93210c6207dd590bd", dependencies="before:biomesoplenty; after:biometweakercore", acceptedMinecraftVersions="[1.12.2]")
public class BiomeTweaker {
    @Mod.Instance(value="biometweaker")
    private static BiomeTweaker instance;
    private boolean signed = true;
    @net.minecraftforge.fml.common.SidedProxy(clientSide="me.superckl.biometweaker.proxy.ClientProxy", serverSide="me.superckl.biometweaker.proxy.ServerProxy")
    private static SidedProxy proxy;
    private Config config;
    private BasicScriptCommandManager commandManager;
    private final TIntSet tweakedBiomes = new TIntHashSet();
    private final Set<String> enabledTweaks = new HashSet<String>();

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent e) {
        this.signed = false;
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent e) {
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"BiomeTweaker PreInitialization", (int)6, (boolean)true);
        LogHelper.setLogger(e.getModLog());
        bar.step("Reading config");
        if (!this.signed) {
            LogHelper.warn("Hey... uhm... this is awkward but, it looks like you're using an unofficial version of BiomeTweaker. Where exactly did you get this from?");
            LogHelper.warn("Unless I (superckl) sent you this version, don't expect to get any support for it.");
        }
        this.config = new Config(new File(Loader.instance().getConfigDir(), "BiomeTweaker/"));
        this.config.loadValues();
        ImmutableList messages = FMLInterModComms.fetchRuntimeMessages((Object)"biometweaker");
        for (FMLInterModComms.IMCMessage message : messages) {
            if (!message.key.equals("enableTweak") || !message.isStringMessage()) continue;
            LogHelper.debug("Received enableTweak IMC message from " + message.getSender() + ", enabling tweak: " + message.getStringValue());
            this.enabledTweaks.add(message.getStringValue());
        }
        bar.step("Initializing scripting enviroment");
        File scripts = new File(this.config.getBtConfigFolder(), "scripts/");
        scripts.mkdirs();
        this.commandManager = new BasicScriptCommandManager();
        ScriptCommandRegistry.INSTANCE.registerScriptCommandManager("biometweaker", this.commandManager);
        proxy.initProperties();
        proxy.setupScripts(e.getAsmData());
        bar.step("Pre-Initializing Integration");
        IntegrationManager.INSTANCE.preInit();
        bar.step("Registering handlers");
        proxy.registerHandlers();
        bar.step("Parsing scripts");
        this.parseScripts();
        bar.step("Applying scripts");
        this.commandManager.applyCommandsFor(ApplicationStage.PRE_INIT);
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    public void parseScripts() {
        try {
            LogHelper.info("Beginning script parsing...");
            long diff = 0L;
            long time = System.currentTimeMillis();
            for (String item : this.config.getIncludes()) {
                File subFile = null;
                try {
                    subFile = new File(this.config.getBtConfigFolder(), item);
                    this.parseScript(subFile);
                }
                catch (Exception e1) {
                    LogHelper.error("Failed to parse a script file! File: " + subFile);
                    e1.printStackTrace();
                }
            }
            File scripts = new File(this.config.getBtConfigFolder(), "scripts/");
            for (File script : scripts.listFiles((dir, name) -> name.endsWith(".cfg"))) {
                try {
                    this.parseScript(script);
                }
                catch (Exception e1) {
                    LogHelper.error("Failed to parse a script file! File: " + script);
                    e1.printStackTrace();
                }
            }
            diff = System.currentTimeMillis() - time;
            LogHelper.info("Finished script parsing.");
            LogHelper.debug("Script parsing took " + diff + "ms.");
        }
        catch (Exception e) {
            throw new RuntimeException("An unexpected error occurred while processing script files. Parsing may be incomplete. Ensure BiomeTweakerCore was called successfully.", e);
        }
    }

    public void parseScript(File file) throws IOException {
        if (!file.exists()) {
            LogHelper.debug(String.format("Subfile %s not found. A blank one will be generated.", file.getName()));
            file.createNewFile();
        }
        ScriptParser.parseScriptFile(file);
        this.commandManager.addCommand(new ScriptCommandSetPlacementStage("BIOME_BLOCKS"));
        this.commandManager.addCommand(new ScriptCommandSetWorld(null));
        this.commandManager.setCurrentStage(BasicScriptCommandManager.getDefaultStage());
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent e) throws InterruptedException {
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"BiomeTweaker Initialization", (int)2, (boolean)true);
        bar.step("Initializing Integration");
        IntegrationManager.INSTANCE.init();
        bar.step("Applying scripts");
        this.commandManager.applyCommandsFor(ApplicationStage.INIT);
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent e) {
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"BiomeTweaker PostInitialization", (int)2, (boolean)true);
        bar.step("Post-Initializing Integration");
        IntegrationManager.INSTANCE.postInit();
        bar.step("Applying scripts");
        this.commandManager.applyCommandsFor(ApplicationStage.POST_INIT);
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    @Mod.EventHandler
    public void onLoadComplete(FMLLoadCompleteEvent e) throws IOException {
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"BiomeTweaker LoadComplete", (int)2, (boolean)true);
        bar.step("Applying scripts");
        this.commandManager.applyCommandsFor(ApplicationStage.FINISHED_LOAD);
        bar.step("Generating output files");
        this.generateOutputFiles();
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateOutputFiles() throws IOException {
        LogHelper.info("Generating Biome status report...");
        JsonArray array = new JsonArray();
        for (Biome gen : Biome.field_185377_q) {
            if (gen == null) continue;
            array.add((JsonElement)BiomeHelper.fillJsonObject(gen, new int[0]));
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File baseDir = new File(this.config.getBtConfigFolder(), "output/");
        File biomeDir = new File(baseDir, "/biome/");
        biomeDir.mkdirs();
        for (File file : biomeDir.listFiles()) {
            if (!file.getName().endsWith(".json")) continue;
            file.delete();
        }
        if (this.config.isOutputSeperateFiles()) {
            for (JsonElement element : array) {
                JsonObject obj = (JsonObject)element;
                StringBuilder fileName = new StringBuilder(obj.get("Name").getAsString().replaceAll("[^a-zA-Z0-9.-]", "_")).append(" (").append(obj.get("Resource Location").getAsString().replaceAll("[^a-zA-Z0-9.-]", "_")).append(")").append(".json");
                File biomeOutput = new File(biomeDir, fileName.toString());
                if (biomeOutput.exists()) {
                    biomeOutput.delete();
                }
                biomeOutput.createNewFile();
                BufferedWriter writer = new BufferedWriter(new FileWriter(biomeOutput));
                try {
                    writer.newLine();
                    writer.write(gson.toJson((JsonElement)obj));
                }
                finally {
                    if (Collections.singletonList(writer).get(0) == null) continue;
                    writer.close();
                }
            }
        } else {
            File biomeOutput = new File(biomeDir, "BiomeTweaker - Biome Status Report.json");
            if (biomeOutput.exists()) {
                biomeOutput.delete();
            }
            biomeOutput.createNewFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(biomeOutput));
            try {
                writer.write("//Yeah, it's a doozy.");
                writer.newLine();
                writer.write(gson.toJson((JsonElement)array));
            }
            finally {
                if (Collections.singletonList(writer).get(0) != null) {
                    writer.close();
                }
            }
        }
        LogHelper.info("Generating LivingEntity status report...");
        File entityDir = new File(baseDir, "/entity/");
        entityDir.mkdirs();
        for (File file : entityDir.listFiles()) {
            if (!file.getName().endsWith(".json")) continue;
            file.delete();
        }
        Iterator entityIt = ForgeRegistries.ENTITIES.getValuesCollection().iterator();
        JsonArray entityArray = new JsonArray();
        while (entityIt.hasNext()) {
            EntityEntry entry = (EntityEntry)entityIt.next();
            if (!EntityLiving.class.isAssignableFrom(entry.getEntityClass())) continue;
            entityArray.add((JsonElement)EntityHelper.populateObject(entry));
        }
        if (this.config.isOutputSeperateFiles()) {
            for (JsonElement ele : entityArray) {
                JsonObject obj = (JsonObject)ele;
                StringBuilder fileName = new StringBuilder(obj.get("Name").getAsString().replaceAll("[^a-zA-Z0-9.-]", "_")).append(" (").append(obj.get("Registry ID").getAsString().replaceAll("[^a-zA-Z0-9.-]", "_")).append(")").append(".json");
                File entityOutput = new File(entityDir, fileName.toString());
                if (entityOutput.exists()) {
                    entityOutput.delete();
                }
                entityOutput.createNewFile();
                BufferedWriter writer = new BufferedWriter(new FileWriter(entityOutput));
                try {
                    writer.newLine();
                    writer.write(gson.toJson((JsonElement)obj));
                }
                finally {
                    if (Collections.singletonList(writer).get(0) == null) continue;
                    writer.close();
                }
            }
        } else {
            File entityOutput = new File(entityDir, "BiomeTweaker - EntityLiving Status Report.json");
            if (entityOutput.exists()) {
                entityOutput.delete();
            }
            entityOutput.createNewFile();
            File[] writer = new BufferedWriter(new FileWriter(entityOutput));
            try {
                writer.write("//Yeah, it's a doozy.");
                writer.newLine();
                writer.write(gson.toJson((JsonElement)entityArray));
            }
            finally {
                if (Collections.singletonList(writer).get(0) != null) {
                    writer.close();
                }
            }
        }
        LogHelper.info("Generating Dimension status report...");
        File dimDir = new File(baseDir, "/dimension/");
        dimDir.mkdirs();
        for (File file : dimDir.listFiles()) {
            if (!file.getName().endsWith(".json")) continue;
            file.delete();
        }
        DimensionType[] dimTypes = DimensionType.values();
        JsonArray dimArray = new JsonArray();
        for (DimensionType dimType : dimTypes) {
            dimArray.add((JsonElement)DimensionHelper.populateObject(dimType));
        }
        if (this.config.isOutputSeperateFiles()) {
            for (JsonElement ele : dimArray) {
                JsonObject obj = (JsonObject)ele;
                StringBuilder fileName = new StringBuilder(obj.get("Name").getAsString().replaceAll("[^a-zA-Z0-9.-]", "_")).append(" (").append(obj.get("Suffix").getAsString().replaceAll("[^a-zA-Z0-9.-]", "_")).append(")").append(".json");
                File dimOutput = new File(dimDir, fileName.toString());
                if (dimOutput.exists()) {
                    dimOutput.delete();
                }
                dimOutput.createNewFile();
                BufferedWriter writer = new BufferedWriter(new FileWriter(dimOutput));
                try {
                    writer.newLine();
                    writer.write(gson.toJson((JsonElement)obj));
                }
                finally {
                    if (Collections.singletonList(writer).get(0) == null) continue;
                    writer.close();
                }
            }
        } else {
            File dimOutput = new File(entityDir, "BiomeTweaker - Dimension Status Report.json");
            if (dimOutput.exists()) {
                dimOutput.delete();
            }
            dimOutput.createNewFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(dimOutput));
            try {
                writer.write("//Yeah, it's a doozy.");
                writer.newLine();
                writer.write(gson.toJson((JsonElement)entityArray));
            }
            finally {
                if (Collections.singletonList(writer).get(0) != null) {
                    writer.close();
                }
            }
        }
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new CommandReload());
        e.registerServerCommand((ICommand)new CommandInfo());
        e.registerServerCommand((ICommand)new CommandOutput());
        e.registerServerCommand((ICommand)new CommandListBiomes());
        e.registerServerCommand((ICommand)new CommandSetBiome());
        e.registerServerCommand((ICommand)new CommandReloadScript());
        this.commandManager.applyCommandsFor(ApplicationStage.SERVER_STARTING);
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent e) {
        this.commandManager.applyCommandsFor(ApplicationStage.SERVER_STARTED);
    }

    public boolean isTweakEnabled(String tweak) {
        return this.enabledTweaks.contains(tweak);
    }

    public void addCommand(ScriptCommand command) {
        this.commandManager.addCommand(command);
    }

    public void onTweak(int biomeID) {
        this.tweakedBiomes.add(biomeID);
    }

    public Set<String> getEnabledTweaks() {
        return ImmutableSet.copyOf(this.enabledTweaks);
    }

    public static BiomeTweaker getInstance() {
        return instance;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public static SidedProxy getProxy() {
        return proxy;
    }

    public Config getConfig() {
        return this.config;
    }

    public BasicScriptCommandManager getCommandManager() {
        return this.commandManager;
    }

    public TIntSet getTweakedBiomes() {
        return this.tweakedBiomes;
    }
}

