/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus.common.bonusrequirements.setrequirement;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.fantasticsource.mctools.items.ItemFilter;
import com.fantasticsource.setbonus.client.ClientData;
import com.fantasticsource.setbonus.common.bonusrequirements.setrequirement.Equip;
import com.fantasticsource.setbonus.server.ServerData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;

public class SlotData {
    public ArrayList<Integer> slots = new ArrayList();
    public ArrayList<ItemFilter> involvedItems = new ArrayList();

    private SlotData() {
    }

    public static SlotData getInstance(String slotsAndEquipment, LinkedHashMap<String, ItemFilter> setdataEquipIDTracker, Side side) {
        SlotData result = new SlotData();
        String[] tokens = slotsAndEquipment.split("=");
        if (tokens.length != 2) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.wrongSlotArgCount", (Object[])new Object[]{slotsAndEquipment}));
            return null;
        }
        for (String slotString : tokens[0].split("[|]")) {
            if ((slotString = slotString.trim().toLowerCase()).equals("mainhand")) {
                result.slots.add(-1);
                continue;
            }
            if (slotString.equals("hotbar")) {
                for (int i = 0; i < 9; ++i) {
                    result.slots.add(i);
                }
                continue;
            }
            if (slotString.equals("inventory")) {
                for (int i = 9; i < 36; ++i) {
                    result.slots.add(i);
                }
                continue;
            }
            if (slotString.equals("feet")) {
                result.slots.add(36);
                continue;
            }
            if (slotString.equals("legs")) {
                result.slots.add(37);
                continue;
            }
            if (slotString.equals("chest")) {
                result.slots.add(38);
                continue;
            }
            if (slotString.equals("head")) {
                result.slots.add(39);
                continue;
            }
            if (slotString.equals("offhand")) {
                result.slots.add(40);
                continue;
            }
            if (slotString.equals("bauble_amulet")) {
                for (int i : BaubleType.AMULET.getValidSlots()) {
                    result.slots.add(-2147483647 + i);
                }
                continue;
            }
            if (slotString.equals("bauble_ring")) {
                for (int i : BaubleType.RING.getValidSlots()) {
                    result.slots.add(-2147483647 + i);
                }
                continue;
            }
            if (slotString.equals("bauble_belt")) {
                for (int i : BaubleType.BELT.getValidSlots()) {
                    result.slots.add(-2147483647 + i);
                }
                continue;
            }
            if (slotString.equals("bauble_head")) {
                for (int i : BaubleType.HEAD.getValidSlots()) {
                    result.slots.add(-2147483647 + i);
                }
                continue;
            }
            if (slotString.equals("bauble_body")) {
                for (int i : BaubleType.BODY.getValidSlots()) {
                    result.slots.add(-2147483647 + i);
                }
                continue;
            }
            if (slotString.equals("bauble_charm")) {
                for (int i : BaubleType.CHARM.getValidSlots()) {
                    result.slots.add(-2147483647 + i);
                }
                continue;
            }
            if (slotString.equals("bauble_trinket")) {
                for (int i : BaubleType.TRINKET.getValidSlots()) {
                    result.slots.add(-2147483647 + i);
                }
                continue;
            }
            try {
                result.slots.add(Integer.parseInt(slotString));
            }
            catch (NumberFormatException e) {
                System.err.println(I18n.func_74837_a((String)"setbonus.error.unknownSlot", (Object[])new Object[]{slotString, slotsAndEquipment}));
                return null;
            }
        }
        LinkedHashMap<String, Equip> equipment = side == Side.SERVER ? ServerData.equipment : ClientData.equipment;
        for (String equipString : tokens[1].split("[|]")) {
            Equip equip = equipment.get(equipString = equipString.trim());
            if (equip == null) {
                System.err.println(I18n.func_74837_a((String)"setbonus.error.slotBadEquipID", (Object[])new Object[]{equipString, slotsAndEquipment}));
                return null;
            }
            result.involvedItems.add(equip.filter);
            setdataEquipIDTracker.put(equipString, equip.filter);
        }
        return result;
    }

    public int equipped(EntityPlayer player, ArrayList<Integer> blocked) {
        for (int slot : this.slots) {
            if (slot == -1) {
                slot = player.field_71071_by.field_70461_c;
            }
            if (blocked.contains(slot)) continue;
            if (slot > -1) {
                InventoryPlayer inv = player.field_71071_by;
                for (ItemFilter filter : this.involvedItems) {
                    if (!filter.matches(inv.func_70301_a(slot))) continue;
                    return slot;
                }
                continue;
            }
            IBaublesItemHandler handler = BaublesApi.getBaublesHandler(player);
            for (ItemFilter filter : this.involvedItems) {
                if (!filter.matches(handler.getStackInSlot(slot - Integer.MIN_VALUE - 1))) continue;
                return slot;
            }
        }
        return Integer.MIN_VALUE;
    }
}

