/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus.common.bonuselements;

import com.fantasticsource.mctools.attributes.AttributeMods;
import com.fantasticsource.setbonus.client.ClientData;
import com.fantasticsource.setbonus.common.Bonus;
import com.fantasticsource.setbonus.common.bonuselements.ABonusElement;
import com.fantasticsource.setbonus.server.ServerData;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;

public class ModifierBonus
extends ABonusElement {
    private Multimap<String, AttributeModifier> modifiers = ArrayListMultimap.create();

    private ModifierBonus(String parsableBonusElement, Bonus bonus, ArrayList<AttributeModifier> modifiers) {
        super(parsableBonusElement, bonus);
        for (AttributeModifier modifier : modifiers) {
            this.modifiers.put((Object)modifier.func_111166_b(), (Object)modifier.func_111168_a(false));
        }
    }

    public static ModifierBonus getInstance(String parsableModifierBonus, Side side) {
        Bonus bonus;
        String[] tokens = parsableModifierBonus.split(",");
        if (tokens.length < 2) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.notEnoughAttribBonusArgs", (Object[])new Object[]{parsableModifierBonus}));
            return null;
        }
        Bonus bonus2 = bonus = side == Side.SERVER ? (Bonus)ServerData.bonuses.get(tokens[0].trim()) : (Bonus)ClientData.bonuses.get(tokens[0].trim());
        if (bonus == null) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.attribBonusIDNotFound", (Object[])new Object[]{tokens[0].trim(), parsableModifierBonus}));
            return null;
        }
        ArrayList modifiers = AttributeMods.parseMods((String[])Arrays.copyOfRange(tokens, 1, tokens.length));
        if (modifiers == null) {
            return null;
        }
        return new ModifierBonus(parsableModifierBonus, bonus, modifiers);
    }

    @Override
    public void activate(EntityPlayer player) {
        float hpRatio = player.func_110143_aJ() / player.func_110138_aP();
        player.func_110140_aT().func_111147_b(this.modifiers);
        if (hpRatio <= Float.MIN_VALUE) {
            hpRatio = 0.0f;
        } else if (hpRatio >= 1.0f) {
            hpRatio = 1.0f;
        }
        player.func_70606_j(hpRatio * player.func_110138_aP());
    }

    @Override
    public void deactivate(EntityPlayer player) {
        float hpRatio = player.func_110143_aJ() / player.func_110138_aP();
        player.func_110140_aT().func_111148_a(this.modifiers);
        if (hpRatio <= Float.MIN_VALUE) {
            hpRatio = 0.0f;
        } else if (hpRatio >= 1.0f) {
            hpRatio = 1.0f;
        }
        player.func_70606_j(hpRatio * player.func_110138_aP());
    }

    @Override
    public void updateActive(EntityPlayer player) {
    }
}

