/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus.common;

import com.fantasticsource.setbonus.client.ClientData;
import com.fantasticsource.setbonus.common.Bonus;
import com.fantasticsource.setbonus.common.bonuselements.ABonusElement;
import com.fantasticsource.setbonus.common.bonuselements.ModifierBonus;
import com.fantasticsource.setbonus.common.bonuselements.PotionBonus;
import com.fantasticsource.setbonus.config.SetBonusConfig;
import com.fantasticsource.setbonus.server.ServerBonus;
import com.fantasticsource.setbonus.server.ServerData;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class Network {
    public static final SimpleNetworkWrapper WRAPPER = NetworkRegistry.INSTANCE.newSimpleChannel("setbonus");
    private static int discriminator = 0;

    public static void init() {
        WRAPPER.registerMessage(ConfigPacketHandler.class, ConfigPacket.class, discriminator++, Side.CLIENT);
        WRAPPER.registerMessage(DiscoverBonusPacketHandler.class, DiscoverBonusPacket.class, discriminator++, Side.CLIENT);
    }

    public static void updateConfig(EntityPlayerMP player) {
        WRAPPER.sendTo((IMessage)new ConfigPacket(player), player);
        ServerBonus.updateBonuses(player, true);
    }

    public static class ConfigPacketHandler
    implements IMessageHandler<ConfigPacket, IMessage> {
        public IMessage onMessage(ConfigPacket packet, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft.func_71410_x().func_152344_a(() -> ClientData.update(packet));
            }
            return null;
        }
    }

    public static class ConfigPacket
    implements IMessage {
        public ArrayList<String> equipment = new ArrayList();
        public ArrayList<String> sets = new ArrayList();
        public ArrayList<String> bonuses = new ArrayList();
        public ArrayList<String> attributeMods = new ArrayList();
        public ArrayList<String> potions = new ArrayList();
        private EntityPlayerMP player;

        public ConfigPacket() {
        }

        private ConfigPacket(EntityPlayerMP player) {
            this.player = player;
        }

        public void toBytes(ByteBuf buf) {
            ArrayList<String> equipment = SetBonusConfig.serverSettings.getEquipment();
            buf.writeInt(equipment.size());
            for (String string : equipment) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)string);
            }
            ArrayList<String> sets = SetBonusConfig.serverSettings.getSets();
            buf.writeInt(sets.size());
            for (String string : sets) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)string);
            }
            for (ServerBonus bonus : ServerData.bonuses.values()) {
                if (bonus.discoveryMode != Bonus.MODE_GLOBALLY_KNOWN && !bonus.getBonusInstance((EntityPlayerMP)this.player).discovered) continue;
                this.bonuses.add(bonus.parsedString);
                for (ABonusElement element : bonus.bonusElements) {
                    if (element instanceof ModifierBonus) {
                        this.attributeMods.add(element.parsedString);
                        continue;
                    }
                    if (!(element instanceof PotionBonus)) continue;
                    this.potions.add(element.parsedString);
                }
            }
            buf.writeInt(this.bonuses.size());
            for (String string : this.bonuses) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)string);
            }
            buf.writeInt(this.attributeMods.size());
            for (String string : this.attributeMods) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)string);
            }
            buf.writeInt(this.potions.size());
            for (String string : this.potions) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)string);
            }
        }

        public void fromBytes(ByteBuf buf) {
            int i;
            for (i = buf.readInt(); i > 0; --i) {
                this.equipment.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
            for (i = buf.readInt(); i > 0; --i) {
                this.sets.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
            for (i = buf.readInt(); i > 0; --i) {
                this.bonuses.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
            for (i = buf.readInt(); i > 0; --i) {
                this.attributeMods.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
            for (i = buf.readInt(); i > 0; --i) {
                this.potions.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
        }
    }

    public static class DiscoverBonusPacketHandler
    implements IMessageHandler<DiscoverBonusPacket, IMessage> {
        public IMessage onMessage(DiscoverBonusPacket packet, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft.func_71410_x().func_152344_a(() -> ClientData.update(packet));
            }
            return null;
        }
    }

    public static class DiscoverBonusPacket
    implements IMessage {
        public String bonusString;
        public ArrayList<String> attributeMods = new ArrayList();
        public ArrayList<String> potions = new ArrayList();
        private ServerBonus bonus;

        public DiscoverBonusPacket() {
        }

        public DiscoverBonusPacket(ServerBonus bonus) {
            this.bonus = bonus;
        }

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.bonus.parsedString);
            ArrayList<String> attributeMods = new ArrayList<String>();
            ArrayList<String> potions = new ArrayList<String>();
            for (ABonusElement element : this.bonus.bonusElements) {
                if (element instanceof ModifierBonus) {
                    attributeMods.add(element.parsedString);
                    continue;
                }
                if (!(element instanceof PotionBonus)) continue;
                potions.add(element.parsedString);
            }
            buf.writeInt(attributeMods.size());
            for (String string : attributeMods) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)string);
            }
            buf.writeInt(potions.size());
            for (String string : potions) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)string);
            }
        }

        public void fromBytes(ByteBuf buf) {
            int i;
            this.bonusString = ByteBufUtils.readUTF8String((ByteBuf)buf);
            for (i = buf.readInt(); i > 0; --i) {
                this.attributeMods.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
            for (i = buf.readInt(); i > 0; --i) {
                this.potions.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
        }
    }
}

