/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus;

import com.fantasticsource.mctools.ClientTickTimer;
import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.ServerTickTimer;
import com.fantasticsource.setbonus.client.BonusScreen;
import com.fantasticsource.setbonus.client.ClientBonus;
import com.fantasticsource.setbonus.client.ClientData;
import com.fantasticsource.setbonus.client.TooltipRenderer;
import com.fantasticsource.setbonus.common.Commands;
import com.fantasticsource.setbonus.common.Network;
import com.fantasticsource.setbonus.config.ConfigHandler;
import com.fantasticsource.setbonus.server.ServerBonus;
import com.fantasticsource.setbonus.server.ServerData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="setbonus", name="Set Bonus", version="1.12.2.019", dependencies="required-after:fantasticlib@[1.12.2.030,)", acceptedMinecraftVersions="[1.12.2]")
public class SetBonus {
    public static final String MODID = "setbonus";
    public static final String NAME = "Set Bonus";
    public static final String VERSION = "1.12.2.019";
    public static final String CONFIG_VERSION = "1.12.2.009";

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        Network.init();
        MinecraftForge.EVENT_BUS.register(SetBonus.class);
        MinecraftForge.EVENT_BUS.register(ServerTickTimer.class);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register(ClientTickTimer.class);
            MinecraftForge.EVENT_BUS.register(TooltipRenderer.class);
            MinecraftForge.EVENT_BUS.register(BonusScreen.class);
        }
    }

    @Mod.EventHandler
    public static void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new Commands());
        ServerData.update();
    }

    @Mod.EventHandler
    public static void serverStop(FMLServerStoppingEvent event) {
        ServerBonus.dropAll();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void saveConfig(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void calcConfigs(ConfigChangedEvent.PostConfigChangedEvent event) {
        if (event.isWorldRunning()) {
            if (MCTools.hosting()) {
                ServerData.update();
                EntityPlayerSP localPlayer = Minecraft.func_71410_x().field_71439_g;
                World world = localPlayer.field_70170_p;
                for (EntityPlayer player : world.field_73010_i) {
                    if (player == localPlayer) continue;
                    Network.updateConfig((EntityPlayerMP)player);
                }
            }
        } else {
            ServerData.update();
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (event.side == Side.SERVER) {
                ServerBonus.updateBonuses((EntityPlayerMP)event.player);
            } else {
                EntityPlayer player = event.player;
                if (Minecraft.func_71410_x().field_71439_g == player) {
                    ClientBonus.updateBonuses(player);
                }
            }
        }
    }

    @SubscribeEvent
    public static void playerConnect(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            ServerBonus.loadDiscoveries(player);
            Network.updateConfig(player);
        }
    }

    @SubscribeEvent
    public static void playerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerBonus.clearMem(event.player);
    }

    @SubscribeEvent
    public static void disconnectFromServer(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        ClientData.clear();
    }

    static {
        ConfigHandler.init();
    }
}

