/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.util;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class Timer {
    public static final Timer INSTANCE = new Timer();
    private ConcurrentHashMap<Runnable, Integer> queue = new ConcurrentHashMap();

    @SubscribeEvent
    public void handleWorldTick(TickEvent.WorldTickEvent event) {
        if (this.queue.size() < 1) {
            return;
        }
        this.runNextQueueItem();
    }

    public void addScheduledTask(Runnable task) {
        this.addScheduledTask(task, 0);
    }

    public void addScheduledTask(Runnable task, int delay) {
        this.queue.put(task, delay);
    }

    private void runNextQueueItem() {
        Runnable nextRunnable = this.popRunQueue();
        if (nextRunnable != null) {
            nextRunnable.run();
        }
    }

    private Runnable popRunQueue() {
        Map.Entry<Runnable, Integer> next = null;
        Iterator<Map.Entry<Runnable, Integer>> iterator = this.queue.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<Runnable, Integer> n;
            next = n = iterator.next();
        }
        if (next == null) {
            return null;
        }
        if ((Integer)next.getValue() < 1) {
            this.queue.remove(next.getKey());
            return next.getKey();
        }
        next.setValue(next.getValue() - 1);
        return null;
    }
}

