/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.network.message;

import com.google.gson.Gson;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.QuestDelegator;
import net.torocraft.toroquest.gui.VillageLordGuiContainer;

public class MessageSetQuestInfo
implements IMessage {
    private QuestMessage questMessage;
    private String questMessageJson;
    private Province civ;
    private QuestData currentQuest;
    private QuestData nextQuest;

    public MessageSetQuestInfo() {
    }

    public MessageSetQuestInfo(Province civ, QuestData current, QuestData next) {
        this.civ = civ;
        this.currentQuest = current;
        this.nextQuest = next;
        this.createMessage();
        this.serializeData();
    }

    private void createMessage() {
        this.questMessage = new QuestMessage();
        this.questMessage.provinceName = this.civ.name;
        if (this.currentQuest != null) {
            QuestDelegator quest = new QuestDelegator(this.currentQuest);
            this.questMessage.questTitle = quest.getTitle();
            this.questMessage.questDescription = quest.getDescription();
            this.questMessage.accepted = true;
        } else {
            QuestDelegator quest = new QuestDelegator(this.nextQuest);
            this.questMessage.questTitle = quest.getTitle();
            this.questMessage.questDescription = quest.getDescription();
            this.questMessage.accepted = false;
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.questMessageJson = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.deserializeData();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.questMessageJson);
    }

    private void serializeData() {
        this.questMessageJson = this.questMessage != null ? new Gson().toJson((Object)this.questMessage, QuestMessage.class) : "";
    }

    private void deserializeData() {
        this.questMessage = (QuestMessage)new Gson().fromJson(this.questMessageJson, QuestMessage.class);
    }

    public static class QuestMessage {
        public String provinceName;
        public String questTitle;
        public String questDescription;
        public boolean accepted;
    }

    public static class Handler
    implements IMessageHandler<MessageSetQuestInfo, IMessage> {
        public IMessage onMessage(final MessageSetQuestInfo message, MessageContext ctx) {
            if (ctx.side != Side.CLIENT) {
                return null;
            }
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    new Worker().work(message);
                }
            });
            return null;
        }
    }

    public static class Worker {
        public void work(MessageSetQuestInfo message) {
            Minecraft minecraft = Minecraft.func_71410_x();
            EntityPlayerSP player = minecraft.field_71439_g;
            if (player == null) {
                return;
            }
            VillageLordGuiContainer.setProvinceName(((MessageSetQuestInfo)message).questMessage.provinceName);
            VillageLordGuiContainer.setQuestData(((MessageSetQuestInfo)message).questMessage.questTitle, ((MessageSetQuestInfo)message).questMessage.questDescription, ((MessageSetQuestInfo)message).questMessage.accepted);
        }
    }
}

