/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.item.armor;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.torocraft.toroquest.material.ArmorMaterials;

@Mod.EventBusSubscriber
public class ItemRoyalArmor
extends ItemArmor {
    public static final String NAME = "royal";
    public static ItemRoyalArmor helmetItem;
    public static ItemRoyalArmor chestplateItem;
    public static ItemRoyalArmor leggingsItem;
    public static ItemRoyalArmor bootsItem;

    @SubscribeEvent
    public static void init(RegistryEvent.Register<Item> event) {
        bootsItem = new ItemRoyalArmor("royal_boots", 1, EntityEquipmentSlot.FEET);
        leggingsItem = new ItemRoyalArmor("royal_leggings", 2, EntityEquipmentSlot.LEGS);
        helmetItem = new ItemRoyalArmor("royal_helmet", 1, EntityEquipmentSlot.HEAD);
        chestplateItem = new ItemRoyalArmor("royal_chestplate", 1, EntityEquipmentSlot.CHEST);
        bootsItem.setRegistryName(new ResourceLocation("toroquest", "royal_boots"));
        event.getRegistry().register((IForgeRegistryEntry)bootsItem);
        leggingsItem.setRegistryName(new ResourceLocation("toroquest", "royal_leggings"));
        event.getRegistry().register((IForgeRegistryEntry)leggingsItem);
        helmetItem.setRegistryName(new ResourceLocation("toroquest", "royal_helmet"));
        event.getRegistry().register((IForgeRegistryEntry)helmetItem);
        chestplateItem.setRegistryName(new ResourceLocation("toroquest", "royal_chestplate"));
        event.getRegistry().register((IForgeRegistryEntry)chestplateItem);
    }

    public static void registerRenders() {
        ItemRoyalArmor.registerRendersHelmet();
        ItemRoyalArmor.registerRendersChestPlate();
        ItemRoyalArmor.registerRendersLeggings();
        ItemRoyalArmor.registerRendersBoots();
    }

    private static void registerRendersBoots() {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)bootsItem, 0, ItemRoyalArmor.model("boots"));
    }

    private static void registerRendersLeggings() {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)leggingsItem, 0, ItemRoyalArmor.model("leggings"));
    }

    private static void registerRendersHelmet() {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)helmetItem, 0, ItemRoyalArmor.model("helmet"));
    }

    private static void registerRendersChestPlate() {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)chestplateItem, 0, ItemRoyalArmor.model("chestplate"));
    }

    private static ModelResourceLocation model(String model) {
        return new ModelResourceLocation("toroquest:royal_" + model, "inventory");
    }

    public ItemRoyalArmor(String unlocalizedName, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(ArmorMaterials.ROYAL, renderIndexIn, equipmentSlotIn);
        this.func_77655_b(unlocalizedName);
        this.func_77656_e(8588);
    }
}

