/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.generation.village.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.torocraft.toroquest.block.BlockToroSpawner;
import net.torocraft.toroquest.block.TileEntityToroSpawner;
import net.torocraft.toroquest.generation.village.util.BlockMapBuilder;

public abstract class VillagePieceBlockMap
extends StructureVillagePieces.Village {
    public static final Map<String, IBlockState> DEFAULT_PALLETTE = new HashMap<String, IBlockState>();
    protected String name;

    public VillagePieceBlockMap(String name, StructureVillagePieces.Start start, int type, Random rand, StructureBoundingBox bounds, EnumFacing facing) {
        super(start, type);
        this.name = name;
        this.func_186164_a(facing);
        this.field_74887_e = bounds;
    }

    public VillagePieceBlockMap() {
    }

    protected boolean specialBlockHandling(World world, String c, int x, int y, int z) {
        return false;
    }

    protected int getYOffset() {
        return 0;
    }

    protected boolean specialHandlingForSpawner(World world, String entityBlockCode, String c, int x, int y, int z, List<String> entities) {
        if (!c.equals(entityBlockCode)) {
            return false;
        }
        BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
        if (this.field_74887_e.func_175898_b((Vec3i)blockpos)) {
            this.addToroSpawner(world, blockpos, entities);
        }
        return true;
    }

    protected void addToroSpawner(World world, BlockPos blockpos, List<String> entities) {
        world.func_175656_a(blockpos, BlockToroSpawner.INSTANCE.func_176223_P());
        TileEntity tileentity = world.func_175625_s(blockpos);
        if (tileentity instanceof TileEntityToroSpawner) {
            ((TileEntityToroSpawner)tileentity).setTriggerDistance(80);
            ((TileEntityToroSpawner)tileentity).setEntityIds(entities);
        }
    }

    public boolean func_74875_a(final World world, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
        if (this.field_143015_k < 0) {
            this.field_143015_k = this.func_74889_b(world, structureBoundingBoxIn);
            if (this.field_143015_k < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + this.field_74887_e.func_78882_c() - 1 + this.getYOffset(), 0);
        }
        Map<String, IBlockState> palette = this.getBiomeSpecificPalette();
        new BlockMapBuilder(this.name){

            @Override
            protected void setBlockState(IBlockState block, int x, int y, int z) {
                VillagePieceBlockMap.this.func_175811_a(world, block, x, y, z, VillagePieceBlockMap.this.field_74887_e);
            }

            @Override
            protected void replaceAirAndLiquidDownwards(IBlockState block, int x, int y, int z) {
                VillagePieceBlockMap.this.func_175808_b(world, block, x, y, z, VillagePieceBlockMap.this.field_74887_e);
            }

            @Override
            protected boolean specialBlockHandling(String c, int x, int y, int z) {
                return VillagePieceBlockMap.this.specialBlockHandling(world, c, x, y, z);
            }
        }.build(palette);
        return true;
    }

    private Map<String, IBlockState> getBiomeSpecificPalette() {
        HashMap<String, IBlockState> palette = new HashMap<String, IBlockState>();
        palette.putAll(DEFAULT_PALLETTE);
        this.alterPalette(palette);
        for (Map.Entry entry : palette.entrySet()) {
            entry.setValue(this.func_175847_a((IBlockState)entry.getValue()));
        }
        return palette;
    }

    protected IBlockState func_175847_a(IBlockState in) {
        if ((in = super.func_175847_a(in)).func_177230_c() instanceof BlockDoor) {
            in = this.biomeSpecificDoor(in);
        }
        return in;
    }

    protected IBlockState biomeSpecificDoor(IBlockState in) {
        BlockDoor newBlock;
        switch (this.field_189928_h) {
            case 2: {
                newBlock = Blocks.field_180410_as;
                break;
            }
            case 3: {
                newBlock = Blocks.field_180414_ap;
                break;
            }
            default: {
                newBlock = Blocks.field_180413_ao;
            }
        }
        return newBlock.func_176223_P().func_177226_a((IProperty)BlockBed.field_185512_D, in.func_177229_b((IProperty)BlockDoor.field_176520_a));
    }

    protected abstract void alterPalette(Map<String, IBlockState> var1);

    protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
        return 1;
    }

    static {
        DEFAULT_PALLETTE.put("--", Blocks.field_150350_a.func_176223_P());
        DEFAULT_PALLETTE.put("Cs", Blocks.field_150347_e.func_176223_P());
        DEFAULT_PALLETTE.put("Wa", Blocks.field_150355_j.func_176223_P());
        DEFAULT_PALLETTE.put("Dr", Blocks.field_150346_d.func_176223_P());
        DEFAULT_PALLETTE.put("Sb", Blocks.field_150417_aV.func_176223_P());
        DEFAULT_PALLETTE.put("So", Blocks.field_150348_b.func_176223_P());
        DEFAULT_PALLETTE.put("Pw", Blocks.field_150344_f.func_176223_P());
        DEFAULT_PALLETTE.put("Fw", Blocks.field_180407_aO.func_176223_P());
        DEFAULT_PALLETTE.put("Sw", Blocks.field_150376_bx.func_176223_P());
        DEFAULT_PALLETTE.put("Wp", Blocks.field_150452_aw.func_176223_P());
        DEFAULT_PALLETTE.put("Lg", Blocks.field_150364_r.func_176223_P());
        DEFAULT_PALLETTE.put("l^", Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
        DEFAULT_PALLETTE.put("lv", Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
        DEFAULT_PALLETTE.put("l<", Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
        DEFAULT_PALLETTE.put("l>", Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
        DEFAULT_PALLETTE.put("Ss", Blocks.field_150333_U.func_176223_P());
        DEFAULT_PALLETTE.put("Gp", Blocks.field_150410_aZ.func_176223_P());
        DEFAULT_PALLETTE.put("Gs", Blocks.field_150426_aN.func_176223_P());
        DEFAULT_PALLETTE.put("Sv", Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
        DEFAULT_PALLETTE.put("S^", Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
        DEFAULT_PALLETTE.put("S>", Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
        DEFAULT_PALLETTE.put("S<", Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
        DEFAULT_PALLETTE.put("bv", Blocks.field_150324_C.func_176223_P().func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)EnumFacing.NORTH));
        DEFAULT_PALLETTE.put("b^", Blocks.field_150324_C.func_176223_P().func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)EnumFacing.SOUTH));
        DEFAULT_PALLETTE.put("b>", Blocks.field_150324_C.func_176223_P().func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)EnumFacing.EAST));
        DEFAULT_PALLETTE.put("b<", Blocks.field_150324_C.func_176223_P().func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)EnumFacing.WEST));
        DEFAULT_PALLETTE.put("dv", Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)EnumFacing.NORTH));
        DEFAULT_PALLETTE.put("d^", Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)EnumFacing.SOUTH));
        DEFAULT_PALLETTE.put("d>", Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)EnumFacing.EAST));
        DEFAULT_PALLETTE.put("d<", Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)EnumFacing.WEST));
        DEFAULT_PALLETTE.put("cv", Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.NORTH));
        DEFAULT_PALLETTE.put("c^", Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.SOUTH));
        DEFAULT_PALLETTE.put("c>", Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.EAST));
        DEFAULT_PALLETTE.put("c<", Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.WEST));
        DEFAULT_PALLETTE.put("tv", Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.NORTH));
        DEFAULT_PALLETTE.put("t^", Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH));
        DEFAULT_PALLETTE.put("t>", Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.EAST));
        DEFAULT_PALLETTE.put("t<", Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.WEST));
        DEFAULT_PALLETTE.put("t.", Blocks.field_150478_aa.func_176223_P());
    }
}

