/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.generation;

import java.util.Random;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.torocraft.toroquest.entities.EntityRainbowGuard;
import net.torocraft.toroquest.entities.EntityRainbowKing;

public class ThroneRoomGenerator
extends WorldGenerator {
    protected final IBlockState stone = Blocks.field_150348_b.func_176223_P();
    protected final IBlockState stoneBrickSlabs = Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.SMOOTHBRICK);
    protected final IBlockState stoneBrick = Blocks.field_150417_aV.func_176223_P();
    protected final IBlockState torch = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.UP);
    protected final IBlockState air = Blocks.field_150350_a.func_176223_P();
    protected final IBlockState goldBlock = Blocks.field_150340_R.func_176223_P();
    protected final IBlockState redstoneBlock = Blocks.field_150451_bX.func_176223_P();
    protected final IBlockState lava = Blocks.field_150356_k.func_176223_P();
    protected final IBlockState redCarpet = Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockCarpet.field_176330_a, (Comparable)EnumDyeColor.RED);
    protected final IBlockState stoneBrickStairsN = Blocks.field_150390_bg.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
    protected final IBlockState stoneBrickStairsS = Blocks.field_150390_bg.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
    protected final IBlockState stoneBrickStairsE = Blocks.field_150390_bg.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
    protected final IBlockState stoneBrickStairsW = Blocks.field_150390_bg.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST);
    protected final IBlockState oakFence = Blocks.field_180407_aO.func_176223_P();
    private int width = 30;
    private int length = 85;
    private int height = 16;
    private World world;
    private BlockPos origin;
    private Random rand;

    public boolean func_180709_b(World worldIn, Random rand, BlockPos origin) {
        this.world = worldIn;
        this.origin = origin;
        this.rand = rand;
        this.buildThroneRoom(worldIn, rand, origin);
        this.spawnKing();
        this.spawnRainbowGuards();
        return true;
    }

    private void buildThroneRoom(World world, Random rand, BlockPos startPos) {
        for (int y = 0; y <= this.height; ++y) {
            for (int x = 0; x <= this.width; ++x) {
                for (int z = 0; z <= this.length; ++z) {
                    IBlockState currentBlock = this.air;
                    if (this.isWallOrFloor(y, x, z)) {
                        currentBlock = this.stone;
                    }
                    if (this.isEntranceStoneBrick(y, x, z)) {
                        currentBlock = this.stoneBrick;
                    }
                    if (this.isEntranceOpening(y, x, z)) {
                        currentBlock = this.air;
                    }
                    if (this.isEntranceTorchHolder(y, x, z)) {
                        currentBlock = this.oakFence;
                    }
                    if (this.isEntranceTorch(y, x, z)) {
                        currentBlock = this.torch;
                    }
                    if (z == 0 && y == 7 && x == 13) {
                        currentBlock = this.stoneBrickStairsW.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
                    }
                    if (z == 0 && y == 7 && x == 17) {
                        currentBlock = this.stoneBrickStairsE.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
                    }
                    if (this.isLavaLampSourceOrDest(y, x, z)) {
                        currentBlock = y == 0 ? this.air : this.lava;
                    }
                    if (this.isInTorchGrid(y, x, z)) {
                        currentBlock = this.torch;
                    }
                    if (this.isAisleCarpet(y, x, z) || this.isThroneCarpet(y, x, z) || this.isEntranceCarpet(y, x, z)) {
                        currentBlock = this.redCarpet;
                    }
                    if (this.isAisleEdging(y, x, z)) {
                        currentBlock = this.stoneBrickSlabs;
                    }
                    if (this.isAisleEdging(y, x, z) && this.isAisleTorch(z)) {
                        currentBlock = this.stoneBrick;
                    }
                    if (y == 2 && (x == 13 || x == 17) && this.isAisleTorch(z)) {
                        currentBlock = this.torch;
                    }
                    if (this.isEntrancePlatform(y, x, z)) {
                        currentBlock = this.stone;
                    }
                    if (this.isEntranceStairsEast(y, x, z)) {
                        currentBlock = this.stoneBrickStairsE;
                    }
                    if (this.isEntranceStairsWest(y, x, z)) {
                        currentBlock = this.stoneBrickStairsW;
                    }
                    if (this.isEntranceStairsNorth(y, x, z)) {
                        currentBlock = this.stoneBrickStairsN;
                    }
                    if (this.isThronePlatform(y, x, z)) {
                        currentBlock = this.stone;
                    }
                    if (this.isThroneArms(y, x, z)) {
                        currentBlock = this.goldBlock;
                    }
                    if (this.isBackOfThrone(y, x, z)) {
                        currentBlock = this.redstoneBlock;
                    }
                    if (this.isThroneTorch(y, x, z) || this.isEntrancePlatformTorch(y, x, z)) {
                        currentBlock = this.torch;
                    }
                    if (this.isThroneStairsNorth(y, x, z)) {
                        currentBlock = this.stoneBrickStairsN;
                    }
                    if (this.isThroneStairsEast(y, x, z)) {
                        currentBlock = this.stoneBrickStairsE;
                    }
                    if (this.isThroneStairsWest(y, x, z)) {
                        currentBlock = this.stoneBrickStairsW;
                    }
                    if (this.isThroneStairsSouth(y, x, z)) {
                        currentBlock = this.stoneBrickStairsS;
                    }
                    if (this.isThroneSideLavaDitch(y, x, z)) {
                        currentBlock = this.air;
                    }
                    if (this.isThroneSideLavaFlow(y, x, z) || this.isEntranceLavaFlow(y, x, z)) {
                        currentBlock = this.lava;
                    }
                    if (this.isEntranceLavaCatcherRight(y, x, z) || this.isEntranceLavaCatcherLeft(y, x, z)) {
                        currentBlock = this.stoneBrickStairsN.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
                    }
                    if (this.isEntranceLavaCatcherCornerEast(y, x, z)) {
                        currentBlock = this.stoneBrickStairsE.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
                    }
                    if (this.isEntranceLavaCatcherCornerWest(y, x, z)) {
                        currentBlock = this.stoneBrickStairsW.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
                    }
                    this.func_175903_a(world, startPos.func_177982_a(x, y, z), currentBlock);
                }
            }
        }
    }

    private boolean isAisleEdging(int y, int x, int z) {
        return y == 1 && (x == 13 || x == 17) && z != 0 && z != this.length;
    }

    private boolean isAisleCarpet(int y, int x, int z) {
        return y == 1 && x > 13 && x < 17 && z != 0 && z != this.length;
    }

    private boolean isInTorchGrid(int y, int x, int z) {
        return y == 1 && (x == 2 || x == 8 || x == this.width - 2 || x == this.width - 8) && (z - 2) % 6 == 0;
    }

    private boolean isEntranceTorch(int y, int x, int z) {
        return z == 0 && y == 6 && (x == 13 || x == 17);
    }

    private boolean isEntranceTorchHolder(int y, int x, int z) {
        return z == 0 && y == 5 && (x == 13 || x == 17);
    }

    private boolean isWallOrFloor(int y, int x, int z) {
        return x == 0 || x == this.width || y == 0 || y == this.height || z == 0 || z == this.length;
    }

    private boolean isEntranceStoneBrick(int y, int x, int z) {
        return z == 0 && (y == 3 || y == 8) & x >= 12 && x <= 18 || z == 0 && (x == 12 || x == 18) && y >= 4 && y <= 7 || z == 0 && (x == 13 || x == 17) && y == 4;
    }

    private boolean isEntranceOpening(int y, int x, int z) {
        return z == 0 && y >= 4 && y <= 7 && x >= 14 && x <= 16;
    }

    private boolean isLavaLampSourceOrDest(int y, int x, int z) {
        return !(y != 0 && y != this.height || x != 5 && x != this.width - 5 || z != 15 && z != 34 && z != 52 && z != 70);
    }

    private boolean isThroneStairsSouth(int y, int x, int z) {
        return y == 1 && z == this.length - 10 && x >= 12 && x <= 18 || y == 2 && z == this.length - 9 && x >= 13 && x <= 17 || y == 3 && z == this.length - 8 && x >= 14 && x <= 16 || y == 4 && z == this.length - 5 && x >= 14 && x <= 16 || y == 5 && z == this.length - 4 && x >= 14 && x <= 16;
    }

    private boolean isThroneStairsWest(int y, int x, int z) {
        return y == 1 && x == 19 && z <= this.length - 6 && z >= this.length - 10 || y == 2 && x == 18 && z <= this.length - 7 && z >= this.length - 9 || y == 3 && x == 17 && z <= this.length - 7 && z >= this.length - 8;
    }

    private boolean isThroneStairsEast(int y, int x, int z) {
        return y == 1 && x == 11 && z <= this.length - 6 && z >= this.length - 10 || y == 2 && x == 12 && z <= this.length - 7 && z >= this.length - 9 || y == 3 && x == 13 && z <= this.length - 7 && z >= this.length - 8;
    }

    private boolean isThroneStairsNorth(int y, int x, int z) {
        return y == 1 && (x == 11 || x == 12 || x == 18 || x == 19) && z == this.length - 5 || y == 2 && (x == 12 || x == 18) && z == this.length - 6;
    }

    private boolean isEntranceLavaCatcherCornerWest(int y, int x, int z) {
        return z == 2 && y == 4 && (x == 7 || x == this.width - 3);
    }

    private boolean isEntranceLavaCatcherCornerEast(int y, int x, int z) {
        return z == 2 && y == 4 && (x == 3 || x == this.width - 7);
    }

    private boolean isEntranceLavaCatcherLeft(int y, int x, int z) {
        return z == 1 && y == 3 && x <= this.width - 4 && x >= this.width - 6 || z == 1 && y == 4 && (x == this.width - 3 || x == this.width - 7) || z == 2 && y == 4 && x <= this.width - 4 && x >= this.width - 6;
    }

    private boolean isEntranceLavaCatcherRight(int y, int x, int z) {
        return z == 1 && y == 3 && x >= 4 && x <= 6 || z == 1 && y == 4 && (x == 3 || x == 7) || z == 2 && y == 4 && x >= 4 && x <= 6;
    }

    private boolean isEntranceLavaFlow(int y, int x, int z) {
        return z == 0 && y == this.height - 3 && (x == 5 || x == this.width - 5);
    }

    private boolean isThroneSideLavaFlow(int y, int x, int z) {
        return z == this.length && y == this.height - 3 && (x == 4 || x == 9 || x == this.width - 4 || x == this.width - 9);
    }

    private boolean isThroneSideLavaDitch(int y, int x, int z) {
        return y == 0 && z == this.length - 1 && x != 0 && x != this.width && (x < 13 || x > 17);
    }

    private boolean isAisleTorch(int z) {
        return z == 9 || z == 11 || z == 16 || z == 21 || z == 23 || z == 28 || z == 33 || z == 35 || z == 40 || z == 45 || z == 47 || z == 52 || z == 57 || z == 59 || z == 64 || z == 69 || z == 71;
    }

    private boolean isBackOfThrone(int y, int x, int z) {
        return y >= 6 && y <= 10 && x > 13 && x < 17 && z == this.length - 1;
    }

    private boolean isEntrancePlatformTorch(int y, int x, int z) {
        return y == 2 && z == 5 && (x == 10 || x == this.width - 10) || y == 3 && z == 3 && (x == 12 || x == this.width - 12);
    }

    private boolean isEntranceCarpet(int y, int x, int z) {
        return y == 2 && x > 13 && x < 17 && z == 5 || y == 3 && z == 3 && x > 13 && x < 17 || y == 4 && z == 1 && x > 13 && x < 17;
    }

    private boolean isThroneCarpet(int y, int x, int z) {
        return y == 6 && x > 13 && x < 17 && (z == this.length - 3 || z == this.length - 2) || y == 4 && x > 13 && x < 17 && (z == this.length - 6 || z == this.length - 7);
    }

    private boolean isThroneTorch(int y, int x, int z) {
        return y == 5 && (x == 13 || x == 17) && z == this.length - 5 || y == 8 && (x == 13 || x == 17) && z == this.length - 1;
    }

    private boolean isThroneArms(int y, int x, int z) {
        return y == 3 && (x == 13 || x == 17) && z == this.length - 6 || y == 4 && (x == 13 || x == 17) && z == this.length - 5 || y == 5 && (x == 13 || x == 17) && z == this.length - 4 || y == 6 && (x == 13 || x == 17) && (z == this.length - 3 || z == this.length - 2) || y == 7 && (x == 13 || x == 17) && z == this.length - 1;
    }

    private boolean isThronePlatform(int y, int x, int z) {
        return y == 1 && x >= 13 && x <= 17 && z >= this.length - 9 || y == 1 && (x == 12 || x == 18) && z >= this.length - 9 && z <= this.length - 6 || y == 2 && x >= 13 && x <= 17 && z >= this.length - 8 || y == 3 && x >= 13 && x <= 17 && z >= this.length - 5 || y == 3 && x >= 14 && x <= 16 && z >= this.length - 7 || y == 4 && x >= 13 && x <= 17 && z >= this.length - 4 || y == 5 && x >= 13 && x <= 17 && z >= this.length - 3 || y == 6 && (x == 13 || x == 17) && z == this.length - 1;
    }

    private boolean isEntranceStairsNorth(int y, int x, int z) {
        return y == 1 && z == 6 && x >= 10 && x <= this.width - 10 || y == 2 && z == 4 && x >= 12 && x <= this.width - 12 || y == 3 && z == 2 && x >= 14 && x <= this.width - 14;
    }

    private boolean isEntranceStairsWest(int y, int x, int z) {
        return y == 1 && x == this.width - 9 && z > 0 && z <= 6 || y == 2 && x == this.width - 11 && z > 0 && z <= 4 || y == 3 && x == this.width - 13 && z > 0 && z <= 2;
    }

    private boolean isEntranceStairsEast(int y, int x, int z) {
        return y == 1 && x == 9 && z > 0 && z <= 6 || y == 2 && x == 11 && z > 0 && z <= 4 || y == 3 && x == 13 && z > 0 && z <= 2;
    }

    private boolean isEntrancePlatform(int y, int x, int z) {
        return y == 1 && x >= 10 && x <= this.width - 10 && z <= 5 || y == 2 && x >= 12 && x <= this.width - 12 && z <= 3 || y == 3 && x >= 14 && x <= this.width - 14 && z == 1;
    }

    private void spawnKing() {
        EntityRainbowKing king = new EntityRainbowKing(this.world);
        king.func_70107_b((double)(this.origin.func_177958_n() + 15) + 0.5, this.origin.func_177956_o() + 7, (double)(this.origin.func_177952_p() + (this.length - 3)) + 0.5);
        king.func_180482_a(this.world.func_175649_E(this.origin), null);
        king.setLookAt(this.origin.func_177963_a(15.0, (double)king.func_70047_e(), 0.0));
        this.world.func_72838_d((Entity)king);
    }

    private void spawnRainbowGuards() {
        this.spawnRainbowGuard(13, 10, EntityRainbowGuard.Color.RED);
        this.spawnRainbowGuard(17, 10, EntityRainbowGuard.Color.RED);
        this.spawnRainbowGuard(13, 22, EntityRainbowGuard.Color.ORANGE);
        this.spawnRainbowGuard(17, 22, EntityRainbowGuard.Color.ORANGE);
        this.spawnRainbowGuard(13, 34, EntityRainbowGuard.Color.YELLOW);
        this.spawnRainbowGuard(17, 34, EntityRainbowGuard.Color.YELLOW);
        this.spawnRainbowGuard(13, 46, EntityRainbowGuard.Color.GREEN);
        this.spawnRainbowGuard(17, 46, EntityRainbowGuard.Color.GREEN);
        this.spawnRainbowGuard(13, 58, EntityRainbowGuard.Color.BLUE);
        this.spawnRainbowGuard(17, 58, EntityRainbowGuard.Color.BLUE);
        this.spawnRainbowGuard(13, 70, EntityRainbowGuard.Color.PURPLE);
        this.spawnRainbowGuard(17, 70, EntityRainbowGuard.Color.PURPLE);
    }

    private void spawnRainbowGuard(int x, int z, EntityRainbowGuard.Color color) {
        EntityRainbowGuard entity = new EntityRainbowGuard(this.world);
        entity.setColor(color);
        entity.func_70107_b((double)(this.origin.func_177958_n() + x) + 0.5, this.origin.func_177956_o() + 2, (double)(this.origin.func_177952_p() + z) + 0.5);
        if (x < 15) {
            entity.setLookAt(this.origin.func_177982_a(x + 100, 4, z));
        } else {
            entity.setLookAt(this.origin.func_177982_a(x - 100, 4, z));
        }
        entity.func_180482_a(this.world.func_175649_E(this.origin), null);
        this.world.func_72838_d((Entity)entity);
    }
}

