/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.generation;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.storage.loot.LootTableList;
import net.torocraft.toroquest.entities.EntityMonolithEye;

public class MonolithGenerator
extends WorldGenerator {
    private static int shallowsDepth = 50;
    private static int monolithRadius = 0;
    private static int monolithHeightBase = 4;
    private static int underseaHeight = 0;
    private static int eyeRadius = 0;
    private static int eyeHeight = 0;
    private static int eyeFloatHeight = 1;
    private int monolithHeight;
    private int height;

    protected IBlockState getObsidianBlock() {
        return Blocks.field_150343_Z.func_176223_P();
    }

    protected IBlockState getEyeBlock() {
        return Blocks.field_180398_cJ.func_176223_P();
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        this.setHeight(rand);
        BlockPos surface = this.findSurface(world, pos);
        if (surface == null) {
            return false;
        }
        this.placeMonolith(world, rand, surface);
        this.spawnMonolithEye(world, surface);
        this.placeDungeonRoom(world, surface.func_177958_n(), surface.func_177952_p());
        return true;
    }

    private void placeDungeonRoom(World world, int xCenter, int zCenter) {
        int z;
        int x;
        BlockPos pos;
        int halfX = 6;
        int halfZ = 6;
        int height = 6;
        int xMin = xCenter - halfX;
        int zMin = zCenter - halfZ;
        int yMin = 10;
        int xMax = xCenter + halfX;
        int zMax = zCenter + halfZ;
        int yMax = yMin + height;
        Random rand = new Random();
        for (int y = yMin; y <= yMax; ++y) {
            for (int x2 = xMin; x2 <= xMax; ++x2) {
                for (int z2 = zMin; z2 <= zMax; ++z2) {
                    IBlockState block = y == yMax ? Blocks.field_150353_l.func_176223_P() : (x2 == xMin || x2 == xMax || z2 == zMax || z2 == zMin || y == yMax - 1 || y == yMin ? Blocks.field_150341_Y.func_176223_P() : (y == yMin + 1 ? Blocks.field_150353_l.func_176223_P() : Blocks.field_150350_a.func_176223_P()));
                    pos = new BlockPos(x2, y, z2);
                    this.func_175903_a(world, pos, block);
                }
            }
        }
        for (x = xMin + 1; x < xMax; ++x) {
            for (z = zMin + 1; z < zMax; ++z) {
                if (rand.nextInt(100) >= 3) continue;
                pos = new BlockPos(x, yMin + 1, z);
                this.placeChest(world, pos);
            }
        }
        for (x = xMin + 1; x < xMax; ++x) {
            for (z = zMin + 1; z < zMax; ++z) {
                if (rand.nextInt(100) >= 3) continue;
                pos = new BlockPos(x, yMax - 1, z);
                this.placeSpawner(world, pos);
            }
        }
    }

    protected void placeChest(World world, BlockPos placementPos) {
        this.func_175903_a(world, placementPos, Blocks.field_150486_ae.func_176223_P());
        TileEntity tileentity = world.func_175625_s(placementPos);
        if (tileentity instanceof TileEntityChest) {
            ((TileEntityChest)tileentity).func_189404_a(LootTableList.field_186421_c, world.field_73012_v.nextLong());
        }
    }

    public void placeSpawner(World world, BlockPos pos) {
        this.func_175903_a(world, pos, Blocks.field_150474_ac.func_176223_P());
        TileEntityMobSpawner theSpawner = (TileEntityMobSpawner)world.func_175625_s(pos);
        MobSpawnerBaseLogic logic = theSpawner.func_145881_a();
        logic.func_190894_a(new ResourceLocation("magma_cube"));
    }

    private void setHeight(Random rand) {
        this.monolithHeight = (int)Math.round((double)monolithHeightBase * (1.0 + rand.nextDouble()));
        this.height = this.monolithHeight + eyeFloatHeight + eyeHeight + 1;
    }

    private void spawnMonolithEye(World world, BlockPos pos) {
        BlockPos entityPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + (this.monolithHeight + underseaHeight + eyeFloatHeight) - 2, pos.func_177952_p());
        EntityMonolithEye e = new EntityMonolithEye(world);
        e.func_70107_b((double)entityPos.func_177958_n() + 0.5, (double)entityPos.func_177956_o() + 0.5, (double)entityPos.func_177952_p() + 0.5);
        world.func_72838_d((Entity)e);
    }

    private BlockPos findSurface(World world, BlockPos start) {
        int minY = world.func_72940_L();
        int maxY = 0;
        for (int x = -monolithRadius - 1; x <= monolithRadius + 1; ++x) {
            block1: for (int z = -monolithRadius - 1; z <= monolithRadius + 1; ++z) {
                int verticalSpace = 0;
                for (int y = world.func_72940_L(); y > 0; --y) {
                    BlockPos pos = new BlockPos(start.func_177958_n() + x, y, start.func_177952_p() + z);
                    IBlockState blockState = world.func_180495_p(pos);
                    if (this.isLiquid(blockState)) {
                        return null;
                    }
                    if (this.isGroundBlock(blockState)) {
                        if (y < minY) {
                            minY = y;
                        }
                        if (y > maxY) {
                            maxY = y;
                        }
                        if (verticalSpace >= this.height) continue block1;
                        return null;
                    }
                    ++verticalSpace;
                }
            }
        }
        if (maxY - minY > 4) {
            return null;
        }
        return new BlockPos(start.func_177958_n(), minY, start.func_177952_p());
    }

    private boolean isLiquid(IBlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_150355_j || blockState.func_177230_c() == Blocks.field_150353_l;
    }

    private BlockPos findSeafloor(World world, BlockPos pos) {
        int oY = pos.func_177956_o();
        int oX = pos.func_177958_n();
        int oZ = pos.func_177952_p();
        for (int y = oY; y >= oY - shallowsDepth; --y) {
            BlockPos nPos = new BlockPos(oX, y, oZ);
            IBlockState blockState = world.func_180495_p(nPos);
            if (!this.isGroundBlock(blockState)) continue;
            underseaHeight = oY - y;
            return nPos;
        }
        return null;
    }

    private boolean isGroundBlock(IBlockState blockState) {
        if (blockState.func_177230_c() == Blocks.field_150362_t || blockState.func_177230_c() == Blocks.field_150361_u || blockState.func_177230_c() == Blocks.field_150364_r || blockState.func_177230_c() instanceof BlockBush) {
            return false;
        }
        return blockState.func_185914_p();
    }

    private void placeMonolith(World world, Random rand, BlockPos pos) {
        pos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + this.monolithHeight - 1, pos.func_177952_p());
        while (pos.func_177956_o() > 16) {
            this.func_175903_a(world, pos, Blocks.field_150343_Z.func_176223_P());
            pos = pos.func_177977_b();
        }
    }

    public static void placeBlock(World world, BlockPos pos, Block block) {
        world.func_175656_a(pos, block.func_176223_P());
    }
}

