/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.generation;

import java.util.Random;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BastionsLairEntranceGenerator
extends WorldGenerator {
    private final int boxRadius = 6;
    private final int radius = 5;
    private final int radiusSq = 25;
    private final int halfRadius = 2;
    private final int innerRadiusSquared = 20;
    private int bottom;
    private BlockPos entrancePosition;
    private BlockPos origin;
    private int magSq;
    private int surface;
    private int x;
    private int y;
    private int z;
    private World world;
    private Random rand;
    private IBlockState block;
    private EnumFacing entranceFacing;

    public boolean func_180709_b(World world, Random rand, BlockPos entrancePosition) {
        this.world = world;
        this.rand = rand;
        this.entrancePosition = entrancePosition;
        this.origin = entrancePosition;
        this.findSurface(entrancePosition);
        this.genEntrance();
        return true;
    }

    public void setEntrance(EnumFacing facing) {
        this.entranceFacing = facing;
    }

    private void findSurface(BlockPos start) {
        IBlockState blockState;
        int surfaceGlobal = this.world.func_72940_L();
        while (surfaceGlobal > 0 && !this.isLiquid(blockState = this.world.func_180495_p(new BlockPos(start.func_177958_n(), --surfaceGlobal, start.func_177952_p()))) && !this.isGroundBlock(blockState)) {
        }
        this.surface = surfaceGlobal - this.origin.func_177956_o();
        if (this.surface < 5) {
            this.surface = 5;
        }
    }

    private boolean isLiquid(IBlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_150355_j || blockState.func_177230_c() == Blocks.field_150353_l;
    }

    private boolean isGroundBlock(IBlockState blockState) {
        if (blockState.func_177230_c() == Blocks.field_150362_t || blockState.func_177230_c() == Blocks.field_150361_u || blockState.func_177230_c() == Blocks.field_150364_r || blockState.func_177230_c() instanceof BlockBush) {
            return false;
        }
        return blockState.func_185914_p();
    }

    private void genEntrance() {
        this.y = -20;
        while (this.y <= this.surface + 5) {
            this.x = -6;
            while (this.x <= 6) {
                this.z = -6;
                while (this.z <= 6) {
                    this.magSq = this.x * this.x + this.z * this.z;
                    this.chooseAndPlaceBlock();
                    ++this.z;
                }
                ++this.x;
            }
            ++this.y;
        }
    }

    protected void chooseAndPlaceBlock() {
        this.block = this.isOutside() ? null : (this.isStairs() ? this.getStairBlock() : (this.isWall() && !this.isEntrance() ? Blocks.field_150417_aV.func_176223_P() : (this.isFloor() ? Blocks.field_150348_b.func_176223_P() : Blocks.field_150350_a.func_176223_P())));
        this.placeBlock();
    }

    private boolean isFloor() {
        return this.y < this.surface && this.y % 8 == 0 || this.y == this.surface;
    }

    private boolean isStairs() {
        return Math.abs(this.x) < 2 && Math.abs(this.z) < 2;
    }

    private IBlockState getStairBlock() {
        BlockStairs stairsBlock = (BlockStairs)Blocks.field_150390_bg;
        if (this.y > this.surface) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (this.y < 1) {
            return Blocks.field_150348_b.func_176223_P();
        }
        if (this.x == 0 && this.z == 0) {
            return Blocks.field_150348_b.func_176223_P();
        }
        int yAdj = (this.y + 1) % 4;
        switch (yAdj) {
            case 0: {
                if (this.x == 1 && this.z == 0) {
                    return stairsBlock.func_176203_a(2);
                }
                if (this.x != 1 || this.z != 1) break;
                return Blocks.field_150417_aV.func_176223_P();
            }
            case 1: {
                if (this.x == 0 && this.z == 1) {
                    return stairsBlock.func_176203_a(1);
                }
                if (this.x != -1 || this.z != 1) break;
                return Blocks.field_150417_aV.func_176223_P();
            }
            case 2: {
                if (this.x == -1 && this.z == 0) {
                    return stairsBlock.func_176203_a(3);
                }
                if (this.x != -1 || this.z != -1) break;
                return Blocks.field_150417_aV.func_176223_P();
            }
            case 3: {
                if (this.x == 0 && this.z == -1) {
                    return stairsBlock.func_176203_a(0);
                }
                if (this.x != 1 || this.z != -1) break;
                return Blocks.field_150417_aV.func_176223_P();
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    private boolean isEntrance() {
        if (this.y > 5 || this.y < 1) {
            return false;
        }
        switch (this.entranceFacing) {
            case EAST: {
                return this.x > 2;
            }
            case NORTH: {
                return this.z > 2;
            }
            case SOUTH: {
                return this.z < -2;
            }
            case WEST: {
                return this.x < -2;
            }
        }
        return false;
    }

    private boolean isWall() {
        return this.magSq >= 20 && this.y <= this.surface + 1;
    }

    private boolean isOutside() {
        return this.magSq > 30;
    }

    protected void placeBlock() {
        if (this.block == null) {
            return;
        }
        this.func_175903_a(this.world, this.origin.func_177982_a(this.x, this.y, this.z), this.block);
    }
}

