/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.civilization.CivilizationDataAccessor;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.civilization.CivilizationsWorldSaveData;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityToroNpc;
import net.torocraft.toroquest.entities.render.RenderVillageLord;
import net.torocraft.toroquest.gui.VillageLordGuiHandler;
import net.torocraft.toroquest.inventory.IVillageLordInventory;
import net.torocraft.toroquest.inventory.VillageLordInventory;
import net.torocraft.toroquest.item.armor.ItemRoyalArmor;

public class EntityVillageLord
extends EntityToroNpc
implements IInventoryChangedListener {
    public static String NAME = "village_lord";
    protected Map<UUID, VillageLordInventory> inventories = new HashMap<UUID, VillageLordInventory>();

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityVillageLord.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)60, (int)2, (boolean)true, (int)15508876, (int)12194504);
    }

    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityVillageLord.class, (IRenderFactory)new IRenderFactory<EntityVillageLord>(){

            public Render<EntityVillageLord> createRenderFor(RenderManager manager) {
                return new RenderVillageLord(manager);
            }
        });
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.func_82737_E() % 500L == 0L && this.func_70089_S()) {
            this.setHasLord(true);
        }
    }

    @Override
    public void onPledgeAllegiance() {
        this.setHasLord(true);
    }

    public EntityVillageLord(World world) {
        super(world, null);
        this.initInventories();
    }

    protected int getInventorySize() {
        return 9;
    }

    public IVillageLordInventory getInventory(UUID playerId) {
        if (this.inventories.get(playerId) == null) {
            this.inventories.put(playerId, new VillageLordInventory(this, "VillageLordInventory", this.getInventorySize()));
        }
        return this.inventories.get(playerId);
    }

    protected void initInventories() {
        HashMap<UUID, VillageLordInventory> newInventories = new HashMap<UUID, VillageLordInventory>();
        for (UUID playerId : this.inventories.keySet()) {
            newInventories.put(playerId, this.initInventory(this.inventories.get(playerId)));
        }
    }

    protected VillageLordInventory initInventory(VillageLordInventory prevInventory) {
        VillageLordInventory newInventory = new VillageLordInventory(this, "VillageLordInventory", this.getInventorySize());
        newInventory.func_110133_a(this.func_70005_c_());
        if (prevInventory != null) {
            prevInventory.func_110132_b(this);
            int i = Math.min(prevInventory.func_70302_i_(), newInventory.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = prevInventory.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                newInventory.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        newInventory.func_110134_a(this);
        return newInventory;
    }

    public void openGUI(EntityPlayer player) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        player.openGui((Object)ToroQuest.INSTANCE, VillageLordGuiHandler.getGuiID(), this.field_70170_p, this.func_180425_c().func_177958_n(), this.func_180425_c().func_177956_o(), this.func_180425_c().func_177952_p());
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.func_70089_S() && !this.func_70631_g_()) {
            if (!this.field_70170_p.field_72995_K) {
                this.openGUI(player);
            }
            return true;
        }
        return false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        if (this.func_70089_S()) {
            this.setHasLord(true);
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.func_98053_h(false);
        this.addArmor();
        if (this.func_70089_S()) {
            this.setHasLord(true);
        }
        return livingdata;
    }

    protected void addArmor() {
        this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)ItemRoyalArmor.helmetItem, 1));
        this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)ItemRoyalArmor.bootsItem, 1));
        this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)ItemRoyalArmor.leggingsItem, 1));
        this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)ItemRoyalArmor.chestplateItem, 1));
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        this.dropRepTo(source.func_76346_g());
        if (source.func_76346_g() instanceof EntityLivingBase) {
            this.callForHelp((EntityLivingBase)source.func_76346_g());
        }
        return super.func_70097_a(source, amount);
    }

    private void dropRepTo(Entity entity) {
        if (entity == null) {
            return;
        }
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        CivilizationType civ = this.getCivilization();
        if (civ == null) {
            return;
        }
        PlayerCivilizationCapabilityImpl.get(player).adjustReputation(civ, -5);
    }

    public void func_76316_a(IInventory invBasic) {
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.field_70170_p.field_72995_K || this.inventories == null) {
            return;
        }
        for (IVillageLordInventory iVillageLordInventory : this.inventories.values()) {
            this.dropInventory(iVillageLordInventory);
        }
        this.achievement(cause);
        this.setHasLord(false);
    }

    protected void achievement(DamageSource cause) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        Entity entity = cause.func_76346_g();
    }

    protected void dropInventory(IVillageLordInventory inventory) {
        if (inventory == null) {
            return;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            this.func_70099_a(itemstack, 0.0f);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagCompound c = new NBTTagCompound();
        for (Map.Entry<UUID, VillageLordInventory> e : this.inventories.entrySet()) {
            c.func_74782_a(e.getKey().toString(), (NBTBase)e.getValue().saveAllItems());
        }
        compound.func_74782_a("Items", (NBTBase)c);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        NBTTagCompound c = compound.func_74775_l("Items");
        this.inventories = new HashMap<UUID, VillageLordInventory>();
        for (String sPlayerId : c.func_150296_c()) {
            VillageLordInventory inv = new VillageLordInventory(this, "VillageLordInventory", this.getInventorySize());
            inv.loadAllItems(c.func_150295_c(sPlayerId, 10));
            this.inventories.put(UUID.fromString(sPlayerId), inv);
        }
    }

    public static void registerFixesVillageLord(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityVillageLord.class);
        fixer.func_188258_a(FixTypes.ENTITY, (IDataWalker)new ItemStackDataLists(EntityVillageLord.class, new String[]{"Items"}));
    }

    private void setHasLord(boolean hasLord) {
        Province province = CivilizationUtil.getProvinceAt(this.field_70170_p, this.field_70176_ah, this.field_70164_aj);
        if (province == null) {
            return;
        }
        CivilizationDataAccessor worldData = CivilizationsWorldSaveData.get(this.field_70170_p);
        if (worldData.provinceHasLord(province.id) == hasLord) {
            return;
        }
        if (!this.func_70089_S() && hasLord) {
            hasLord = false;
        }
        worldData.setProvinceHasLord(province.id, hasLord);
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
    }
}

