/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.torocraft.toroquest.entities.EntityGuard;
import net.torocraft.toroquest.entities.EntityToroNpc;
import net.torocraft.toroquest.entities.EntityVillageLord;
import net.torocraft.toroquest.potion.PotionLoyalty;
import net.torocraft.toroquest.potion.PotionRoyal;

public class EntitySpawning {
    private Map<Long, PossibleConversionData> possibleConversionMap = new ConcurrentHashMap<Long, PossibleConversionData>();

    @SubscribeEvent
    public void onCreateVillager(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntityVillager) {
            this.cleanMap();
            if (this.handlePossibleConversion((EntityLiving)event.getEntity(), null)) {
                event.getEntity().func_70106_y();
            }
        }
    }

    @SubscribeEvent
    public void onZombieVillagerDeath(LivingEvent.LivingUpdateEvent event) {
        if (!event.getEntity().func_130014_f_().field_72995_K && event.getEntity().field_70128_L && event.getEntity() instanceof EntityZombieVillager) {
            EntityToroNpc convertTo = null;
            if (this.hasRoyalEffect(event)) {
                convertTo = new EntityVillageLord(event.getEntity().field_70170_p);
            } else if (this.hasLoyalEffect(event)) {
                convertTo = new EntityGuard(event.getEntity().field_70170_p);
            }
            if (convertTo == null) {
                return;
            }
            if (this.handlePossibleConversion((EntityLiving)event.getEntity(), (EntityLiving)convertTo)) {
                this.removeVillager(event);
            }
        }
    }

    private boolean hasRoyalEffect(LivingEvent.LivingUpdateEvent event) {
        return ((EntityZombieVillager)event.getEntity()).func_70660_b((Potion)PotionRoyal.INSTANCE) != null;
    }

    private boolean hasLoyalEffect(LivingEvent.LivingUpdateEvent event) {
        return ((EntityZombieVillager)event.getEntity()).func_70660_b((Potion)PotionLoyalty.INSTANCE) != null;
    }

    private void removeVillager(LivingEvent.LivingUpdateEvent event) {
        List list = event.getEntity().field_70170_p.func_72872_a(EntityVillager.class, new AxisAlignedBB(event.getEntity().func_180425_c()));
        if (list.size() < 1) {
            return;
        }
        ((EntityVillager)list.get(0)).func_70106_y();
    }

    private boolean handlePossibleConversion(EntityLiving entity, EntityLiving toEntity) {
        PossibleConversionData data = this.hasConversionEntry((Entity)entity);
        if (data == null) {
            data = new PossibleConversionData();
            data.from = entity;
            data.to = toEntity;
            data.time = System.currentTimeMillis();
            this.possibleConversionMap.put(entity.func_180425_c().func_177986_g(), data);
            return false;
        }
        this.replaceEntityWithVillageLord(data, toEntity);
        return true;
    }

    private PossibleConversionData hasConversionEntry(Entity entity) {
        PossibleConversionData data = this.possibleConversionMap.get(entity.func_180425_c().func_177986_g());
        if (data == null) {
            return null;
        }
        long delay = System.currentTimeMillis() - data.time;
        if (delay < 0L || delay > 500L) {
            return null;
        }
        return this.possibleConversionMap.remove(entity.func_180425_c().func_177986_g());
    }

    private void replaceEntityWithVillageLord(PossibleConversionData data, EntityLiving toEntity) {
        World world = data.from.field_70170_p;
        BlockPos pos = data.from.func_180425_c();
        if (toEntity == null) {
            toEntity = data.to;
        }
        if (toEntity == null) {
            return;
        }
        if (!data.from.field_70128_L) {
            data.from.func_70106_y();
        }
        toEntity.func_180482_a(world.func_175649_E(pos), (IEntityLivingData)null);
        toEntity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        world.func_72838_d((Entity)toEntity);
        toEntity.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200, 0));
    }

    private void cleanMap() {
        if (this.possibleConversionMap.size() == 0) {
            return;
        }
        Iterator<Map.Entry<Long, PossibleConversionData>> it = this.possibleConversionMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, PossibleConversionData> entry = it.next();
            if (System.currentTimeMillis() - entry.getValue().time <= 10000L) continue;
            it.remove();
        }
    }

    private static class PossibleConversionData {
        public long time;
        public EntityLiving from;
        public EntityLiving to;

        private PossibleConversionData() {
        }
    }
}

