/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.render.RenderFugitive;

public class EntityFugitive
extends EntityVillager
implements IMerchant {
    public static String NAME = "fugitive";
    private static final Item[] STOLEN_ITEMS;
    public static final Predicate<EntityPlayer> PLAYER_WITH_LEAD;

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityFugitive.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)60, (int)2, (boolean)true, (int)0, (int)14735033);
    }

    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityFugitive.class, (IRenderFactory)new IRenderFactory<EntityFugitive>(){

            public Render<EntityFugitive> createRenderFor(RenderManager manager) {
                return new RenderFugitive(manager);
            }
        });
    }

    public EntityFugitive(World worldIn) {
        super(worldIn, 3);
    }

    public boolean func_184652_a(EntityPlayer player) {
        return true;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return false;
    }

    public IEntityLivingData func_190672_a(DifficultyInstance p_190672_1_, @Nullable IEntityLivingData p_190672_2_, boolean p_190672_3_) {
        return p_190672_2_;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 8.0f, 1.0, 0.5));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, PLAYER_WITH_LEAD, 60.0f, 1.5, 1.0));
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.achievement(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.dropLoot();
        }
    }

    protected void achievement(DamageSource cause) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        Entity entity = cause.func_76346_g();
        if (entity == null || entity instanceof EntityPlayer) {
            // empty if block
        }
    }

    private void dropLoot() {
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.dropItem(this.randomStolenItem());
        }
    }

    private ItemStack randomStolenItem() {
        ItemStack stolenItem = new ItemStack(STOLEN_ITEMS[this.field_70146_Z.nextInt(STOLEN_ITEMS.length)]);
        stolenItem = EnchantmentHelper.func_77504_a((Random)this.field_70146_Z, (ItemStack)stolenItem, (int)30, (boolean)true);
        this.setProvince(stolenItem);
        return stolenItem;
    }

    protected void setProvince(ItemStack stolenItem) {
        Province stolenFrom = QuestBase.chooseRandomProvince(null, this.field_70170_p, true);
        if (stolenFrom == null) {
            return;
        }
        if (!stolenItem.func_77942_o()) {
            stolenItem.func_77982_d(new NBTTagCompound());
        }
        String id = stolenFrom.id.toString();
        stolenItem.func_77978_p().func_74778_a("provinceId", id);
        stolenItem.func_77978_p().func_74757_a("isStolen", true);
        stolenItem.func_151001_c("Stolen " + stolenItem.func_82833_r() + " of " + stolenFrom.name);
    }

    private void dropItem(ItemStack stack) {
        EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack);
        dropItem.func_174868_q();
        this.field_70170_p.func_72838_d((Entity)dropItem);
    }

    public ITextComponent func_145748_c_() {
        TextComponentTranslation textcomponenttranslation = new TextComponentTranslation("entity.toroquest.fugitive.name", new Object[0]);
        textcomponenttranslation.func_150256_b().func_150209_a(this.func_174823_aP());
        textcomponenttranslation.func_150256_b().func_179989_a(this.func_189512_bd());
        return textcomponenttranslation;
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
        STOLEN_ITEMS = new Item[]{Items.field_151056_x, Items.field_151036_c, Items.field_151046_w, Items.field_151035_b, Items.field_151153_ao, Items.field_151043_k, Items.field_151045_i, Items.field_151031_f, Items.field_185159_cQ, Items.field_179564_cE, Items.field_151048_u, Items.field_151010_B, Items.field_151020_U, Items.field_151175_af};
        PLAYER_WITH_LEAD = new Predicate<EntityPlayer>(){

            public boolean apply(@Nullable EntityPlayer player) {
                return player.func_70089_S() && this.holdingLead(player);
            }

            private boolean holdingLead(EntityPlayer player) {
                return this.holdingLeadIn(player, EntityEquipmentSlot.MAINHAND) || this.holdingLeadIn(player, EntityEquipmentSlot.MAINHAND);
            }

            private boolean holdingLeadIn(EntityPlayer player, EntityEquipmentSlot mainhand) {
                ItemStack itemstack = player.func_184582_a(mainhand);
                return !itemstack.func_190926_b() && itemstack.func_77973_b() == Items.field_151058_ca;
            }
        };
    }
}

