/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.config;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ToroQuestConfiguration {
    private static final String CATEGORY = "ToroQuest Settings";
    private static Configuration config;
    public static int structureSpawnChance;
    public static int structureMinDistance;
    public static int structureMinDistanceBetweenSame;
    public static float toroHealthMultiplier;
    public static float toroAttackDamageMultiplier;
    public static float bossHealthMultiplier;
    public static float bossAttackDamageMultiplier;
    public static boolean cropsAffectRep;
    public static boolean animalsAffectRep;
    public static boolean specificEntityNames;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            ToroQuestConfiguration.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        try {
            structureSpawnChance = config.getInt("structureSpawnChance", CATEGORY, 1500, 100, 100000, "One out of X chance to spawn a special structure");
            structureMinDistance = config.getInt("structureMinDistance", CATEGORY, 500, 100, 100000, "The minimum distance allowed between to special structures");
            structureMinDistanceBetweenSame = config.getInt("structureMinDistanceBetweenSame", CATEGORY, 4000, 100, 100000, "The minimum distance allowed between to of the same special structures");
            toroHealthMultiplier = config.getFloat("toroHealthMultiplier", CATEGORY, 1.0f, 0.01f, 100.0f, "Toro health multipler");
            toroAttackDamageMultiplier = config.getFloat("toroAttackDamageMultiplier", CATEGORY, 1.0f, 0.01f, 100.0f, "Toro damage multipler");
            bossHealthMultiplier = config.getFloat("bossHealthMultiplier", CATEGORY, 1.0f, 0.01f, 100.0f, "ToroQuest boss health multipler");
            bossAttackDamageMultiplier = config.getFloat("bossAttackDamageMultiplier", CATEGORY, 1.0f, 0.01f, 100.0f, "ToroQuest boss damage multipler");
            cropsAffectRep = config.getBoolean("cropsAffectRep", CATEGORY, true, "Gain rep when planting crops and lose it when harvesting");
            animalsAffectRep = config.getBoolean("animalsAffectRep", CATEGORY, true, "Gain rep when breeding animals and lose it when killing them");
            specificEntityNames = config.getBoolean("specificEntityNames", CATEGORY, true, "Use specific entity names to improve mod compatabilty, CHANGING THIS WILL REMOVE CURRENT TQ ENTITIES IN YOUR WORLD!");
            config.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("toroquest")) {
            ToroQuestConfiguration.loadConfiguration();
        }
    }

    static {
        structureSpawnChance = 1500;
        structureMinDistance = 500;
        structureMinDistanceBetweenSame = 4000;
        toroHealthMultiplier = 1.0f;
        toroAttackDamageMultiplier = 1.0f;
        bossHealthMultiplier = 1.0f;
        bossAttackDamageMultiplier = 1.0f;
        cropsAffectRep = true;
        animalsAffectRep = true;
        specificEntityNames = true;
    }
}

