/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.quests.util.Quests;

public class QuestData {
    private UUID questId;
    private Integer questType;
    private UUID provinceId;
    private CivilizationType civ;
    private transient EntityPlayer player;
    private Boolean completed = false;
    private Map<String, Integer> iData = new HashMap<String, Integer>();
    private Map<String, String> sData = new HashMap<String, String>();
    private NBTBase custom = new NBTTagCompound();

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("id[").append(this.questId).append("]");
        s.append(" questType[").append(this.questType).append("]");
        s.append(" provinceId[").append(this.provinceId).append("]");
        for (Map.Entry<String, Integer> e : this.iData.entrySet()) {
            s.append(" idata_" + e.getKey() + "[").append(e.getValue()).append("]");
        }
        for (Map.Entry<String, Integer> e : this.iData.entrySet()) {
            s.append(" sdata_" + e.getKey() + "[").append(e.getValue()).append("]");
        }
        return s.toString();
    }

    public boolean isValid() {
        return this.questId != null && this.questType != null && Quests.getQuestForId(this.questType) != null && this.provinceId != null;
    }

    public void readNBT(NBTTagCompound c, EntityPlayer player) {
        this.player = player;
        this.questId = UUID.fromString(c.func_74779_i("id"));
        this.questType = c.func_74762_e("type");
        this.provinceId = UUID.fromString(c.func_74779_i("provinceId"));
        this.civ = this.e(c.func_74779_i("civ"));
        this.iData = this.readIMap(c.func_74775_l("idata"));
        this.sData = this.readSMap(c.func_74775_l("sdata"));
        this.completed = c.func_74767_n("completed");
        this.custom = c.func_74781_a("custom");
    }

    private Map<String, Integer> readIMap(NBTTagCompound c) {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        for (String key : c.func_150296_c()) {
            m.put(key, c.func_74762_e(key));
        }
        return m;
    }

    private NBTTagCompound writeIMap(Map<String, Integer> m) {
        NBTTagCompound c = new NBTTagCompound();
        for (Map.Entry<String, Integer> e : m.entrySet()) {
            c.func_74768_a(e.getKey(), e.getValue().intValue());
        }
        return c;
    }

    private Map<String, String> readSMap(NBTTagCompound c) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (String key : c.func_150296_c()) {
            m.put(key, c.func_74779_i(key));
        }
        return m;
    }

    private NBTTagCompound writeSMap(Map<String, String> m) {
        NBTTagCompound c = new NBTTagCompound();
        for (Map.Entry<String, String> e : m.entrySet()) {
            c.func_74778_a(e.getKey(), e.getValue());
        }
        return c;
    }

    public NBTTagCompound writeNBT() {
        NBTTagCompound c = new NBTTagCompound();
        c.func_74778_a("id", this.questId.toString());
        c.func_74768_a("type", this.questType.intValue());
        c.func_74778_a("provinceId", this.provinceId.toString());
        c.func_74778_a("civ", this.s(this.civ));
        c.func_74782_a("idata", (NBTBase)this.writeIMap(this.iData));
        c.func_74782_a("sdata", (NBTBase)this.writeSMap(this.sData));
        c.func_74757_a("completed", this.completed.booleanValue());
        if (this.custom == null) {
            System.out.println("**** quest custom data was null, boo.");
            this.custom = new NBTTagCompound();
        }
        c.func_74782_a("custom", this.custom);
        return c;
    }

    private String s(CivilizationType civ) {
        if (civ == null) {
            return "";
        }
        return civ.toString();
    }

    private CivilizationType e(String s) {
        try {
            return CivilizationType.valueOf(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.questId == null ? 0 : this.questId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuestData other = (QuestData)obj;
        return !(this.questId == null ? other.questId != null : !this.questId.equals(other.questId));
    }

    public UUID getQuestId() {
        return this.questId;
    }

    public void setQuestId(UUID questId) {
        this.questId = questId;
    }

    public Integer getQuestType() {
        return this.questType;
    }

    public void setQuestType(Integer questType) {
        this.questType = questType;
    }

    public UUID getProvinceId() {
        return this.provinceId;
    }

    public void setProvinceId(UUID provinceId) {
        this.provinceId = provinceId;
    }

    public CivilizationType getCiv() {
        return this.civ;
    }

    public void setCiv(CivilizationType civ) {
        this.civ = civ;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public void setPlayer(EntityPlayer player) {
        this.player = player;
    }

    public Map<String, Integer> getiData() {
        return this.iData;
    }

    public void setiData(Map<String, Integer> iData) {
        this.iData = iData;
    }

    public Boolean getCompleted() {
        return this.completed;
    }

    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public Map<String, String> getsData() {
        return this.sData;
    }

    public void setsData(Map<String, String> sData) {
        this.sData = sData;
    }

    public NBTBase getCustom() {
        return this.custom;
    }

    public void setCustom(NBTBase custom) {
        this.custom = custom;
    }
}

