/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.Quests;

public class QuestMine
extends QuestBase {
    public static QuestMine INSTANCE;
    private static final Block[] BLOCK_TYPES;
    public static int ID;

    public static void init(int id) {
        INSTANCE = new QuestMine();
        Quests.registerQuest(id, INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        ID = id;
    }

    @SubscribeEvent
    public void onMine(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() == null) {
            return;
        }
        EntityPlayer player = event.getHarvester();
        Province inProvince = QuestMine.loadProvince(event.getHarvester().field_70170_p, event.getPos());
        if (inProvince == null || inProvince.civilization == null) {
            return;
        }
        ItemStack tool = player.func_184582_a(EntityEquipmentSlot.MAINHAND);
        if (!tool.func_77942_o()) {
            return;
        }
        String questId = tool.func_77978_p().func_74779_i("mine_quest");
        String provinceId = tool.func_77978_p().func_74779_i("province");
        if (questId == null || provinceId == null || !provinceId.equals(inProvince.id.toString())) {
            return;
        }
        QuestData data = QuestMine.getQuestById(player, questId);
        if (data == null) {
            return;
        }
        if (this.notCurrentDepth(event, data)) {
            return;
        }
        if (event.getState().func_177230_c() != BLOCK_TYPES[this.getBlockType(data)]) {
            return;
        }
        event.setDropChance(1.0f);
        for (ItemStack drop : event.getDrops()) {
            drop.func_77983_a("mine_quest", (NBTBase)new NBTTagString(questId));
            drop.func_77983_a("province", (NBTBase)new NBTTagString(provinceId));
            drop.func_151001_c(drop.func_82833_r() + " for " + inProvince.name);
        }
    }

    protected boolean notCurrentDepth(BlockEvent.HarvestDropsEvent event, QuestData data) {
        int max = this.getMaxDepth(data);
        int min = this.getMinDepth(data);
        int y = event.getPos().func_177956_o();
        if (min > 0 && y < min) {
            return true;
        }
        return max > 0 && y > max;
    }

    @Override
    public List<ItemStack> complete(QuestData data, List<ItemStack> in) {
        if (in == null) {
            return null;
        }
        List<ItemStack> givenItems = QuestMine.copyItems(in);
        int requiredLeft = this.getTargetAmount(data);
        boolean toolIncluded = false;
        for (ItemStack item : givenItems) {
            if (!this.isForThisQuest(data, item)) continue;
            if (item.func_77973_b() instanceof ItemTool) {
                toolIncluded = true;
                item.func_190920_e(0);
                continue;
            }
            requiredLeft -= item.func_190916_E();
            item.func_190920_e(0);
        }
        if (requiredLeft > 0) {
            data.getPlayer().func_145747_a((ITextComponent)new TextComponentString("You are " + requiredLeft + " short"));
            return null;
        }
        if (!toolIncluded) {
            data.getPlayer().func_145747_a((ITextComponent)new TextComponentString("You must turn in the tool that you were given"));
            return null;
        }
        givenItems = QuestMine.removeEmptyItemStacks(givenItems);
        QuestMine.addRewardItems(data, givenItems);
        return givenItems;
    }

    protected boolean isForThisQuest(QuestData data, ItemStack item) {
        if (!item.func_77942_o() || item.func_190926_b()) {
            return false;
        }
        String wasMinedForQuestId = item.func_77978_p().func_74779_i("mine_quest");
        return data.getQuestId().toString().equals(wasMinedForQuestId);
    }

    @Override
    public List<ItemStack> reject(QuestData data, List<ItemStack> in) {
        if (in == null) {
            return null;
        }
        List<ItemStack> givenItems = QuestMine.copyItems(in);
        boolean toolIncluded = false;
        int emeraldRemainingCount = 5;
        for (ItemStack item : givenItems) {
            if (!this.isForThisQuest(data, item) || !(item.func_77973_b() instanceof ItemTool)) continue;
            toolIncluded = true;
            item.func_190920_e(0);
        }
        if (!toolIncluded) {
            for (ItemStack item : givenItems) {
                if (item.func_190926_b() || item.func_77973_b() != Items.field_151166_bC) continue;
                int decBy = Math.min(item.func_190916_E(), emeraldRemainingCount);
                emeraldRemainingCount -= decBy;
                item.func_190918_g(decBy);
            }
        }
        if (!toolIncluded && emeraldRemainingCount > 0) {
            data.getPlayer().func_145747_a((ITextComponent)new TextComponentString("Return the tool that was provided or 5 emeralds to pay for it"));
            return null;
        }
        return QuestMine.removeEmptyItemStacks(givenItems);
    }

    @Override
    public List<ItemStack> accept(QuestData data, List<ItemStack> in) {
        Block type = BLOCK_TYPES[this.getBlockType(data)];
        Province province = QuestMine.getQuestProvince(data);
        ItemStack tool = type == Blocks.field_150351_n ? new ItemStack(Items.field_151047_v) : new ItemStack(Items.field_151046_w);
        tool.func_151001_c(tool.func_82833_r() + " of " + province.name);
        tool.func_77966_a(Enchantment.func_185262_c((int)33), 1);
        tool.func_77983_a("mine_quest", (NBTBase)new NBTTagString(data.getQuestId().toString()));
        tool.func_77983_a("province", (NBTBase)new NBTTagString(province.id.toString()));
        in.add(tool);
        return in;
    }

    @Override
    public String getTitle(QuestData data) {
        return "quests.mine.title";
    }

    @Override
    public String getDescription(QuestData data) {
        if (data == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        s.append("quests.mine.description");
        s.append("|").append(this.getTargetAmount(data));
        s.append("|").append(BLOCK_TYPES[this.getBlockType(data)].func_149732_F());
        s.append("|").append(QuestMine.listItems(QuestMine.getRewardItems(data)));
        s.append("|").append(QuestMine.getRewardRep(data));
        return s.toString();
    }

    @Override
    public QuestData generateQuestFor(EntityPlayer player, Province questProvince) {
        Random rand = player.field_70170_p.field_73012_v;
        QuestData data = new QuestData();
        data.setCiv(questProvince.civilization);
        data.setPlayer(player);
        data.setProvinceId(questProvince.id);
        data.setQuestId(UUID.randomUUID());
        data.setQuestType(ID);
        data.setCompleted(false);
        this.setMaxDepth(data, 30);
        this.setMinDepth(data, 0);
        int roll = rand.nextInt(20);
        this.setTargetAmount(data, 10 + roll);
        this.setBlockType(data, rand.nextInt(BLOCK_TYPES.length));
        QuestMine.setRewardRep(data, 5 + roll / 5);
        ArrayList<ItemStack> rewards = new ArrayList<ItemStack>(1);
        ItemStack emeralds = new ItemStack(Items.field_151166_bC, 4 + roll / 10);
        rewards.add(emeralds);
        QuestMine.setRewardItems(data, rewards);
        return data;
    }

    private int getBlockType(QuestData data) {
        return this.coalesce(data.getiData().get("block_type"), 0);
    }

    private int coalesce(Integer integer, int i) {
        if (integer == null) {
            return i;
        }
        return integer;
    }

    private void setBlockType(QuestData data, int blockType) {
        data.getiData().put("block_type", blockType);
    }

    private int getMaxDepth(QuestData data) {
        return this.coalesce(data.getiData().get("max_depth"), 0);
    }

    private void setMaxDepth(QuestData data, int depth) {
        data.getiData().put("max_depth", depth);
    }

    private int getMinDepth(QuestData data) {
        return this.coalesce(data.getiData().get("min_depth"), 0);
    }

    private void setMinDepth(QuestData data, int depth) {
        data.getiData().put("min_depth", depth);
    }

    private int getTargetAmount(QuestData data) {
        return data.getiData().get("target_amount");
    }

    private void setTargetAmount(QuestData data, int amount) {
        data.getiData().put("target_amount", amount);
    }

    static {
        BLOCK_TYPES = new Block[]{Blocks.field_150351_n, Blocks.field_150348_b, Blocks.field_150365_q, Blocks.field_150366_p, Blocks.field_150343_Z, Blocks.field_150450_ax};
    }
}

