/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.civilization.quests.QuestFarm;
import net.torocraft.toroquest.civilization.quests.util.Quest;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.Quests;

public class QuestGather
extends QuestBase
implements Quest {
    public static QuestGather INSTANCE;
    public static int ID;

    public static void init(int id) {
        INSTANCE = new QuestGather();
        Quests.registerQuest(id, INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        ID = id;
    }

    private static QuestData baseQuest(Province province, EntityPlayer player) {
        QuestData data = new QuestData();
        data.setCiv(province.civilization);
        data.setPlayer(player);
        data.setProvinceId(province.id);
        data.setQuestId(UUID.randomUUID());
        data.setQuestType(ID);
        data.setCompleted(false);
        return data;
    }

    private static QuestData quest1(Province province, EntityPlayer player) {
        QuestData data = QuestGather.baseQuest(province, player);
        ArrayList<ItemStack> required = new ArrayList<ItemStack>();
        required.add(new ItemStack(Blocks.field_150351_n, 64));
        required.add(new ItemStack(Blocks.field_150347_e, 64));
        required.add(new ItemStack(Blocks.field_150435_aG, 16));
        QuestGather.setRequiredItems(data, required);
        ArrayList<ItemStack> reward = new ArrayList<ItemStack>();
        reward.add(new ItemStack(Items.field_151166_bC, 4));
        QuestGather.setRewardItems(data, reward);
        QuestGather.setRewardRep(data, 10);
        return data;
    }

    private static QuestData questDarkOak(Province province, EntityPlayer player) {
        Random rand = player.field_70170_p.field_73012_v;
        int roll = rand.nextInt(32);
        QuestData data = QuestGather.baseQuest(province, player);
        ArrayList<ItemStack> required = new ArrayList<ItemStack>();
        required.add(QuestGather.createMetaBlockStack(Blocks.field_150363_s, 1, 32 + roll));
        required.add(QuestGather.createMetaBlockStack((Block)Blocks.field_150361_u, 1, 32 + roll));
        QuestGather.setRequiredItems(data, required);
        ArrayList<ItemStack> reward = new ArrayList<ItemStack>();
        reward.add(new ItemStack(Items.field_151166_bC, 5 + Math.round(roll / 10)));
        QuestGather.setRewardItems(data, reward);
        QuestGather.setRewardRep(data, 10);
        return data;
    }

    private static QuestData quest2(Province province, EntityPlayer player) {
        Random rand = player.field_70170_p.field_73012_v;
        QuestData data = QuestGather.baseQuest(province, player);
        ArrayList<ItemStack> required = new ArrayList<ItemStack>();
        required.add(new ItemStack(Items.field_151033_d, 1));
        required.add(new ItemStack(Blocks.field_150343_Z, 10));
        QuestGather.setRequiredItems(data, required);
        ArrayList<ItemStack> reward = new ArrayList<ItemStack>();
        reward.add(new ItemStack(Items.field_151166_bC, 3 + rand.nextInt(2)));
        QuestGather.setRewardItems(data, reward);
        QuestGather.setRewardRep(data, 10);
        return data;
    }

    @Override
    public QuestData generateQuestFor(EntityPlayer player, Province province) {
        Random rand = player.func_130014_f_().field_73012_v;
        switch (rand.nextInt(3)) {
            case 0: {
                return QuestGather.quest1(province, player);
            }
            case 1: {
                return QuestGather.quest2(province, player);
            }
            case 2: {
                return QuestGather.questDarkOak(province, player);
            }
        }
        return QuestGather.quest1(province, player);
    }

    @Override
    public String getTitle(QuestData data) {
        return "quests.gather.title";
    }

    @Override
    public String getDescription(QuestData data) {
        if (data == null) {
            return "";
        }
        QuestFarm.DataWrapper q = new QuestFarm.DataWrapper().setData(data);
        StringBuilder s = new StringBuilder();
        s.append("quests.gather.description");
        s.append("|").append(QuestGather.listItems(QuestGather.getRequiredItems(data)));
        s.append("|").append(QuestGather.listItems(QuestGather.getRewardItems(data)));
        s.append("|").append(QuestGather.getRewardRep(data));
        return s.toString();
    }

    @Override
    public List<ItemStack> reject(QuestData data, List<ItemStack> in) {
        return in;
    }

    @Override
    public List<ItemStack> accept(QuestData data, List<ItemStack> in) {
        return in;
    }

    @Override
    public List<ItemStack> complete(QuestData data, List<ItemStack> items) {
        Province province = QuestGather.loadProvince(data.getPlayer().field_70170_p, data.getPlayer().func_180425_c());
        if (province == null || !province.id.equals(data.getProvinceId())) {
            return null;
        }
        try {
            items = QuestGather.removeItems(QuestGather.getRequiredItems(data), items);
        }
        catch (QuestBase.InsufficientItems ex) {
            data.getPlayer().func_145747_a((ITextComponent)new TextComponentString("Missing " + ex.getMessage()));
            return null;
        }
        PlayerCivilizationCapabilityImpl.get(data.getPlayer()).adjustReputation(data.getCiv(), QuestGather.getRewardRep(data));
        items.addAll(QuestGather.getRewardItems(data));
        return items;
    }
}

