/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapability;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.civilization.quests.util.Quest;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.Quests;

public class QuestFarm
extends QuestBase
implements Quest {
    private static final Block[] CROP_TYPES = new Block[]{Blocks.field_150459_bM, Blocks.field_150469_bN, Blocks.field_150464_aj, Blocks.field_150394_bc, Blocks.field_150393_bb, Blocks.field_185773_cZ};
    public static QuestFarm INSTANCE;
    public static int ID;

    public static void init(int id) {
        INSTANCE = new QuestFarm();
        Quests.registerQuest(id, INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        ID = id;
    }

    @SubscribeEvent
    public void onFarm(BlockEvent.PlaceEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        Province provinceFarmedIn = QuestFarm.loadProvince(event.getPlayer().field_70170_p, event.getBlockSnapshot().getPos());
        if (provinceFarmedIn == null || provinceFarmedIn.civilization == null) {
            return;
        }
        this.handleFarmQuest(event.getPlayer(), provinceFarmedIn, event.getPlacedBlock().func_177230_c(), true);
    }

    @SubscribeEvent
    public void onHarvest(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        Province provinceFarmedIn = QuestFarm.loadProvince(event.getPlayer().field_70170_p, event.getPos());
        if (provinceFarmedIn == null || provinceFarmedIn.civilization == null) {
            return;
        }
        this.handleFarmQuest(event.getPlayer(), provinceFarmedIn, event.getState().func_177230_c(), false);
    }

    private void handleFarmQuest(EntityPlayer player, Province provinceFarmedIn, Block crop, boolean plant) {
        Set<QuestData> quests = PlayerCivilizationCapabilityImpl.get(player).getCurrentQuests();
        DataWrapper quest = new DataWrapper();
        for (QuestData data : quests) {
            quest.setData(data);
            quest.farmedCrop = crop;
            quest.provinceFarmedIn = provinceFarmedIn;
            if (!this.perform(quest, plant)) continue;
            return;
        }
    }

    public boolean perform(DataWrapper quest, boolean plant) {
        if (quest.getData().getPlayer().field_70170_p.field_72995_K) {
            return false;
        }
        if (!quest.isApplicable()) {
            return false;
        }
        if (plant) {
            quest.setCurrentAmount(quest.getCurrentAmount() + 1);
        } else {
            quest.setCurrentAmount(quest.getCurrentAmount() - 1);
        }
        if (quest.getCurrentAmount() >= quest.getTargetAmount()) {
            quest.data.setCompleted(true);
        }
        return true;
    }

    @Override
    public String getTitle(QuestData data) {
        return "quests.farm.title";
    }

    private String cropName(Integer i) {
        if (i == null) {
            return "Crop";
        }
        Block crop = CROP_TYPES[i];
        if (crop == null) {
            System.out.println("invalid crop ID [" + i + "]");
            return "Crop";
        }
        return crop.func_149732_F();
    }

    @Override
    public String getDescription(QuestData data) {
        if (data == null) {
            return "";
        }
        DataWrapper q = new DataWrapper().setData(data);
        StringBuilder s = new StringBuilder();
        s.append("quests.farm.description");
        s.append("|").append(q.getTargetAmount());
        s.append("|").append(this.cropName(q.getCropType()));
        s.append("|").append(this.getProvinceName(data.getPlayer(), data.getProvinceId()));
        s.append("|").append(q.getCurrentAmount());
        s.append("|").append(QuestFarm.listItems(QuestFarm.getRewardItems(data)));
        return s.toString();
    }

    @Override
    public QuestData generateQuestFor(EntityPlayer player, Province province) {
        Random rand = player.func_130014_f_().field_73012_v;
        DataWrapper q = new DataWrapper();
        q.data.setCiv(province.civilization);
        q.data.setPlayer(player);
        q.data.setProvinceId(province.id);
        q.data.setQuestId(UUID.randomUUID());
        q.data.setQuestType(ID);
        q.data.setCompleted(false);
        int roll = rand.nextInt(100);
        q.setCropType(rand.nextInt(CROP_TYPES.length));
        q.setCurrentAmount(0);
        q.setRewardRep(0);
        q.setTargetAmount(MathHelper.func_76125_a((int)roll, (int)32, (int)100));
        ItemStack emeralds = new ItemStack(Items.field_151166_bC, MathHelper.func_76125_a((int)(q.getTargetAmount() / 32), (int)1, (int)4));
        ArrayList<ItemStack> rewardItems = new ArrayList<ItemStack>();
        rewardItems.add(emeralds);
        QuestFarm.setRewardItems(q.data, rewardItems);
        return q.data;
    }

    @Override
    public List<ItemStack> reject(QuestData data, List<ItemStack> in) {
        return in;
    }

    @Override
    public List<ItemStack> accept(QuestData data, List<ItemStack> in) {
        return in;
    }

    @Override
    public List<ItemStack> complete(QuestData quest, List<ItemStack> items) {
        List<ItemStack> rewards;
        if (!quest.getCompleted().booleanValue()) {
            return null;
        }
        Province province = QuestFarm.loadProvince(quest.getPlayer().field_70170_p, quest.getPlayer().func_180425_c());
        if (province == null || province.id == null || !province.id.equals(quest.getProvinceId())) {
            return null;
        }
        PlayerCivilizationCapability playerCiv = PlayerCivilizationCapabilityImpl.get(quest.getPlayer());
        playerCiv.adjustReputation(quest.getCiv(), new DataWrapper().setData(quest).getRewardRep());
        if (playerCiv.getReputation(province.civilization) > 100 && quest.getPlayer().field_70170_p.field_73012_v.nextInt(10) > 8) {
            ItemStack hoe = new ItemStack(Items.field_151013_M);
            hoe.func_151001_c("Golden Hoe of " + province.name);
            items.add(hoe);
        }
        if ((rewards = QuestFarm.getRewardItems(quest)) != null) {
            items.addAll(rewards);
        }
        return items;
    }

    public static class DataWrapper {
        private QuestData data = new QuestData();
        private Province provinceFarmedIn;
        private Block farmedCrop;

        public QuestData getData() {
            return this.data;
        }

        public DataWrapper setData(QuestData data) {
            this.data = data;
            return this;
        }

        public Province getProvinceFarmedIn() {
            return this.provinceFarmedIn;
        }

        public void setProvinceFarmedIn(Province provinceFarmedIn) {
            this.provinceFarmedIn = provinceFarmedIn;
        }

        public Block getFarmedCrop() {
            return this.farmedCrop;
        }

        public void setFarmedCrop(Block farmedCrop) {
            this.farmedCrop = farmedCrop;
        }

        public Integer getCropType() {
            return this.i(this.data.getiData().get("type"));
        }

        public void setCropType(Integer cropType) {
            this.data.getiData().put("type", cropType);
        }

        public Integer getTargetAmount() {
            return this.i(this.data.getiData().get("target"));
        }

        public void setTargetAmount(Integer targetAmount) {
            this.data.getiData().put("target", targetAmount);
        }

        public Integer getCurrentAmount() {
            return this.i(this.data.getiData().get("amount"));
        }

        public void setCurrentAmount(Integer currentAmount) {
            this.data.getiData().put("amount", currentAmount);
        }

        public Integer getRewardRep() {
            return this.i(this.data.getiData().get("rep"));
        }

        public void setRewardRep(Integer rewardRep) {
            this.data.getiData().put("rep", rewardRep);
        }

        private Integer i(Object o) {
            try {
                return (Integer)o;
            }
            catch (Exception e) {
                return 0;
            }
        }

        private boolean isApplicable() {
            return this.isFarmQuest() && this.isInCorrectProvince() && this.isCorrectCrop();
        }

        private boolean isFarmQuest() {
            return this.data.getQuestType() == ID;
        }

        private boolean isInCorrectProvince() {
            return this.data.getProvinceId().equals(this.getProvinceFarmedIn().id);
        }

        private boolean isCorrectCrop() {
            return CROP_TYPES[this.getCropType()] == this.getFarmedCrop();
        }
    }
}

