/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.civilization.CivilizationsWorldSaveData;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.util.Quest;
import net.torocraft.toroquest.civilization.quests.util.QuestData;

public abstract class QuestBase
implements Quest {
    protected static ItemStack createMetaBlockStack(Block block, int meta, int amount) {
        ItemStack s = new ItemStack(block, amount);
        s.func_77964_b(meta);
        return s;
    }

    protected static Province loadProvince(World world, BlockPos pos) {
        return CivilizationUtil.getProvinceAt(world, pos.func_177958_n() / 16, pos.func_177952_p() / 16);
    }

    protected static String listItems__OLD(List<ItemStack> items) {
        StringBuilder s = new StringBuilder();
        for (ItemStack stack : items) {
            s.append(" ").append(stack.func_190916_E()).append(" ").append(stack.func_82833_r());
        }
        return s.toString();
    }

    protected static String listItems(List<ItemStack> rewardItems) {
        if (rewardItems == null || rewardItems.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("L:");
        boolean first = true;
        for (ItemStack item : rewardItems) {
            if (first) {
                first = false;
            } else {
                sb.append(";");
            }
            sb.append(item.func_77973_b().func_77658_a());
            sb.append(",");
            sb.append(item.func_190916_E());
        }
        return sb.toString();
    }

    protected static List<ItemStack> removeItems(List<ItemStack> requiredIn, List<ItemStack> itemsIn) throws InsufficientItems {
        List<ItemStack> givenItems = QuestBase.copyItems(itemsIn);
        List<ItemStack> requiredItems = QuestBase.copyItems(requiredIn);
        for (ItemStack givenItem : givenItems) {
            for (ItemStack requiredItem : requiredItems) {
                QuestBase.handleStackDecrement(requiredItem, givenItem);
            }
        }
        for (ItemStack remainingRequired : requiredItems) {
            if (remainingRequired.func_190916_E() <= 0) continue;
            throw new InsufficientItems(remainingRequired.func_190916_E() + " " + remainingRequired.func_82833_r());
        }
        return givenItems;
    }

    protected static void handleStackDecrement(ItemStack requiredItem, ItemStack givenItem) {
        if (!QuestBase.equals(requiredItem, givenItem)) {
            return;
        }
        if (requiredItem.func_190916_E() < 1 || givenItem.func_190916_E() < 1) {
            return;
        }
        int decrementBy = Math.min(requiredItem.func_190916_E(), givenItem.func_190916_E());
        requiredItem.func_190918_g(decrementBy);
        givenItem.func_190918_g(decrementBy);
    }

    protected static boolean equals(ItemStack requiredItem, ItemStack givenItem) {
        return requiredItem.func_77973_b() == givenItem.func_77973_b();
    }

    protected static List<ItemStack> copyItems(List<ItemStack> itemsIn) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack stack : itemsIn) {
            items.add(stack.func_77946_l());
        }
        return items;
    }

    protected static void setRewardItems(QuestData data, List<ItemStack> rewards) {
        QuestBase.setItemsToNbt(data, "rewards", rewards);
    }

    protected static void setRequiredItems(QuestData data, List<ItemStack> required) {
        QuestBase.setItemsToNbt(data, "required", required);
    }

    protected static List<ItemStack> getRequiredItems(QuestData data) {
        return QuestBase.getItemsFromNbt(data, "required");
    }

    protected static List<ItemStack> getRewardItems(QuestData data) {
        return QuestBase.getItemsFromNbt(data, "rewards");
    }

    protected static List<ItemStack> getItemsFromNbt(QuestData data, String name) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        NBTTagCompound c = QuestBase.getCustomNbtTag(data);
        try {
            NBTTagList list = (NBTTagList)c.func_74781_a(name);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                items.add(new ItemStack(list.func_150305_b(i)));
            }
            return items;
        }
        catch (Exception e) {
            return QuestBase.getDefaultItems(name);
        }
    }

    protected static List<ItemStack> getDefaultItems(String name) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(new ItemStack(Items.field_151045_i, 13));
        return items;
    }

    protected static void setItemsToNbt(QuestData data, String name, List<ItemStack> items) {
        NBTTagCompound c = QuestBase.getCustomNbtTag(data);
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : items) {
            NBTTagCompound cStack = new NBTTagCompound();
            stack.func_77955_b(cStack);
            list.func_74742_a((NBTBase)cStack);
        }
        c.func_74782_a(name, (NBTBase)list);
    }

    protected static NBTTagCompound getCustomNbtTag(QuestData data) {
        try {
            return (NBTTagCompound)data.getCustom();
        }
        catch (Exception e) {
            NBTTagCompound c = new NBTTagCompound();
            data.setCustom((NBTBase)c);
            return c;
        }
    }

    protected static Integer getRewardRep(QuestData data) {
        return QuestBase.i(data.getiData().get("rep"));
    }

    protected static void setRewardRep(QuestData data, Integer rewardRep) {
        data.getiData().put("rep", rewardRep);
    }

    protected static Integer i(Object o) {
        try {
            return (Integer)o;
        }
        catch (Exception e) {
            return 0;
        }
    }

    protected static boolean isLiquid(IBlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_150355_j || blockState.func_177230_c() == Blocks.field_150353_l;
    }

    protected static boolean isGroundBlock(IBlockState blockState) {
        if (blockState.func_177230_c() == Blocks.field_150362_t || blockState.func_177230_c() == Blocks.field_150361_u || blockState.func_177230_c() == Blocks.field_150364_r || blockState.func_177230_c() instanceof BlockBush) {
            return false;
        }
        return blockState.func_185914_p();
    }

    protected static boolean cantBuildOver(IBlockState blockState) {
        if (blockState.func_177230_c() == Blocks.field_150362_t || blockState.func_177230_c() == Blocks.field_150361_u || blockState.func_177230_c() instanceof BlockBush) {
            return false;
        }
        return blockState.func_185914_p();
    }

    protected static String getDirections(BlockPos from, BlockPos to) {
        if (from == null || to == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("D:");
        long distance = Math.round(from.func_185332_f(to.func_177958_n(), to.func_177956_o(), to.func_177952_p()));
        int x = to.func_177958_n();
        int z = to.func_177952_p();
        sb.append(distance);
        sb.append(";").append(x);
        sb.append(";").append(z);
        return sb.toString();
    }

    protected static Province getQuestProvince(QuestData data) {
        return QuestBase.getProvinceById(data.getPlayer().field_70170_p, data.getProvinceId());
    }

    protected static BlockPos getProvincePosition(Province province) {
        return new BlockPos(province.chunkX * 16, 80, province.chunkZ * 16);
    }

    protected static List<Province> getAllProvinces(World world) {
        return CivilizationsWorldSaveData.get(world).getProvinces();
    }

    protected static Province getProvinceById(World world, String id) {
        return QuestBase.getProvinceById(world, UUID.fromString(id));
    }

    protected static Province getProvinceById(World world, UUID id) {
        for (Province p : QuestBase.getAllProvinces(world)) {
            if (!p.id.equals(id)) continue;
            return p;
        }
        return null;
    }

    protected String getProvinceName(EntityPlayer player, UUID provinceId) {
        Province province = QuestBase.getProvinceById(player.field_70170_p, provinceId);
        if (province == null) {
            return "";
        }
        return province.name;
    }

    protected static QuestData getQuestById(EntityPlayer player, String questId) {
        return QuestBase.getQuestById(player, UUID.fromString(questId));
    }

    protected static QuestData getQuestById(EntityPlayer player, UUID questId) {
        Set<QuestData> quests = PlayerCivilizationCapabilityImpl.get(player).getCurrentQuests();
        if (quests == null) {
            return null;
        }
        for (QuestData data : quests) {
            if (!data.getQuestId().equals(questId)) continue;
            return data;
        }
        return null;
    }

    public static List<ItemStack> removeEmptyItemStacks(List<ItemStack> givenItems) {
        ArrayList<ItemStack> itemsToReturn = new ArrayList<ItemStack>();
        for (ItemStack item : givenItems) {
            if (item.func_190926_b()) continue;
            itemsToReturn.add(item);
        }
        return itemsToReturn;
    }

    protected static void addRewardItems(QuestData data, List<ItemStack> givenItems) {
        if (QuestBase.getRewardItems(data) == null || givenItems == null) {
            return;
        }
        givenItems.addAll(QuestBase.getRewardItems(data));
    }

    public static Province chooseRandomProvince(Province exclude, World world, boolean mustHaveLord) {
        List<Province> provinces = QuestBase.getAllProvinces(world);
        if (provinces.size() < 2) {
            return null;
        }
        Collections.shuffle(provinces);
        for (Province p : provinces) {
            if (exclude != null && p.id == exclude.id || mustHaveLord && !p.hasLord) continue;
            return p;
        }
        return null;
    }

    public static class InsufficientItems
    extends Exception {
        public InsufficientItems(String message) {
            super(message);
        }
    }
}

