/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.player;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapability;
import net.torocraft.toroquest.civilization.quests.util.QuestData;

public abstract class PlayerCivilization {
    protected Map<CivilizationType, Integer> reputations = new HashMap<CivilizationType, Integer>();
    protected Set<QuestData> quests = new HashSet<QuestData>();
    protected Set<QuestData> nextQuests = new HashSet<QuestData>();
    protected Map<UUID, Integer> completedQuestsByProvince = new HashMap<UUID, Integer>();
    protected Integer completedQuests = 0;
    protected Province inCiv;

    public abstract EntityPlayer getPlayer();

    public NBTTagCompound writeNBT() {
        NBTTagCompound c = new NBTTagCompound();
        c.func_74782_a("reputations", (NBTBase)this.buildNBTReputationList());
        c.func_74782_a("quests", (NBTBase)this.buildQuestCompound(this.quests));
        c.func_74782_a("nextQuests", (NBTBase)this.buildQuestCompound(this.nextQuests));
        c.func_74768_a("completedQuests", this.completedQuests.intValue());
        c.func_74782_a("completedQuestsByProvince", (NBTBase)this.buildCompletedQuestsByProvince());
        if (this.inCiv != null) {
            c.func_74782_a("inCiv", (NBTBase)this.inCiv.writeNBT());
        } else {
            c.func_82580_o("inCiv");
        }
        return c;
    }

    protected NBTTagList buildNBTReputationList() {
        NBTTagList repList = new NBTTagList();
        for (Map.Entry<CivilizationType, Integer> rep : this.reputations.entrySet()) {
            if (rep.getValue() == null || rep.getKey() == null) continue;
            repList.func_74742_a((NBTBase)PlayerCivilization.buildNBTReputationListItem(rep.getKey(), rep.getValue()));
        }
        return repList;
    }

    private NBTTagList buildQuestCompound(Set<QuestData> quests) {
        NBTTagList repList = new NBTTagList();
        for (QuestData data : quests) {
            if (data == null || !data.isValid()) continue;
            repList.func_74742_a((NBTBase)data.writeNBT());
        }
        return repList;
    }

    private NBTTagCompound buildCompletedQuestsByProvince() {
        NBTTagCompound c = new NBTTagCompound();
        for (Map.Entry<UUID, Integer> e : this.completedQuestsByProvince.entrySet()) {
            if (e.getKey() == null || e.getValue() == null) continue;
            c.func_74768_a(e.getKey().toString(), e.getValue().intValue());
        }
        return c;
    }

    private static String s(CivilizationType civ) {
        try {
            return civ.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static NBTTagCompound buildNBTReputationListItem(CivilizationType civ, int rep) {
        NBTTagCompound c = new NBTTagCompound();
        c.func_74778_a("civ", PlayerCivilization.s(civ));
        c.func_74768_a("amount", rep);
        return c;
    }

    private HashMap<CivilizationType, Integer> defaultRepMap() {
        HashMap<CivilizationType, Integer> repMap = new HashMap<CivilizationType, Integer>();
        for (CivilizationType civ : CivilizationType.values()) {
            repMap.put(civ, 0);
        }
        return repMap;
    }

    public void readNBT(NBTBase nbt) {
        if (nbt == null || !(nbt instanceof NBTTagCompound)) {
            this.reputations = this.defaultRepMap();
            this.inCiv = null;
            return;
        }
        NBTTagCompound b = (NBTTagCompound)nbt;
        this.reputations = this.readNBTReputationList(b.func_74781_a("reputations"));
        this.quests = this.readQuests(b.func_74781_a("quests"));
        this.nextQuests = this.readQuests(b.func_74781_a("nextQuests"));
        this.completedQuests = b.func_74762_e("completedQuests");
        this.completedQuestsByProvince = this.readCompletedQuestsByProvince(b.func_74775_l("completedQuestsByProvince"));
        NBTBase civTag = b.func_74781_a("inCiv");
        if (civTag != null && civTag instanceof NBTTagCompound) {
            this.inCiv = new Province();
            this.inCiv.readNBT((NBTTagCompound)civTag);
        } else {
            this.inCiv = null;
        }
    }

    private Set<QuestData> readQuests(NBTBase tag) {
        HashSet<QuestData> quests = new HashSet<QuestData>();
        if (tag == null || !(tag instanceof NBTTagList)) {
            return quests;
        }
        NBTTagList list = (NBTTagList)tag;
        for (int i = 0; i < list.func_74745_c(); ++i) {
            QuestData d = new QuestData();
            d.readNBT(list.func_150305_b(i), this.getPlayer());
            if (!d.isValid()) continue;
            quests.add(d);
        }
        return quests;
    }

    private Map<CivilizationType, Integer> readNBTReputationList(NBTBase tag) {
        HashMap<CivilizationType, Integer> reputations = this.defaultRepMap();
        if (tag == null || !(tag instanceof NBTTagList)) {
            return reputations;
        }
        NBTTagList list = (NBTTagList)tag;
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound c = list.func_150305_b(i);
            reputations.put(this.e(c.func_74779_i("civ")), c.func_74762_e("amount"));
        }
        return reputations;
    }

    private Map<UUID, Integer> readCompletedQuestsByProvince(NBTTagCompound tag) {
        HashMap<UUID, Integer> m = new HashMap<UUID, Integer>();
        for (String provinceId : tag.func_150296_c()) {
            try {
                m.put(UUID.fromString(provinceId), tag.func_74762_e(provinceId));
            }
            catch (Exception exception) {}
        }
        return m;
    }

    private CivilizationType e(String s) {
        try {
            return CivilizationType.valueOf(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class PlayerCivilizationStorage
    implements Capability.IStorage<PlayerCivilizationCapability> {
        public NBTBase writeNBT(Capability<PlayerCivilizationCapability> capability, PlayerCivilizationCapability instance, EnumFacing side) {
            return instance.writeNBT();
        }

        public void readNBT(Capability<PlayerCivilizationCapability> capability, PlayerCivilizationCapability instance, EnumFacing side, NBTBase nbt) {
            instance.readNBT(nbt);
        }
    }
}

