/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization;

import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.torocraft.toroquest.civilization.CivilizationType;

public class Province {
    public UUID id;
    public String name;
    public boolean hasLord;
    public int chunkX;
    public int chunkZ;
    public int lowerVillageBoundX;
    public int upperVillageBoundX;
    public int lowerVillageBoundZ;
    public int upperVillageBoundZ;
    public int xLength;
    public int zLength;
    public int area;
    public CivilizationType civilization;

    public void readNBT(NBTTagCompound c) {
        this.id = this.uuid(c.func_74779_i("id"));
        this.chunkX = c.func_74762_e("chunkX");
        this.chunkZ = c.func_74762_e("chunkZ");
        this.name = c.func_74779_i("name");
        this.lowerVillageBoundX = c.func_74762_e("lX");
        this.upperVillageBoundX = c.func_74762_e("uX");
        this.lowerVillageBoundZ = c.func_74762_e("lZ");
        this.upperVillageBoundZ = c.func_74762_e("uZ");
        this.civilization = this.e(c.func_74779_i("civilization"));
        this.hasLord = c.func_74767_n("hasLord");
        this.computeSize();
    }

    private UUID uuid(String s) {
        try {
            return UUID.fromString(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    private CivilizationType e(String s) {
        try {
            return CivilizationType.valueOf(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void addToBoundsAndRecenter(int newChunkX, int newChunkZ) {
        this.lowerVillageBoundX = Math.min(this.lowerVillageBoundX, newChunkX);
        this.upperVillageBoundX = Math.max(this.upperVillageBoundX, newChunkX);
        this.lowerVillageBoundZ = Math.min(this.lowerVillageBoundZ, newChunkZ);
        this.upperVillageBoundZ = Math.max(this.upperVillageBoundZ, newChunkZ);
        this.computeSize();
        this.recenter();
    }

    private void recenter() {
        this.chunkX = this.lowerVillageBoundX + this.xLength / 2;
        this.chunkZ = this.lowerVillageBoundZ + this.zLength / 2;
    }

    public void computeSize() {
        this.xLength = Math.abs(this.upperVillageBoundX - this.lowerVillageBoundX) + 1;
        this.zLength = Math.abs(this.upperVillageBoundZ - this.lowerVillageBoundZ) + 1;
        this.area = this.xLength * this.zLength;
    }

    public NBTTagCompound writeNBT() {
        NBTTagCompound c = new NBTTagCompound();
        c.func_74778_a("id", this.s(this.id));
        c.func_74778_a("civilization", this.s(this.civilization));
        c.func_74768_a("chunkX", this.chunkX);
        c.func_74768_a("chunkZ", this.chunkZ);
        c.func_74768_a("lX", this.lowerVillageBoundX);
        c.func_74768_a("uX", this.upperVillageBoundX);
        c.func_74768_a("lZ", this.lowerVillageBoundZ);
        c.func_74768_a("uZ", this.upperVillageBoundZ);
        c.func_74757_a("hasLord", this.hasLord);
        if (this.name != null && this.name.trim().length() > 0) {
            c.func_74778_a("name", this.name);
        }
        return c;
    }

    private String s(UUID s) {
        try {
            return s.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(" of ").append(this.s(this.civilization).toLowerCase());
        sb.append(" at [").append(this.chunkX * 16).append(",").append(this.chunkZ * 16).append("]");
        if (this.hasLord) {
            sb.append(" has lord");
        } else {
            sb.append(" no lord");
        }
        return sb.toString();
    }

    private String s(CivilizationType civ) {
        if (civ == null) {
            return "";
        }
        return civ.toString();
    }

    public double chunkDistanceSq(int toChunkX, int toChunkZ) {
        double dx = (double)this.chunkX - (double)toChunkX;
        double dz = (double)this.chunkZ - (double)toChunkZ;
        return dx * dx + dz * dz;
    }
}

