/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.configuration.ConfigurationHandler;
import net.torocraft.toroquest.util.Hud;
import net.torocraft.toroquest.util.ToroGuiUtils;

public class CivilizationOverlayHandler
extends Hud {
    String displayPosition;
    private final int PADDING_FROM_EDGE = 5;
    int screenWidth;
    int screenHeight;
    int badgeWidth = 20;
    int badgeHeight = 25;

    public CivilizationOverlayHandler(Minecraft mc) {
        super(mc, 20, 10);
    }

    @Override
    public void render(int screenWidth, int screenHeight) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        EntityPlayerSP player = this.mc.field_71439_g;
        if (player.field_71093_bK != 0) {
            return;
        }
        Province civ = PlayerCivilizationCapabilityImpl.get((EntityPlayer)player).getInCivilization();
        if (civ == null || civ.civilization == null) {
            return;
        }
        this.displayPosition = ConfigurationHandler.repDisplayPosition;
        if ("OFF".equals(this.displayPosition)) {
            return;
        }
        this.drawCurrentCivilizationIcon(civ, player);
    }

    private void drawCurrentCivilizationIcon(Province civ, EntityPlayerSP player) {
        this.drawReputationText(civ, player);
        this.drawCivilizationBadge(civ.civilization);
    }

    private void drawReputationText(Province civ, EntityPlayerSP player) {
        int textX = this.determineTextX();
        int textY = this.determineIconY();
        if (this.displayPosition.contains("RIGHT")) {
            this.drawRightString(Integer.toString(PlayerCivilizationCapabilityImpl.get((EntityPlayer)player).getReputation(civ.civilization), 10) + " Rep", textX, textY, 0xFFFFFF);
            this.drawRightString(PlayerCivilizationCapabilityImpl.get((EntityPlayer)player).getReputationLevel(civ.civilization).getLocalname(), textX, textY += 10, 0xFFFFFF);
            this.drawRightString(civ.name, textX, textY += 10, 0xFFFFFF);
        } else {
            this.drawString(Integer.toString(PlayerCivilizationCapabilityImpl.get((EntityPlayer)player).getReputation(civ.civilization), 10) + " Rep", textX, textY, 0xFFFFFF);
            this.drawString(PlayerCivilizationCapabilityImpl.get((EntityPlayer)player).getReputationLevel(civ.civilization).getLocalname(), textX, textY += 10, 0xFFFFFF);
            this.drawString(civ.name, textX, textY += 10, 0xFFFFFF);
        }
    }

    private void drawCivilizationBadge(CivilizationType civType) {
        int badgeX = this.determineBadgeX();
        int badgeY = this.determineIconY();
        GlStateManager.func_179123_a();
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        ToroGuiUtils.drawOverlayIcon(this.mc, badgeX - 2, badgeY, 0, 96, 20, 27);
        ToroGuiUtils.drawOverlayIcon(this.mc, badgeX, badgeY + 3, this.iconIndex(civType), 0);
        GlStateManager.func_179099_b();
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
    }

    private int determineTextX() {
        int x = 5 + this.badgeWidth;
        if (this.displayPosition.contains("RIGHT")) {
            x = this.screenWidth - 5 - this.badgeWidth;
        }
        if (this.displayPosition.contains("CENTER")) {
            x = (this.screenWidth + this.badgeWidth + 5) / 2;
        }
        return x + ConfigurationHandler.repDisplayX;
    }

    private int determineBadgeX() {
        int x = 5;
        if (this.displayPosition.contains("RIGHT")) {
            x = this.screenWidth - this.badgeWidth;
        }
        if (this.displayPosition.contains("CENTER")) {
            x = (this.screenWidth - this.badgeWidth) / 2;
        }
        return x + ConfigurationHandler.repDisplayX;
    }

    private int determineIconY() {
        int y = 5;
        if (this.displayPosition.contains("BOTTOM")) {
            y = this.screenHeight - 5 - this.badgeHeight;
        }
        return y + ConfigurationHandler.repDisplayY;
    }

    private int iconIndex(CivilizationType civ) {
        switch (civ) {
            case EARTH: {
                return 0;
            }
            case FIRE: {
                return 5;
            }
            case MOON: {
                return 4;
            }
            case SUN: {
                return 1;
            }
            case WATER: {
                return 2;
            }
            case WIND: {
                return 3;
            }
        }
        return 0;
    }
}

